/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.labs.mosaic.core.geometry.point;

import com.databricks.labs.mosaic.core.geometry.GeometryReader;
import com.databricks.labs.mosaic.core.geometry.MosaicGeometry;
import com.databricks.labs.mosaic.core.geometry.MosaicGeometryJTS$;
import com.databricks.labs.mosaic.core.geometry.point.MosaicPoint;
import com.databricks.labs.mosaic.core.geometry.point.MosaicPointJTS;
import com.databricks.labs.mosaic.core.types.model.Coordinates;
import com.databricks.labs.mosaic.core.types.model.GeometryTypeEnum$;
import com.databricks.labs.mosaic.core.types.model.InternalCoord;
import com.databricks.labs.mosaic.core.types.model.InternalGeometry;
import com.databricks.labs.mosaic.core.types.model.InternalGeometry$;
import org.apache.spark.sql.catalyst.InternalRow;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.Point;
import scala.Enumeration;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.mutable.ArrayOps;
import scala.runtime.BoxesRunTime;

public final class MosaicPointJTS$
implements GeometryReader,
Serializable {
    public static MosaicPointJTS$ MODULE$;
    private final int defaultSpatialReferenceId;

    static {
        new MosaicPointJTS$();
    }

    @Override
    public int defaultSpatialReferenceId() {
        return this.defaultSpatialReferenceId;
    }

    @Override
    public void com$databricks$labs$mosaic$core$geometry$GeometryReader$_setter_$defaultSpatialReferenceId_$eq(int x$1) {
        this.defaultSpatialReferenceId = x$1;
    }

    public MosaicPointJTS apply(Coordinates geoCoord) {
        return this.apply(new Coordinate(geoCoord.lng(), geoCoord.lat()), this.defaultSpatialReferenceId());
    }

    public MosaicPointJTS apply(Coordinate coord, int srid) {
        GeometryFactory gf = new GeometryFactory();
        Point point = gf.createPoint(coord);
        point.setSRID(srid);
        return new MosaicPointJTS(point);
    }

    public MosaicPointJTS apply(Seq<Object> coords) {
        MosaicPointJTS mosaicPointJTS;
        GeometryFactory gf = new GeometryFactory();
        if (coords.length() == 3) {
            Point point = gf.createPoint(new Coordinate(BoxesRunTime.unboxToDouble(coords.apply(false)), BoxesRunTime.unboxToDouble(coords.apply(true)), BoxesRunTime.unboxToDouble(coords.apply(2))));
            mosaicPointJTS = new MosaicPointJTS(point);
        } else {
            Point point = gf.createPoint(new Coordinate(BoxesRunTime.unboxToDouble(coords.apply(false)), BoxesRunTime.unboxToDouble(coords.apply(true))));
            mosaicPointJTS = new MosaicPointJTS(point);
        }
        return mosaicPointJTS;
    }

    @Override
    public MosaicGeometry fromInternal(InternalRow row) {
        GeometryFactory gf = new GeometryFactory();
        InternalGeometry internalGeom = InternalGeometry$.MODULE$.apply(row);
        InternalCoord coordinate = (InternalCoord)new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])internalGeom.boundaries())).head())).head();
        Point point = gf.createPoint(coordinate.toCoordinate());
        point.setSRID(internalGeom.srid());
        return new MosaicPointJTS(point);
    }

    @Override
    public <T extends MosaicGeometry> MosaicPointJTS fromSeq(Seq<T> geomSeq, Enumeration.Value geomType) {
        GeometryFactory gf = new GeometryFactory();
        int spatialReference = ((MosaicGeometry)geomSeq.head()).getSpatialReference();
        Enumeration.Value value = GeometryTypeEnum$.MODULE$.fromString(((MosaicGeometry)geomSeq.head()).getGeometryType());
        Enumeration.Value value2 = GeometryTypeEnum$.MODULE$.POINT();
        Enumeration.Value value3 = value;
        if (value2 != null ? !((Object)value2).equals(value3) : value3 != null) {
            if (value != null) {
                Enumeration.Value value4 = value;
                throw new UnsupportedOperationException(new StringBuilder(57).append("MosaicGeometry.fromSeq() cannot create ").append(geomType.toString()).append(" from ").append(value4.toString()).append(" geometries.").toString());
            }
            throw new MatchError(value);
        }
        MosaicPoint extractedPoint = (MosaicPoint)geomSeq.head();
        Point point = gf.createPoint(extractedPoint.coord());
        Point newGeom = point;
        newGeom.setSRID(spatialReference);
        return this.apply(newGeom);
    }

    public <T extends MosaicGeometry> Enumeration.Value fromSeq$default$2() {
        return GeometryTypeEnum$.MODULE$.POINT();
    }

    public MosaicPointJTS apply(Geometry geom) {
        return new MosaicPointJTS((Point)geom);
    }

    @Override
    public MosaicGeometry fromWKB(byte[] wkb) {
        return MosaicGeometryJTS$.MODULE$.fromWKB(wkb);
    }

    @Override
    public MosaicGeometry fromWKT(String wkt) {
        return MosaicGeometryJTS$.MODULE$.fromWKT(wkt);
    }

    @Override
    public MosaicGeometry fromJSON(String geoJson) {
        return MosaicGeometryJTS$.MODULE$.fromJSON(geoJson);
    }

    @Override
    public MosaicGeometry fromHEX(String hex) {
        return MosaicGeometryJTS$.MODULE$.fromHEX(hex);
    }

    private Object readResolve() {
        return MODULE$;
    }

    private MosaicPointJTS$() {
        MODULE$ = this;
        GeometryReader.$init$(this);
    }
}

