"""waylay-beta build configuration"""
from setuptools import setup, find_namespace_packages
import versioneer

setup(
    name='waylay-beta',
    description='beta release of the Waylay Python SDK',
    version=versioneer.get_version(),
    cmdclass=versioneer.get_cmdclass(),
    url='https://docs.waylay.io/api/sdk/python',
    author='Waylay',
    author_email='info@waylay.io',
    license='ISC',
    license_file='LICENSE.txt',
    packages=find_namespace_packages(),
    package_data={"waylay": ["py.typed"]},
    include_package_data=True,
    install_requires=[
        'httpx',
        'simple-rest-client',
        'appdirs',
        'pycrypto',
        'PyJWT',
        'pandas',
        'isodate',
        'joblib'
    ],
    extras_require={
        'dev': [
            'pytest',
            'pytest-cov',
            'pytest-mock',
            'mock',
            'pylint',
            'pycodestyle',
            'autopep8',
            'mypy',
            'typing-inspect',
            'sklearn'
        ],
        ':python_version == "3.6"': [
            'dataclasses'
        ],
        'ml': [
            'sklearn',
            'tensorflow'
        ]
    },
    setup_requires=[
        'setuptools-pep8'
    ],
    python_requires='>=3.6'
)
