# -*- coding: utf-8 -*-
# Copyright 2020 Cohesity Inc.


class MapperInfo(object):

    """Implementation of the 'MapperInfo' model.

    Information about a mapper.

    Attributes:
        code (string):  The code of the mapper in the specified language.
            Should be UTF-8.
        id (int): Mapper ID generated by system. Absent when user is creating
            a new mapper. Mandatory in all other use cases.
        is_system_defined (bool): Whether the mapper is system defined.
        jar_name (string): User can write their own mapper/reducer or
            upload jar files containing mappers and reducers. If this mapper
            was part of a jar file, then this field will have the JAR name.
        jar_path (string): path of JAR in which this mapper was found. This
            is applicable only when this mapper was uploaded via JAR.
        language (int): Language of the mapper.
        name (string): Name of the mapper.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "code": 'code',
        "id": 'id',
        "is_system_defined": 'isSystemDefined',
        "jar_name": 'jarName',
        "jar_path":'jarPath',
        "language":'language',
        "name":'name'
    }

    def __init__(self,
                 code=None,
                 id=None,
                 is_system_defined=None,
                 jar_name=None,
                 jar_path=None,
                 language=None,
                 name=None):
        """Constructor for the MapperInfo class"""

        # Initialize members of the class
        self.code = code
        self.id = id
        self.is_system_defined = is_system_defined
        self.jar_name = jar_name
        self.jar_path = jar_path
        self.language = language
        self.name = name

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object as
            obtained from the deserialization of the server's response. The keys
            MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """
        if dictionary is None:
            return None

        # Extract variables from the dictionary
        code = dictionary.get('code')
        id = dictionary.get('id')
        is_system_defined = dictionary.get('isSystemDefined')
        jar_name = dictionary.get('jarName')
        jar_path = dictionary.get('jarPath')
        language = dictionary.get('language')
        name = dictionary.get('name')

        # Return an object of this model
        return cls(code,
                   id,
                   is_system_defined,
                   jar_name,
                   jar_path,
                   language,
                   name)


