from __future__ import annotations

from typing import AsyncIterator, Iterable, Protocol

from .models import Account, Order, OrderReplaceRequest, OrderSubmitRequest, Position, Quote


class BrokerAdapter(Protocol):
    def get_account(self) -> Account: ...
    def get_positions(self) -> list[Position]: ...
    def submit_order(self, req: OrderSubmitRequest) -> Order: ...
    def get_order(self, order_id: str) -> Order: ...
    def cancel_order(self, order_id: str) -> Order: ...
    def replace_order(self, order_id: str, req: OrderReplaceRequest) -> Order: ...
    def stream_quotes(self, symbols: Iterable[str]) -> AsyncIterator[Quote]: ...
