# coding: utf-8

"""
    FINBOURNE Notifications API

    FINBOURNE Technology  # noqa: E501

    Contact: info@finbourne.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from typing import Any, Dict, Optional
from pydantic.v1 import StrictStr, Field, BaseModel, Field, StrictStr 

class NotificationStatus(BaseModel):
    """
    The status object of a notification  # noqa: E501
    """
    result:  Optional[StrictStr] = Field(None,alias="result", description="The status of the notification") 
    last_updated: Optional[datetime] = Field(None, alias="lastUpdated", description="The time at which the notification status was last updated")
    __properties = ["result", "lastUpdated"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def __str__(self):
        """For `print` and `pprint`"""
        return pprint.pformat(self.dict(by_alias=False))

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> NotificationStatus:
        """Create an instance of NotificationStatus from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # set to None if result (nullable) is None
        # and __fields_set__ contains the field
        if self.result is None and "result" in self.__fields_set__:
            _dict['result'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> NotificationStatus:
        """Create an instance of NotificationStatus from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return NotificationStatus.parse_obj(obj)

        _obj = NotificationStatus.parse_obj({
            "result": obj.get("result"),
            "last_updated": obj.get("lastUpdated")
        })
        return _obj
