# coding: utf-8

"""
    FINBOURNE Notifications API

    FINBOURNE Technology  # noqa: E501

    Contact: info@finbourne.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Any, Dict, Optional
from pydantic.v1 import StrictStr, Field, BaseModel, Field, constr, validator 

class ManualEventBody(BaseModel):
    """
    The body of the manual event  # noqa: E501
    """
    subject:  StrictStr = Field(...,alias="subject", description="The subject of the manual event") 
    message:  StrictStr = Field(...,alias="message", description="The message of the manual event") 
    json_message: Optional[Any] = Field(None, alias="jsonMessage", description="The JSON message of the manual event")
    __properties = ["subject", "message", "jsonMessage"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def __str__(self):
        """For `print` and `pprint`"""
        return pprint.pformat(self.dict(by_alias=False))

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> ManualEventBody:
        """Create an instance of ManualEventBody from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # set to None if json_message (nullable) is None
        # and __fields_set__ contains the field
        if self.json_message is None and "json_message" in self.__fields_set__:
            _dict['jsonMessage'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> ManualEventBody:
        """Create an instance of ManualEventBody from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return ManualEventBody.parse_obj(obj)

        _obj = ManualEventBody.parse_obj({
            "subject": obj.get("subject"),
            "message": obj.get("message"),
            "json_message": obj.get("jsonMessage")
        })
        return _obj
