# coding: utf-8

"""
    FINBOURNE Notifications API

    FINBOURNE Technology  # noqa: E501

    Contact: info@finbourne.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Any, Dict, List
from pydantic.v1 import StrictStr, Field, BaseModel, Field, StrictStr, conlist, constr 
from lusid_notifications.models.attempt import Attempt
from lusid_notifications.models.resource_id import ResourceId

class Delivery(BaseModel):
    """
    Delivery
    """
    id:  StrictStr = Field(...,alias="id", description="The identifier of the delivery.") 
    event_id:  StrictStr = Field(...,alias="eventId", description="The identifier of the associated event.") 
    subscription_id: ResourceId = Field(..., alias="subscriptionId")
    notification_id:  StrictStr = Field(...,alias="notificationId", description="The identifier of the associated notification.") 
    delivery_channel:  StrictStr = Field(...,alias="deliveryChannel", description="The delivery channel of the message.") 
    message_details:  StrictStr = Field(...,alias="messageDetails", description="The Details of the delivery message as JSON string.") 
    attempts: conlist(Attempt) = Field(..., description="A list of all the delivery attempts made for this message.")
    __properties = ["id", "eventId", "subscriptionId", "notificationId", "deliveryChannel", "messageDetails", "attempts"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def __str__(self):
        """For `print` and `pprint`"""
        return pprint.pformat(self.dict(by_alias=False))

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Delivery:
        """Create an instance of Delivery from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of subscription_id
        if self.subscription_id:
            _dict['subscriptionId'] = self.subscription_id.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in attempts (list)
        _items = []
        if self.attempts:
            for _item in self.attempts:
                if _item:
                    _items.append(_item.to_dict())
            _dict['attempts'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> Delivery:
        """Create an instance of Delivery from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return Delivery.parse_obj(obj)

        _obj = Delivery.parse_obj({
            "id": obj.get("id"),
            "event_id": obj.get("eventId"),
            "subscription_id": ResourceId.from_dict(obj.get("subscriptionId")) if obj.get("subscriptionId") is not None else None,
            "notification_id": obj.get("notificationId"),
            "delivery_channel": obj.get("deliveryChannel"),
            "message_details": obj.get("messageDetails"),
            "attempts": [Attempt.from_dict(_item) for _item in obj.get("attempts")] if obj.get("attempts") is not None else None
        })
        return _obj
