# coding: utf-8

"""
    FINBOURNE Notifications API

    FINBOURNE Technology  # noqa: E501

    Contact: info@finbourne.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Any, Dict, Optional
from pydantic.v1 import StrictStr, Field, BaseModel, Field, StrictStr, validator 

class AzureServiceBusTypeResponse(BaseModel):
    """
    Holds readonly information about an Azure Service Bus notification  # noqa: E501
    """
    type:  Optional[StrictStr] = Field(None,alias="type", description="The type of delivery mechanism for this notification") 
    namespace_ref:  Optional[StrictStr] = Field(None,alias="namespaceRef", description="Reference to namespace from Configuration Store") 
    queue_name_ref:  Optional[StrictStr] = Field(None,alias="queueNameRef", description="Reference to queue name from Configuration Store") 
    body:  Optional[StrictStr] = Field(None,alias="body", description="The body of the Azure service bus Message") 
    tenant_id_ref:  Optional[StrictStr] = Field(None,alias="tenantIdRef", description="Reference to tenant id  from Configuration Store") 
    client_id_ref:  Optional[StrictStr] = Field(None,alias="clientIdRef", description="Reference to client id from Configuration Store") 
    client_secret_ref:  Optional[StrictStr] = Field(None,alias="clientSecretRef", description="Reference to client secret from Configuration Store") 
    __properties = ["type", "namespaceRef", "queueNameRef", "body", "tenantIdRef", "clientIdRef", "clientSecretRef"]

    @validator('type')
    def type_validate_enum(cls, value):
        """Validates the enum"""

        # Finbourne have removed enum validation on all models, except for this use case:
        # Workflow and notification application SDK use the property name 'type' as the discriminator on a number of classes.
        # During instantiation, the value of 'type' is checked against the enum values, 
        

        # check it's a class that uses the 'type' property as a discriminator
        # list of classes can be found by searching for 'actual_instance: Union[' in the generated code
        if 'AzureServiceBusTypeResponse' not in [ 
                                    # For notification application classes
                                    'AmazonSqsNotificationType',
                                    'AmazonSqsNotificationTypeResponse',
                                    'AmazonSqsPrincipalAuthNotificationType',
                                    'AmazonSqsPrincipalAuthNotificationTypeResponse',
                                    'AzureServiceBusTypeResponse',
                                    'AzureServiceBusNotificationType',
                                    'EmailNotificationType',
                                    'EmailNotificationTypeResponse',
                                    'SmsNotificationType',
                                    'SmsNotificationTypeResponse',
                                    'WebhookNotificationType',
                                    'WebhookNotificationTypeResponse',
                        
                                    # For workflow application classes
                                    'CreateChildTasksAction', 
                                    'RunWorkerAction', 
                                    'TriggerParentTaskAction',
                                    'CreateChildTasksActionResponse', 
                                    'RunWorkerActionResponse',
                                    'TriggerParentTaskActionResponse',
                                    'CreateNewTaskActivity',
                                    'UpdateMatchingTasksActivity',
                                    'CreateNewTaskActivityResponse', 
                                    'UpdateMatchingTasksActivityResponse',
                                    'Fail', 
                                    'GroupReconciliation', 
                                    'HealthCheck', 
                                    'LuminesceView', 
                                    'SchedulerJob', 
                                    'Sleep',
                                    'FailResponse', 
                                    'GroupReconciliationResponse', 
                                    'HealthCheckResponse', 
                                    'LuminesceViewResponse', 
                                    'SchedulerJobResponse', 
                                    'SleepResponse']:
           return value
        
        # Only validate the 'type' property of the class
        if "type" != "type":
            return value

        if value is None:
            return value

        if value not in ('AzureServiceBus'):
            raise ValueError("must be one of enum values ('AzureServiceBus')")
        return value

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def __str__(self):
        """For `print` and `pprint`"""
        return pprint.pformat(self.dict(by_alias=False))

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> AzureServiceBusTypeResponse:
        """Create an instance of AzureServiceBusTypeResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # set to None if type (nullable) is None
        # and __fields_set__ contains the field
        if self.type is None and "type" in self.__fields_set__:
            _dict['type'] = None

        # set to None if namespace_ref (nullable) is None
        # and __fields_set__ contains the field
        if self.namespace_ref is None and "namespace_ref" in self.__fields_set__:
            _dict['namespaceRef'] = None

        # set to None if queue_name_ref (nullable) is None
        # and __fields_set__ contains the field
        if self.queue_name_ref is None and "queue_name_ref" in self.__fields_set__:
            _dict['queueNameRef'] = None

        # set to None if body (nullable) is None
        # and __fields_set__ contains the field
        if self.body is None and "body" in self.__fields_set__:
            _dict['body'] = None

        # set to None if tenant_id_ref (nullable) is None
        # and __fields_set__ contains the field
        if self.tenant_id_ref is None and "tenant_id_ref" in self.__fields_set__:
            _dict['tenantIdRef'] = None

        # set to None if client_id_ref (nullable) is None
        # and __fields_set__ contains the field
        if self.client_id_ref is None and "client_id_ref" in self.__fields_set__:
            _dict['clientIdRef'] = None

        # set to None if client_secret_ref (nullable) is None
        # and __fields_set__ contains the field
        if self.client_secret_ref is None and "client_secret_ref" in self.__fields_set__:
            _dict['clientSecretRef'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> AzureServiceBusTypeResponse:
        """Create an instance of AzureServiceBusTypeResponse from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return AzureServiceBusTypeResponse.parse_obj(obj)

        _obj = AzureServiceBusTypeResponse.parse_obj({
            "type": obj.get("type"),
            "namespace_ref": obj.get("namespaceRef"),
            "queue_name_ref": obj.get("queueNameRef"),
            "body": obj.get("body"),
            "tenant_id_ref": obj.get("tenantIdRef"),
            "client_id_ref": obj.get("clientIdRef"),
            "client_secret_ref": obj.get("clientSecretRef")
        })
        return _obj
