# coding: utf-8

"""
    FINBOURNE Notifications API

    FINBOURNE Technology  # noqa: E501

    Contact: info@finbourne.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


import re  # noqa: F401
import io
import warnings

from pydantic.v1 import validate_arguments, ValidationError
from typing import overload, Optional, Union, Awaitable

from typing_extensions import Annotated
from pydantic.v1 import Field, StrictStr, constr, validator

from lusid_notifications.models.create_notification_request import CreateNotificationRequest
from lusid_notifications.models.notification import Notification
from lusid_notifications.models.resource_list_of_notification import ResourceListOfNotification
from lusid_notifications.models.update_notification_request import UpdateNotificationRequest

from lusid_notifications.api_client import ApiClient
from lusid_notifications.api_response import ApiResponse
from lusid_notifications.exceptions import (  # noqa: F401
    ApiTypeError,
    ApiValueError
)
from lusid_notifications.extensions.configuration_options import ConfigurationOptions

# ensure templated type usages are imported
from pydantic.v1 import Field, StrictStr
from typing import Optional
from typing_extensions import Annotated

class NotificationsApi:
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None) -> None:
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client


    @overload
    async def create_notification(self, scope : Annotated[StrictStr, Field(..., description="The scope that identifies a subscription")], code : Annotated[StrictStr, Field(..., description="The code that identifies a subscription")], create_notification_request : Annotated[CreateNotificationRequest, Field(..., description="The data to create a notification")], **kwargs) -> Notification:  # noqa: E501
        ...

    @overload
    def create_notification(self, scope : Annotated[StrictStr, Field(..., description="The scope that identifies a subscription")], code : Annotated[StrictStr, Field(..., description="The code that identifies a subscription")], create_notification_request : Annotated[CreateNotificationRequest, Field(..., description="The data to create a notification")], async_req: Optional[bool]=True, **kwargs) -> Notification:  # noqa: E501
        ...

    @validate_arguments
    def create_notification(self, scope : Annotated[StrictStr, Field(..., description="The scope that identifies a subscription")], code : Annotated[StrictStr, Field(..., description="The code that identifies a subscription")], create_notification_request : Annotated[CreateNotificationRequest, Field(..., description="The data to create a notification")], async_req: Optional[bool]=None, **kwargs) -> Union[Notification, Awaitable[Notification]]:  # noqa: E501
        """CreateNotification: Add a Notification to a Subscription.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_notification(scope, code, create_notification_request, async_req=True)
        >>> result = thread.get()

        :param scope: The scope that identifies a subscription (required)
        :type scope: str
        :param code: The code that identifies a subscription (required)
        :type code: str
        :param create_notification_request: The data to create a notification (required)
        :type create_notification_request: CreateNotificationRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: Notification
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the create_notification_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.create_notification_with_http_info(scope, code, create_notification_request, **kwargs)  # noqa: E501

    @validate_arguments
    def create_notification_with_http_info(self, scope : Annotated[StrictStr, Field(..., description="The scope that identifies a subscription")], code : Annotated[StrictStr, Field(..., description="The code that identifies a subscription")], create_notification_request : Annotated[CreateNotificationRequest, Field(..., description="The data to create a notification")], **kwargs) -> ApiResponse:  # noqa: E501
        """CreateNotification: Add a Notification to a Subscription.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_notification_with_http_info(scope, code, create_notification_request, async_req=True)
        >>> result = thread.get()

        :param scope: The scope that identifies a subscription (required)
        :type scope: str
        :param code: The code that identifies a subscription (required)
        :type code: str
        :param create_notification_request: The data to create a notification (required)
        :type create_notification_request: CreateNotificationRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(Notification, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'scope',
            'code',
            'create_notification_request'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_notification" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['scope']:
            _path_params['scope'] = _params['scope']

        if _params['code']:
            _path_params['code'] = _params['code']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['create_notification_request'] is not None:
            _body_params = _params['create_notification_request']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json-patch+json', 'application/json', 'text/json', 'application/*+json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '201': "Notification",
            '400': "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/subscriptions/{scope}/{code}/notifications', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))


    @overload
    async def delete_notification(self, scope : Annotated[StrictStr, Field(..., description="The scope that identifies a subscription")], code : Annotated[StrictStr, Field(..., description="The code that identifies a subscription")], id : Annotated[StrictStr, Field(..., description="The unique identifier of the notification")], **kwargs) -> None:  # noqa: E501
        ...

    @overload
    def delete_notification(self, scope : Annotated[StrictStr, Field(..., description="The scope that identifies a subscription")], code : Annotated[StrictStr, Field(..., description="The code that identifies a subscription")], id : Annotated[StrictStr, Field(..., description="The unique identifier of the notification")], async_req: Optional[bool]=True, **kwargs) -> None:  # noqa: E501
        ...

    @validate_arguments
    def delete_notification(self, scope : Annotated[StrictStr, Field(..., description="The scope that identifies a subscription")], code : Annotated[StrictStr, Field(..., description="The code that identifies a subscription")], id : Annotated[StrictStr, Field(..., description="The unique identifier of the notification")], async_req: Optional[bool]=None, **kwargs) -> Union[None, Awaitable[None]]:  # noqa: E501
        """DeleteNotification: Delete a notification for a given subscription.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_notification(scope, code, id, async_req=True)
        >>> result = thread.get()

        :param scope: The scope that identifies a subscription (required)
        :type scope: str
        :param code: The code that identifies a subscription (required)
        :type code: str
        :param id: The unique identifier of the notification (required)
        :type id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the delete_notification_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.delete_notification_with_http_info(scope, code, id, **kwargs)  # noqa: E501

    @validate_arguments
    def delete_notification_with_http_info(self, scope : Annotated[StrictStr, Field(..., description="The scope that identifies a subscription")], code : Annotated[StrictStr, Field(..., description="The code that identifies a subscription")], id : Annotated[StrictStr, Field(..., description="The unique identifier of the notification")], **kwargs) -> ApiResponse:  # noqa: E501
        """DeleteNotification: Delete a notification for a given subscription.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_notification_with_http_info(scope, code, id, async_req=True)
        >>> result = thread.get()

        :param scope: The scope that identifies a subscription (required)
        :type scope: str
        :param code: The code that identifies a subscription (required)
        :type code: str
        :param id: The unique identifier of the notification (required)
        :type id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """

        _params = locals()

        _all_params = [
            'scope',
            'code',
            'id'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_notification" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['scope']:
            _path_params['scope'] = _params['scope']

        if _params['code']:
            _path_params['code'] = _params['code']

        if _params['id']:
            _path_params['id'] = _params['id']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {}

        return self.api_client.call_api(
            '/api/subscriptions/{scope}/{code}/notifications/{id}', 'DELETE',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))


    @overload
    async def get_notification(self, scope : Annotated[StrictStr, Field(..., description="The scope that identifies a subscription")], code : Annotated[StrictStr, Field(..., description="The code that identifies a subscription")], id : Annotated[StrictStr, Field(..., description="The unique identifier of the notification")], **kwargs) -> Notification:  # noqa: E501
        ...

    @overload
    def get_notification(self, scope : Annotated[StrictStr, Field(..., description="The scope that identifies a subscription")], code : Annotated[StrictStr, Field(..., description="The code that identifies a subscription")], id : Annotated[StrictStr, Field(..., description="The unique identifier of the notification")], async_req: Optional[bool]=True, **kwargs) -> Notification:  # noqa: E501
        ...

    @validate_arguments
    def get_notification(self, scope : Annotated[StrictStr, Field(..., description="The scope that identifies a subscription")], code : Annotated[StrictStr, Field(..., description="The code that identifies a subscription")], id : Annotated[StrictStr, Field(..., description="The unique identifier of the notification")], async_req: Optional[bool]=None, **kwargs) -> Union[Notification, Awaitable[Notification]]:  # noqa: E501
        """GetNotification: Get a notification on a subscription.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_notification(scope, code, id, async_req=True)
        >>> result = thread.get()

        :param scope: The scope that identifies a subscription (required)
        :type scope: str
        :param code: The code that identifies a subscription (required)
        :type code: str
        :param id: The unique identifier of the notification (required)
        :type id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: Notification
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the get_notification_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.get_notification_with_http_info(scope, code, id, **kwargs)  # noqa: E501

    @validate_arguments
    def get_notification_with_http_info(self, scope : Annotated[StrictStr, Field(..., description="The scope that identifies a subscription")], code : Annotated[StrictStr, Field(..., description="The code that identifies a subscription")], id : Annotated[StrictStr, Field(..., description="The unique identifier of the notification")], **kwargs) -> ApiResponse:  # noqa: E501
        """GetNotification: Get a notification on a subscription.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_notification_with_http_info(scope, code, id, async_req=True)
        >>> result = thread.get()

        :param scope: The scope that identifies a subscription (required)
        :type scope: str
        :param code: The code that identifies a subscription (required)
        :type code: str
        :param id: The unique identifier of the notification (required)
        :type id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(Notification, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'scope',
            'code',
            'id'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_notification" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['scope']:
            _path_params['scope'] = _params['scope']

        if _params['code']:
            _path_params['code'] = _params['code']

        if _params['id']:
            _path_params['id'] = _params['id']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "Notification",
            '400': "LusidValidationProblemDetails",
            '404': "str",
        }

        return self.api_client.call_api(
            '/api/subscriptions/{scope}/{code}/notifications/{id}', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))


    @overload
    async def list_notifications(self, scope : Annotated[StrictStr, Field(..., description="The scope that identifies a subscription")], code : Annotated[StrictStr, Field(..., description="The code that identifies a subscription")], **kwargs) -> ResourceListOfNotification:  # noqa: E501
        ...

    @overload
    def list_notifications(self, scope : Annotated[StrictStr, Field(..., description="The scope that identifies a subscription")], code : Annotated[StrictStr, Field(..., description="The code that identifies a subscription")], async_req: Optional[bool]=True, **kwargs) -> ResourceListOfNotification:  # noqa: E501
        ...

    @validate_arguments
    def list_notifications(self, scope : Annotated[StrictStr, Field(..., description="The scope that identifies a subscription")], code : Annotated[StrictStr, Field(..., description="The code that identifies a subscription")], async_req: Optional[bool]=None, **kwargs) -> Union[ResourceListOfNotification, Awaitable[ResourceListOfNotification]]:  # noqa: E501
        """ListNotifications: List all notifications on a subscription.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_notifications(scope, code, async_req=True)
        >>> result = thread.get()

        :param scope: The scope that identifies a subscription (required)
        :type scope: str
        :param code: The code that identifies a subscription (required)
        :type code: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ResourceListOfNotification
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the list_notifications_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.list_notifications_with_http_info(scope, code, **kwargs)  # noqa: E501

    @validate_arguments
    def list_notifications_with_http_info(self, scope : Annotated[StrictStr, Field(..., description="The scope that identifies a subscription")], code : Annotated[StrictStr, Field(..., description="The code that identifies a subscription")], **kwargs) -> ApiResponse:  # noqa: E501
        """ListNotifications: List all notifications on a subscription.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_notifications_with_http_info(scope, code, async_req=True)
        >>> result = thread.get()

        :param scope: The scope that identifies a subscription (required)
        :type scope: str
        :param code: The code that identifies a subscription (required)
        :type code: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(ResourceListOfNotification, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'scope',
            'code'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_notifications" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['scope']:
            _path_params['scope'] = _params['scope']

        if _params['code']:
            _path_params['code'] = _params['code']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "ResourceListOfNotification",
            '400': "LusidValidationProblemDetails",
            '404': "str",
        }

        return self.api_client.call_api(
            '/api/subscriptions/{scope}/{code}/notifications', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))


    @overload
    async def update_notification(self, scope : Annotated[StrictStr, Field(..., description="The scope that identifies a subscription")], code : Annotated[StrictStr, Field(..., description="The code that identifies a subscription")], id : Annotated[StrictStr, Field(..., description="The unique identifier of the notification")], update_notification_request : Annotated[UpdateNotificationRequest, Field(..., description="The data to update a notification")], **kwargs) -> Notification:  # noqa: E501
        ...

    @overload
    def update_notification(self, scope : Annotated[StrictStr, Field(..., description="The scope that identifies a subscription")], code : Annotated[StrictStr, Field(..., description="The code that identifies a subscription")], id : Annotated[StrictStr, Field(..., description="The unique identifier of the notification")], update_notification_request : Annotated[UpdateNotificationRequest, Field(..., description="The data to update a notification")], async_req: Optional[bool]=True, **kwargs) -> Notification:  # noqa: E501
        ...

    @validate_arguments
    def update_notification(self, scope : Annotated[StrictStr, Field(..., description="The scope that identifies a subscription")], code : Annotated[StrictStr, Field(..., description="The code that identifies a subscription")], id : Annotated[StrictStr, Field(..., description="The unique identifier of the notification")], update_notification_request : Annotated[UpdateNotificationRequest, Field(..., description="The data to update a notification")], async_req: Optional[bool]=None, **kwargs) -> Union[Notification, Awaitable[Notification]]:  # noqa: E501
        """UpdateNotification: Update a Notification for a Subscription  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_notification(scope, code, id, update_notification_request, async_req=True)
        >>> result = thread.get()

        :param scope: The scope that identifies a subscription (required)
        :type scope: str
        :param code: The code that identifies a subscription (required)
        :type code: str
        :param id: The unique identifier of the notification (required)
        :type id: str
        :param update_notification_request: The data to update a notification (required)
        :type update_notification_request: UpdateNotificationRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: Notification
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            message = "Error! Please call the update_notification_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data"  # noqa: E501
            raise ValueError(message)
        if async_req is not None:
            kwargs['async_req'] = async_req
        return self.update_notification_with_http_info(scope, code, id, update_notification_request, **kwargs)  # noqa: E501

    @validate_arguments
    def update_notification_with_http_info(self, scope : Annotated[StrictStr, Field(..., description="The scope that identifies a subscription")], code : Annotated[StrictStr, Field(..., description="The code that identifies a subscription")], id : Annotated[StrictStr, Field(..., description="The unique identifier of the notification")], update_notification_request : Annotated[UpdateNotificationRequest, Field(..., description="The data to update a notification")], **kwargs) -> ApiResponse:  # noqa: E501
        """UpdateNotification: Update a Notification for a Subscription  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_notification_with_http_info(scope, code, id, update_notification_request, async_req=True)
        >>> result = thread.get()

        :param scope: The scope that identifies a subscription (required)
        :type scope: str
        :param code: The code that identifies a subscription (required)
        :type code: str
        :param id: The unique identifier of the notification (required)
        :type id: str
        :param update_notification_request: The data to update a notification (required)
        :type update_notification_request: UpdateNotificationRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: Timeout setting. Do not use - use the opts parameter instead
        :param opts: Configuration options for this request
        :type opts: ConfigurationOptions, optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(Notification, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'scope',
            'code',
            'id',
            'update_notification_request'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers',
                'opts'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_notification" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['scope']:
            _path_params['scope'] = _params['scope']

        if _params['code']:
            _path_params['code'] = _params['code']

        if _params['id']:
            _path_params['id'] = _params['id']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['update_notification_request'] is not None:
            _body_params = _params['update_notification_request']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json-patch+json', 'application/json', 'text/json', 'application/*+json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['oauth2']  # noqa: E501

        _response_types_map = {
            '200': "Notification",
            '400': "LusidValidationProblemDetails",
            '404': "str",
        }

        return self.api_client.call_api(
            '/api/subscriptions/{scope}/{code}/notifications/{id}', 'PUT',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            opts=_params.get('opts'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))
