/*
 * Decompiled with CFR 0.152.
 */
package com.sas.util.transforms;

import com.sas.util.transforms.TransformInputOutputInterface;

public class CharacterToBooleanTransform
implements TransformInputOutputInterface {
    static final long serialVersionUID = 256899152294673648L;
    public static final CharacterToBooleanTransform defaultInstance = new CharacterToBooleanTransform();
    public char trueChar;
    public char falseChar;

    public CharacterToBooleanTransform() {
        this('T', 'F');
    }

    public CharacterToBooleanTransform(char trueChar, char falseChar) {
        this.trueChar = trueChar;
        this.falseChar = falseChar;
    }

    @Override
    public Object transform(Object value) {
        Character c = (Character)value;
        if (c.charValue() == this.trueChar) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    @Override
    public Class getInputClass() {
        return Character.class;
    }

    @Override
    public Class getOutputClass() {
        return Boolean.class;
    }
}

