/*
 * Decompiled with CFR 0.152.
 */
package com.sas.util;

import com.sas.PublicClonable;
import com.sas.util.RB;
import java.io.Serializable;
import java.text.MessageFormat;

public class CharBuffer
implements Serializable,
PublicClonable {
    static final long serialVersionUID = 7996781090478772284L;
    public static final String RB_KEY = "CharBuffer.";
    private char[] m_data;
    private int m_count;

    public CharBuffer() {
        this(16);
    }

    public CharBuffer(int size) {
        this.m_data = new char[size];
        this.m_count = 0;
    }

    public CharBuffer(char[] chars) {
        this(chars.length + 16);
        this.append(chars);
    }

    public CharBuffer(String string) {
        this(string.length() + 16);
        this.append(string);
    }

    public CharBuffer(StringBuffer stringBuf) {
        this(stringBuf.length() + 16);
        this.append(stringBuf);
    }

    public CharBuffer(CharBuffer inBuf) {
        this(inBuf.m_count + 16);
        this.append(inBuf);
    }

    public void append(char ch) {
        this.ensureCapacity(this.m_count + 1);
        this.m_data[this.m_count++] = ch;
    }

    public void append(char[] chars) {
        int length = chars.length;
        this.ensureCapacity(this.m_count + length);
        System.arraycopy(chars, 0, this.m_data, this.m_count, length);
        this.m_count += length;
    }

    public void append(CharBuffer buf) {
        int length = buf.m_count;
        this.ensureCapacity(this.m_count + length);
        System.arraycopy(buf.m_data, 0, this.m_data, this.m_count, length);
        this.m_count += length;
    }

    public void append(String string) {
        int length = string.length();
        this.ensureCapacity(this.m_count + length);
        string.getChars(0, length, this.m_data, this.m_count);
        this.m_count += length;
    }

    public void append(StringBuffer stringBuf) {
        int length = stringBuf.length();
        this.ensureCapacity(this.m_count + length);
        stringBuf.getChars(0, length, this.m_data, this.m_count);
        this.m_count += length;
    }

    public void insert(int index, String string) {
        int length = string.length();
        this.ensureCapacity(this.m_count + length);
        System.arraycopy(this.m_data, index, this.m_data, index + length, this.m_count - index);
        string.getChars(0, length, this.m_data, index);
        this.m_count += length;
    }

    public void insert(int index, StringBuffer stringBuf) {
        int length = stringBuf.length();
        this.ensureCapacity(this.m_count + length);
        System.arraycopy(this.m_data, index, this.m_data, index + length, this.m_count - index);
        stringBuf.getChars(0, length, this.m_data, index);
        this.m_count += length;
    }

    public void insert(int index, char[] chars) {
        this.ensureCapacity(this.m_count + chars.length);
        System.arraycopy(this.m_data, index, this.m_data, index + chars.length, this.m_count - index);
        System.arraycopy(chars, 0, this.m_data, index, chars.length);
        this.m_count += chars.length;
    }

    public void insert(int index, CharBuffer cbuf) {
        this.ensureCapacity(this.m_count + cbuf.m_count);
        System.arraycopy(this.m_data, index, this.m_data, index + cbuf.m_count, this.m_count - index);
        cbuf.getChars(0, cbuf.m_count, this.m_data, index);
        this.m_count += cbuf.m_count;
    }

    public void insert(int index, char ch) {
        this.ensureCapacity(this.m_count + 1);
        this.shiftRight(index, 1);
        this.m_data[index] = ch;
        ++this.m_count;
    }

    public void fill(char ch, int start, int count) {
        if (start >= this.m_count || start < 0) {
            throw new IndexOutOfBoundsException(MessageFormat.format(RB.getStringResource(RB_KEY, "startOutOfRange.ex.txt"), new Integer(start), new Integer(this.m_count - 1)));
        }
        if (start + count > this.m_count) {
            this.ensureCapacity(start + count);
            this.m_count = start + count;
        }
        for (int i = start; i < start + count; ++i) {
            this.m_data[i] = ch;
        }
    }

    public void fill(char[] chars, int start, int count) {
        if (start >= this.m_count || start < 0) {
            throw new IndexOutOfBoundsException(MessageFormat.format(RB.getStringResource(RB_KEY, "startOutOfRange.ex.txt"), new Integer(start), new Integer(this.m_count - 1)));
        }
        int posToFill = chars.length * count;
        if (start + posToFill > this.m_count) {
            this.ensureCapacity(start + posToFill);
            this.m_count = start + posToFill;
        }
        int offset = start;
        for (int i = 0; i < count; ++i) {
            for (int k = 0; k < chars.length; ++k) {
                this.m_data[k + offset] = chars[k];
            }
            offset += chars.length;
        }
    }

    public void fill(CharBuffer cbuf, int start, int count) {
        this.fill(cbuf.toCharArray(), start, count);
    }

    public void fill(String string, int start, int count) {
        this.fill(string.toCharArray(), start, count);
    }

    public void fill(StringBuffer stringBuf, int start, int count) {
        this.fill(stringBuf.toString().toCharArray(), start, count);
    }

    public void remove(int begin, int end) {
        if (end == -1) {
            end = this.m_count;
        }
        if (begin < 0 || begin >= this.m_count) {
            throw new IndexOutOfBoundsException(MessageFormat.format(RB.getStringResource(RB_KEY, "startOutOfRange.ex.txt"), new Integer(begin), new Integer(this.m_count - 1)));
        }
        if (begin > end) {
            throw new IndexOutOfBoundsException(MessageFormat.format(RB.getStringResource(RB_KEY, "endBeforeBegin.ex.txt"), new Integer(begin), new Integer(end)));
        }
        if (end > this.m_count) {
            throw new IndexOutOfBoundsException(MessageFormat.format(RB.getStringResource(RB_KEY, "endOutOfRange.ex.txt"), new Integer(end), new Integer(this.m_count)));
        }
        System.arraycopy(this.m_data, end, this.m_data, begin, this.m_count - end);
        this.m_count -= end - begin;
    }

    public void removeAt(int index) {
        if (index < 0 || index >= this.m_count) {
            throw new IndexOutOfBoundsException(MessageFormat.format(RB.getStringResource(RB_KEY, "indexOutOfRange.ex.txt"), new Integer(index), new Integer(this.m_count - 1)));
        }
        if (index < this.m_count - 1) {
            this.shiftLeft(index + 1, 1);
        }
        --this.m_count;
    }

    public void removeAll() {
        this.m_count = 0;
    }

    public void replace(String string, int begin, int end) {
        char[] chars = string.toCharArray();
        this.replace(chars, begin, end);
    }

    public void replace(StringBuffer stringBuf, int begin, int end) {
        char[] chars = stringBuf.toString().toCharArray();
        this.replace(chars, begin, end);
    }

    public void replace(CharBuffer cbuf, int begin, int end) {
        char[] chars = cbuf.toCharArray();
        this.replace(chars, begin, end);
    }

    public void replace(char[] chars, int begin, int end) {
        if (end == -1) {
            end = this.m_count;
        }
        if (begin < 0 || begin >= this.m_count) {
            throw new IndexOutOfBoundsException(MessageFormat.format(RB.getStringResource(RB_KEY, "startOutOfRange.ex.txt"), new Integer(begin), new Integer(this.m_count - 1)));
        }
        if (begin > end) {
            throw new IndexOutOfBoundsException(MessageFormat.format(RB.getStringResource(RB_KEY, "endBeforeBegin.ex.txt"), new Integer(begin), new Integer(end)));
        }
        if (end > this.m_count) {
            throw new IndexOutOfBoundsException(MessageFormat.format(RB.getStringResource(RB_KEY, "endOutOfRange.ex.txt"), new Integer(end), new Integer(this.m_count)));
        }
        int numRemoved = end - begin;
        if (numRemoved < chars.length) {
            this.ensureCapacity(this.m_count - numRemoved + chars.length);
            this.shiftRight(end, chars.length - numRemoved);
            System.arraycopy(chars, 0, this.m_data, begin, chars.length);
            this.m_count += chars.length - numRemoved;
        } else if (numRemoved > chars.length) {
            this.shiftLeft(end, numRemoved - chars.length);
            System.arraycopy(chars, 0, this.m_data, begin, chars.length);
            this.m_count -= numRemoved - chars.length;
        } else {
            System.arraycopy(chars, 0, this.m_data, begin, numRemoved);
        }
    }

    public void setAt(int index, char ch) {
        if (index >= this.m_count) {
            throw new IndexOutOfBoundsException(MessageFormat.format(RB.getStringResource(RB_KEY, "indexOutOfRange.ex.txt"), new Integer(index), new Integer(this.m_count - 1)));
        }
        this.ensureCapacity(index);
        this.m_data[index] = ch;
    }

    public int length() {
        return this.m_count;
    }

    public int capacity() {
        return this.m_data.length;
    }

    public boolean isEmpty() {
        return this.m_count <= 0;
    }

    public char charAt(int index) {
        if (index >= this.m_count) {
            throw new IndexOutOfBoundsException(MessageFormat.format(RB.getStringResource(RB_KEY, "indexOutOfRange.ex.txt"), new Integer(index), new Integer(this.m_count - 1)));
        }
        return this.m_data[index];
    }

    public void getChars(int srcBegin, int srcEnd, char[] dst, int dstBegin) {
        if (dstBegin >= dst.length) {
            throw new IndexOutOfBoundsException(MessageFormat.format(RB.getStringResource(RB_KEY, "indexOutOfRange.ex.txt"), new Integer(dstBegin), new Integer(dst.length)));
        }
        if (srcEnd == -1) {
            srcEnd = this.m_count;
        }
        if (srcBegin < 0 || srcBegin >= this.m_count) {
            throw new IndexOutOfBoundsException(MessageFormat.format(RB.getStringResource(RB_KEY, "startOutOfRange.ex.txt"), new Integer(srcBegin), new Integer(this.m_count - 1)));
        }
        if (srcBegin > srcEnd) {
            throw new IndexOutOfBoundsException(MessageFormat.format(RB.getStringResource(RB_KEY, "endBeforeBegin.ex.txt"), new Integer(srcBegin), new Integer(srcEnd)));
        }
        if (srcEnd > this.m_count) {
            throw new IndexOutOfBoundsException(MessageFormat.format(RB.getStringResource(RB_KEY, "endOutOfRange.ex.txt"), new Integer(srcEnd), new Integer(this.m_count)));
        }
        System.arraycopy(this.m_data, srcBegin, dst, dstBegin, srcEnd - srcBegin);
    }

    public char[] toCharArray() {
        char[] newData = new char[this.m_count];
        System.arraycopy(this.m_data, 0, newData, 0, this.m_count);
        return newData;
    }

    public char[] toCharArray(int begin, int end) {
        if (end == -1) {
            end = this.m_count;
        }
        if (begin < 0 || begin >= this.m_count) {
            throw new IndexOutOfBoundsException(MessageFormat.format(RB.getStringResource(RB_KEY, "startOutOfRange.ex.txt"), new Integer(begin), new Integer(this.m_count - 1)));
        }
        if (begin > end) {
            throw new IndexOutOfBoundsException(MessageFormat.format(RB.getStringResource(RB_KEY, "endBeforeBegin.ex.txt"), new Integer(begin), new Integer(end)));
        }
        if (end > this.m_count) {
            throw new IndexOutOfBoundsException(MessageFormat.format(RB.getStringResource(RB_KEY, "endOutOfRange.ex.txt"), new Integer(end), new Integer(this.m_count)));
        }
        char[] newData = new char[end - begin];
        System.arraycopy(this.m_data, begin, newData, 0, end - begin);
        return newData;
    }

    public CharBuffer leftCharBuffer(int count) {
        return this.subCharBuffer(0, count);
    }

    public CharBuffer rightCharBuffer(int count) {
        return this.subCharBuffer(this.m_count - count, this.m_count);
    }

    public CharBuffer subCharBuffer(int begin, int end) {
        if (end == -1) {
            end = this.m_count;
        }
        if (begin < 0 || begin >= this.m_count) {
            throw new IndexOutOfBoundsException(MessageFormat.format(RB.getStringResource(RB_KEY, "startOutOfRange.ex.txt"), new Integer(begin), new Integer(this.m_count - 1)));
        }
        if (begin > end) {
            throw new IndexOutOfBoundsException(MessageFormat.format(RB.getStringResource(RB_KEY, "endBeforeBegin.ex.txt"), new Integer(begin), new Integer(end)));
        }
        if (end > this.m_count) {
            throw new IndexOutOfBoundsException(MessageFormat.format(RB.getStringResource(RB_KEY, "endOutOfRange.ex.txt"), new Integer(end), new Integer(this.m_count)));
        }
        CharBuffer retBuf = new CharBuffer(end - begin);
        if (end <= this.m_count) {
            System.arraycopy(this.m_data, begin, retBuf.m_data, 0, end - begin);
            retBuf.m_count = end - begin;
            return retBuf;
        }
        return retBuf;
    }

    public String substring(int begin, int end) {
        if (end == -1) {
            end = this.m_count;
        }
        if (begin < 0 || begin >= this.m_count) {
            throw new IndexOutOfBoundsException(MessageFormat.format(RB.getStringResource(RB_KEY, "startOutOfRange.ex.txt"), new Integer(begin), new Integer(this.m_count - 1)));
        }
        if (begin > end) {
            throw new IndexOutOfBoundsException(MessageFormat.format(RB.getStringResource(RB_KEY, "endBeforeBegin.ex.txt"), new Integer(begin), new Integer(end)));
        }
        if (end > this.m_count) {
            throw new IndexOutOfBoundsException(MessageFormat.format(RB.getStringResource(RB_KEY, "endOutOfRange.ex.txt"), new Integer(end), new Integer(this.m_count)));
        }
        String s = new String(this.m_data, begin, end - begin);
        return s;
    }

    public void trim() {
        this.trimLeft();
        this.trimRight();
    }

    public void trimLeft() {
        int begin;
        for (begin = 0; begin < this.m_count && Character.isWhitespace(this.m_data[begin]); ++begin) {
        }
        System.arraycopy(this.m_data, begin, this.m_data, 0, this.m_count - begin);
        this.m_count -= begin;
    }

    public void trimRight() {
        int begin;
        for (begin = this.m_count - 1; begin > 0 && Character.isWhitespace(this.m_data[begin]); --begin) {
        }
        this.m_count = begin + 1;
    }

    public void reverse() {
        if (this.m_count <= 1) {
            return;
        }
        for (int i = 0; i < this.m_count / 2; ++i) {
            char ch = this.m_data[i];
            this.m_data[i] = this.m_data[this.m_count - 1 - i];
            this.m_data[this.m_count - 1 - i] = ch;
        }
    }

    public boolean endsWith(String string) {
        return this.regionMatches(false, string, this.m_count - string.length(), this.m_count);
    }

    public boolean startsWith(String string) {
        return this.regionMatches(false, string, 0, string.length());
    }

    public int indexOf(char ch, int offset) {
        if (offset < 0 || offset >= this.m_count) {
            throw new IndexOutOfBoundsException(MessageFormat.format(RB.getStringResource(RB_KEY, "offsetOutOfRange.ex.txt"), new Integer(offset), new Integer(this.m_count - 1)));
        }
        for (int i = offset; i < this.m_count - 1; ++i) {
            if (this.m_data[i] != ch) continue;
            return i;
        }
        return -1;
    }

    public int indexOf(char[] chars, int offset) {
        if (offset < 0 || offset >= this.m_count) {
            throw new IndexOutOfBoundsException(MessageFormat.format(RB.getStringResource(RB_KEY, "offsetOutOfRange.ex.txt"), new Integer(offset), new Integer(this.m_count - 1)));
        }
        int k = -1;
        if (chars.length == 0) {
            return offset;
        }
        char first = chars[0];
        int charCount = this.m_count - chars.length;
        for (int i = offset; i <= charCount; ++i) {
            if (first != this.m_data[i]) continue;
            for (k = 1; k < chars.length && chars[k] == this.m_data[i + k]; ++k) {
            }
            if (k != chars.length) continue;
            return i;
        }
        return -1;
    }

    public int indexOf(CharBuffer cbuf, int offset) {
        if (offset < 0 || offset >= this.m_count) {
            throw new IndexOutOfBoundsException(MessageFormat.format(RB.getStringResource(RB_KEY, "offsetOutOfRange.ex.txt"), new Integer(offset), new Integer(this.m_count - 1)));
        }
        int k = -1;
        if (cbuf.m_count == 0) {
            return offset;
        }
        char first = cbuf.m_data[0];
        int charCount = this.m_count - cbuf.m_count;
        for (int i = offset; i <= charCount; ++i) {
            if (first != this.m_data[i]) continue;
            for (k = 1; k < cbuf.m_count && cbuf.m_data[k] == this.m_data[i + k]; ++k) {
            }
            if (k != cbuf.m_count) continue;
            return i;
        }
        return -1;
    }

    public int indexOf(String string, int offset) {
        if (offset < 0 || offset >= this.m_count) {
            throw new IndexOutOfBoundsException(MessageFormat.format(RB.getStringResource(RB_KEY, "offsetOutOfRange.ex.txt"), new Integer(offset), new Integer(this.m_count - 1)));
        }
        int k = -1;
        int length = string.length();
        if (length == 0) {
            return offset;
        }
        char first = string.charAt(0);
        int charCount = this.m_count - length;
        for (int i = offset; i <= charCount; ++i) {
            if (first != this.m_data[i]) continue;
            for (k = 1; k < length && string.charAt(k) == this.m_data[i + k]; ++k) {
            }
            if (k != length) continue;
            return i;
        }
        return -1;
    }

    public int indexOf(StringBuffer stringBuf, int offset) {
        if (offset < 0 || offset >= this.m_count) {
            throw new IndexOutOfBoundsException(MessageFormat.format(RB.getStringResource(RB_KEY, "offsetOutOfRange.ex.txt"), new Integer(offset), new Integer(this.m_count - 1)));
        }
        int k = -1;
        int length = stringBuf.length();
        if (length == 0) {
            return offset;
        }
        char first = stringBuf.charAt(0);
        int charCount = this.m_count - length;
        for (int i = offset; i <= charCount; ++i) {
            if (first != this.m_data[i]) continue;
            for (k = 1; k < length && stringBuf.charAt(k) == this.m_data[i + k]; ++k) {
            }
            if (k != length) continue;
            return i;
        }
        return -1;
    }

    public int indexOfChar(String string, int offset) {
        if (offset < 0 || offset >= this.m_count) {
            throw new IndexOutOfBoundsException(MessageFormat.format(RB.getStringResource(RB_KEY, "offsetOutOfRange.ex.txt"), new Integer(offset), new Integer(this.m_count - 1)));
        }
        int k = -1;
        char[] chars = string.toCharArray();
        int length = string.length();
        if (length == 0) {
            return -1;
        }
        for (int i = offset; i < this.m_count; ++i) {
            for (k = 0; k < length; ++k) {
                if (this.m_data[i] != chars[k]) continue;
                return i;
            }
        }
        return -1;
    }

    public int lastIndexOf(char ch, int offset) {
        if (offset < 0 || offset >= this.m_count) {
            throw new IndexOutOfBoundsException(MessageFormat.format(RB.getStringResource(RB_KEY, "offsetOutOfRange.ex.txt"), new Integer(offset), new Integer(this.m_count - 1)));
        }
        for (int i = offset; i >= 0; --i) {
            if (this.m_data[i] != ch) continue;
            return i;
        }
        return -1;
    }

    public int lastIndexOf(char[] chars, int offset) {
        int lastIndex;
        if (offset < 0 || offset >= this.m_count) {
            throw new IndexOutOfBoundsException(MessageFormat.format(RB.getStringResource(RB_KEY, "offsetOutOfRange.ex.txt"), new Integer(offset), new Integer(this.m_count - 1)));
        }
        int index = lastIndex = this.indexOf(chars, 0);
        while (index != -1 && index <= offset) {
            lastIndex = index;
            index = this.indexOf(chars, index + 1);
        }
        if (index == -1 || index > offset) {
            index = lastIndex;
        }
        return index;
    }

    public int lastIndexOf(CharBuffer cbuf, int offset) {
        int lastIndex;
        if (offset < 0 || offset >= this.m_count) {
            throw new IndexOutOfBoundsException(MessageFormat.format(RB.getStringResource(RB_KEY, "offsetOutOfRange.ex.txt"), new Integer(offset), new Integer(this.m_count - 1)));
        }
        int index = lastIndex = this.indexOf(cbuf, 0);
        while (index != -1 && index <= offset) {
            lastIndex = index;
            index = this.indexOf(cbuf, index + 1);
        }
        if (index == -1 || index > offset) {
            index = lastIndex;
        }
        return index;
    }

    public int lastIndexOf(String string, int offset) {
        int lastIndex;
        if (offset < 0 || offset >= this.m_count) {
            throw new IndexOutOfBoundsException(MessageFormat.format(RB.getStringResource(RB_KEY, "offsetOutOfRange.ex.txt"), new Integer(offset), new Integer(this.m_count - 1)));
        }
        int index = lastIndex = this.indexOf(string, 0);
        while (index != -1 && index <= offset) {
            lastIndex = index;
            index = this.indexOf(string, index + 1);
        }
        if (index == -1 || index > offset) {
            index = lastIndex;
        }
        return index;
    }

    public int lastIndexOf(StringBuffer stringBuf, int offset) {
        int lastIndex;
        if (offset < 0 || offset >= this.m_count) {
            throw new IndexOutOfBoundsException(MessageFormat.format(RB.getStringResource(RB_KEY, "offsetOutOfRange.ex.txt"), new Integer(offset), new Integer(this.m_count - 1)));
        }
        int index = lastIndex = this.indexOf(stringBuf, 0);
        while (index != -1 && index <= offset) {
            lastIndex = index;
            index = this.indexOf(stringBuf, index + 1);
        }
        if (index == -1 || index > offset) {
            index = lastIndex;
        }
        return index;
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof CharBuffer)) {
            return false;
        }
        CharBuffer buf = (CharBuffer)object;
        if (this.m_count != buf.m_count) {
            return false;
        }
        for (int i = 0; i < this.m_count; ++i) {
            if (this.m_data[i] == buf.m_data[i]) continue;
            return false;
        }
        return true;
    }

    public boolean equalsIgnoreCase(Object object) {
        if (object == null || !(object instanceof CharBuffer)) {
            return false;
        }
        CharBuffer buf = (CharBuffer)object;
        if (this.m_count != buf.m_count) {
            return false;
        }
        for (int i = 0; i < this.m_count; ++i) {
            if (Character.toLowerCase(this.m_data[i]) == Character.toLowerCase(buf.m_data[i]) || Character.toUpperCase(this.m_data[i]) == Character.toUpperCase(buf.m_data[i])) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public StringBuffer toStringBuffer() {
        StringBuffer retBuf = new StringBuffer(this.m_count);
        retBuf.append(this.m_data, 0, this.m_count);
        return retBuf;
    }

    public String toString() {
        return new String(this.m_data, 0, this.m_count);
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        CharBuffer cbuf = (CharBuffer)super.clone();
        cbuf.m_data = new char[this.m_data.length];
        System.arraycopy(this.m_data, 0, cbuf.m_data, 0, this.m_count);
        cbuf.m_count = this.m_count;
        return cbuf;
    }

    private void ensureCapacity(int capacity) {
        if (capacity > this.m_data.length) {
            int newSize = this.m_data.length * 2;
            if (capacity > newSize) {
                newSize = capacity;
            }
            char[] newData = new char[newSize];
            System.arraycopy(this.m_data, 0, newData, 0, this.m_count);
            this.m_data = newData;
        }
    }

    private void shiftLeft(int begin, int amount) {
        int offset = begin - amount;
        if (offset < 0) {
            offset = 0;
        }
        System.arraycopy(this.m_data, begin, this.m_data, offset, this.m_count - begin);
    }

    private void shiftRight(int begin, int amount) {
        int offset = begin + amount;
        System.arraycopy(this.m_data, begin, this.m_data, offset, this.m_count - begin);
    }

    private boolean regionMatches(boolean ignoreCase, String string, int begin, int end) {
        if (begin > end || end - begin != string.length()) {
            return false;
        }
        int i = begin;
        int j = 0;
        while (i < end) {
            char cha = this.m_data[i];
            char chb = string.charAt(j);
            if (!ignoreCase) {
                if (cha != chb) {
                    return false;
                }
                if (Character.toLowerCase(cha) != Character.toLowerCase(chb) && Character.toUpperCase(cha) != Character.toUpperCase(chb)) {
                    return false;
                }
            }
            ++i;
            ++j;
        }
        return true;
    }
}

