/*
 * Decompiled with CFR 0.152.
 */
package com.sas.text;

import com.sas.text.FormatDescription;
import com.sas.text.PictureEntry;
import com.sas.text.PictureOptions;
import com.sas.text.PictureRangeSegment;
import com.sas.text.SASFormat;
import com.sas.text.SASPictureFormat;
import com.sas.text.SASValueFormat;
import com.sas.text.TableEntry;
import com.sas.text.ValueEntry;
import com.sas.util.MissingValueRangeSegment;
import com.sas.util.NumericRangeSegment;
import com.sas.util.RangeSegment;
import com.sas.util.StringRangeSegment;
import java.io.IOException;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.text.ParseException;
import java.text.ParsePosition;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

public abstract class SASUserDefinedFormat
extends SASFormat {
    protected static Hashtable lookUpTable = new Hashtable();
    private static int KW_LOW = 0;
    private static int KW_HIGH = 1;
    private static int KW_OTHER = 2;
    private static int KW_PICTURE = 3;
    private static int KW_VALUE = 4;
    private static int KW_INVALUE = 5;
    private static String[] keywords = new String[]{"low", "high", "other", "picture", "value", "Invalue"};
    static String[] foptions = new String[]{"min", "max", "default", "just", "upcase", "notsorted", "fuzz", "round", "multilabel"};
    static String[] poptions = new String[]{"fill", "mult", "multiplier", "prefix", "noedit"};

    protected SASUserDefinedFormat() {
    }

    @Override
    public Object parseObject(String source, ParsePosition status) {
        return null;
    }

    @Override
    public boolean isUserDefinedFormat() {
        return true;
    }

    public static FormatDescription createFormat(String formatDefinition) throws ParseException {
        String fstmt = formatDefinition.trim();
        fstmt = fstmt.replace("''", "\\'");
        fstmt = fstmt.replace("\"\"", "\\\"");
        ValueEntry entry = null;
        try {
            StreamTokenizer st = new StreamTokenizer(new StringReader(fstmt));
            st.resetSyntax();
            st.wordChars(33, 126);
            st.wordChars(160, 255);
            st.whitespaceChars(0, 32);
            st.quoteChar(92);
            st.quoteChar(39);
            st.quoteChar(34);
            st.ordinaryChar(61);
            st.ordinaryChar(40);
            st.ordinaryChar(41);
            st.ordinaryChar(91);
            st.ordinaryChar(93);
            st.lowerCaseMode(true);
            int ttype = st.nextToken();
            if (ttype != -3) {
                throw new ParseException("Error parsing format type", 0);
            }
            String ftype = st.sval;
            ttype = st.nextToken();
            if (ttype != -3) {
                throw new ParseException("Error parsing format name", 0);
            }
            String fname = st.sval;
            if (ftype.equals(keywords[KW_PICTURE])) {
                entry = (ValueEntry)((Object)SASPictureFormat.createPictureFormat(fname));
            } else if (ftype.equals(keywords[KW_VALUE])) {
                entry = (ValueEntry)SASValueFormat.createValueFormat(fname);
            } else {
                if (ftype.equals(keywords[KW_INVALUE])) {
                    throw new ParseException("InValue format is not supported", 0);
                }
                throw new ParseException(ftype + " format is not supported", 0);
            }
            boolean isPicture = entry instanceof PictureEntry;
            ttype = st.nextToken();
            if (ttype != -1) {
                if (ttype == 40) {
                    SASUserDefinedFormat.parseFormatOptions(entry, st, isPicture);
                } else {
                    st.pushBack();
                }
            } else {
                throw new ParseException("Incomplete format definition", 0);
            }
            StringBuffer range = new StringBuffer(100);
            StringBuffer value = new StringBuffer(100);
            PictureOptions po = null;
            boolean completeRangeFlg = true;
            ttype = st.nextToken();
            while (ttype != -1) {
                range.setLength(0);
                value.setLength(0);
                range.append(st.sval);
                block9: while ((ttype = st.nextToken()) != 61 && ttype != -1) {
                    switch (ttype) {
                        case -3: 
                        case 34: 
                        case 39: {
                            range.append(st.sval);
                            completeRangeFlg = false;
                            continue block9;
                        }
                    }
                    range.append((char)ttype);
                    completeRangeFlg = false;
                }
                if (ttype == 61) {
                    ttype = st.nextToken();
                    if (ttype == 92) {
                        String valueString = st.sval;
                        int length = valueString.length();
                        StringBuffer prefix = new StringBuffer();
                        for (int i = 0; i < length; ++i) {
                            if (valueString.charAt(i) != '\'' && valueString.charAt(i) != '\"') continue;
                            prefix.append(valueString.charAt(i));
                        }
                        value.append(st.sval);
                        if (prefix.length() > 0) {
                            value.append(prefix);
                        }
                    } else if (ttype == 39 || ttype == 34) {
                        value.append('\'' + st.sval + '\'');
                    }
                    if (ttype == -3) {
                        value.append(st.sval);
                    } else if (ttype == 91) {
                        value.append('[');
                        block11: while ((ttype = st.nextToken()) != 93 && ttype != -1) {
                            switch (ttype) {
                                case -3: {
                                    value.append(st.sval);
                                    continue block11;
                                }
                            }
                            value.append((char)ttype);
                        }
                        if (ttype == 93) {
                            value.append(']');
                        }
                    }
                    ttype = st.nextToken();
                    if (ttype == 40) {
                        if (!isPicture) {
                            int dummy = st.nextToken();
                            while (dummy != 41 && dummy != -1) {
                                dummy = st.nextToken();
                            }
                        } else {
                            po = SASUserDefinedFormat.parsePictureOptions((PictureEntry)entry, st);
                        }
                    } else {
                        st.pushBack();
                    }
                } else {
                    throw new ParseException("Incomplete range-value definition", 0);
                }
                SASUserDefinedFormat.setRangeSegment(range.toString(), value.toString(), entry, po, completeRangeFlg);
                po = null;
                ttype = st.nextToken();
            }
        }
        catch (IOException ioe) {
            System.err.println(ioe.toString());
        }
        return entry;
    }

    private static void parseFormatOptions(ValueEntry entry, StreamTokenizer st, boolean isPicture) {
        try {
            int ttype = st.nextToken();
            while (ttype != 41 && ttype != -1) {
                int foIndex = -1;
                if (ttype == -3) {
                    String token = st.sval;
                    for (int i = 0; i < foptions.length && foIndex == -1; ++i) {
                        if (!token.equals(foptions[i])) continue;
                        foIndex = i;
                    }
                    switch (foIndex) {
                        case 0: {
                            st.nextToken();
                            ttype = st.nextToken();
                            if (ttype != -1) {
                                entry.setMinWidth(Integer.parseInt(st.sval));
                                break;
                            }
                            System.err.println("Error: format option MIN specified with no numeric value");
                            break;
                        }
                        case 1: {
                            st.nextToken();
                            ttype = st.nextToken();
                            if (ttype != -1) {
                                entry.setMaxWidth(Integer.parseInt(st.sval));
                                break;
                            }
                            System.err.println("Error: format option MAX specified with no value");
                            break;
                        }
                        case 2: {
                            st.nextToken();
                            ttype = st.nextToken();
                            if (ttype != -1) {
                                entry.setDefaultWidth(Integer.parseInt(st.sval));
                                break;
                            }
                            System.err.println("Error: format option DEFAULT specified with no value");
                            break;
                        }
                        case 3: {
                            System.err.println("Error: format option JUST not supported");
                            break;
                        }
                        case 4: {
                            System.err.println("Error: format option UPCASE not supported");
                            break;
                        }
                        case 5: {
                            entry.setNotSorted(true);
                            break;
                        }
                        case 6: {
                            st.nextToken();
                            ttype = st.nextToken();
                            if (ttype != -1) {
                                entry.setFuzzValue(Float.parseFloat(st.sval));
                                break;
                            }
                            System.err.println("Error: format option FUZZ specified with no value");
                            break;
                        }
                        case 7: {
                            if (!isPicture) break;
                            ((PictureEntry)entry).setRound(true);
                            break;
                        }
                        case 8: {
                            break;
                        }
                        default: {
                            System.err.println("Error: format option " + token + " not supported");
                        }
                    }
                }
                ttype = st.nextToken();
            }
        }
        catch (IOException ioe) {
            System.err.println(ioe.toString());
        }
    }

    private static PictureOptions parsePictureOptions(PictureEntry segment, StreamTokenizer st) {
        try {
            PictureOptions po = new PictureOptions();
            int ttype = st.nextToken();
            while (ttype != 41 && ttype != -1) {
                int poIndex = -1;
                if (ttype == -3) {
                    String token = st.sval;
                    for (int i = 0; i < poptions.length && poIndex == -1; ++i) {
                        if (!token.equals(poptions[i])) continue;
                        poIndex = i;
                    }
                    switch (poIndex) {
                        case 0: {
                            st.nextToken();
                            ttype = st.nextToken();
                            if (ttype != -1) {
                                if (st.sval.length() <= 0) break;
                                po.setFill(st.sval.charAt(0));
                                break;
                            }
                            System.err.println("Error: picture option FILL was incorrectly specified");
                            break;
                        }
                        case 1: 
                        case 2: {
                            st.nextToken();
                            ttype = st.nextToken();
                            if (ttype != -1) {
                                po.setMult(Double.valueOf(st.sval));
                                break;
                            }
                            System.err.println("Error: picture option mult was incorrectly specified");
                            break;
                        }
                        case 3: {
                            st.nextToken();
                            ttype = st.nextToken();
                            if (ttype != -1) {
                                po.setPrefix(st.sval);
                                break;
                            }
                            System.err.println("Error: picture option PREFIX was incorrectly specified");
                            break;
                        }
                        case 4: {
                            po.setNoEdit(true);
                            break;
                        }
                        default: {
                            System.err.println("Error: format option " + token + " not supported");
                        }
                    }
                }
                ttype = st.nextToken();
            }
            return po;
        }
        catch (IOException ioe) {
            System.err.println(ioe.toString());
            return null;
        }
    }

    private static void setRangeSegment(String range, String value, ValueEntry entry, PictureOptions po, boolean completeRangeFlag) {
        boolean sexcl = false;
        boolean eexcl = false;
        boolean negative = false;
        boolean pushBack = false;
        StringTokenizer parser = new StringTokenizer(range, ",-<", true);
        int tokenCount = parser.countTokens();
        String token = "";
        String lastToken = "";
        if (tokenCount != 1) {
            Vector<String> v = new Vector<String>();
            block5: while (parser.hasMoreTokens() && (!entry.isCharacterFormat() || entry.isCharacterFormat() && !completeRangeFlag)) {
                if (!pushBack) {
                    String temp;
                    lastToken = token;
                    token = parser.nextToken();
                    if (!token.equals(" ")) {
                        token.trim();
                    }
                    if (!entry.isCharacterFormat() && (token.endsWith("e") || token.endsWith("E")) && parser.hasMoreTokens() && "-".equals(temp = parser.nextToken().trim()) && parser.hasMoreTokens()) {
                        temp = temp + parser.nextToken();
                        token = token + temp;
                    }
                } else {
                    pushBack = false;
                }
                if (token.length() == 1) {
                    switch (token.charAt(0)) {
                        case ',': {
                            if (v.size() == 1) {
                                SASUserDefinedFormat.addSegment(v.elementAt(0), v.elementAt(0), sexcl, eexcl, value, entry, po);
                            } else {
                                SASUserDefinedFormat.addSegment(v.elementAt(0), v.elementAt(1), sexcl, eexcl, value, entry, po);
                            }
                            v.removeAllElements();
                            eexcl = false;
                            sexcl = false;
                            continue block5;
                        }
                        case '-': {
                            negative = true;
                            continue block5;
                        }
                        case '<': {
                            if (lastToken.equals("-")) {
                                eexcl = true;
                                continue block5;
                            }
                            sexcl = true;
                            if (!parser.hasMoreTokens()) continue block5;
                            lastToken = token;
                            token = parser.nextToken().trim();
                            if (token.equals("-")) continue block5;
                            pushBack = true;
                            continue block5;
                        }
                    }
                    if (negative) {
                        char c1 = token.charAt(0);
                        if (Character.isDigit(c1) || c1 == '.' && token.length() >= 2 && Character.isDigit(token.charAt(1))) {
                            v.addElement('-' + token);
                        }
                        negative = false;
                    } else {
                        v.addElement(token);
                    }
                    if (!parser.hasMoreTokens()) continue;
                    lastToken = token;
                    token = parser.nextToken().trim();
                    if (token.equals("-")) continue;
                    pushBack = true;
                    continue;
                }
                if (negative) {
                    char c1 = token.charAt(0);
                    if (Character.isDigit(c1) || c1 == '.' && token.length() >= 2 && Character.isDigit(token.charAt(1))) {
                        v.addElement('-' + token);
                    }
                    negative = false;
                } else {
                    v.addElement(token);
                }
                if (!parser.hasMoreTokens()) continue;
                lastToken = token;
                token = parser.nextToken().trim();
                if (token.equals("-")) continue;
                pushBack = true;
            }
            if (completeRangeFlag && entry.isCharacterFormat()) {
                v.addElement(range);
            }
            if (v.size() == 1) {
                SASUserDefinedFormat.addSegment(v.elementAt(0), v.elementAt(0), sexcl, eexcl, value, entry, po);
            } else {
                SASUserDefinedFormat.addSegment(v.elementAt(0), v.elementAt(1), sexcl, eexcl, value, entry, po);
            }
        } else {
            token = parser.nextToken();
            if (token.equalsIgnoreCase(keywords[KW_OTHER])) {
                entry.setOtherValue(value);
                if (po != null) {
                    ((PictureEntry)entry).setPictureOptions(po);
                }
            } else {
                SASUserDefinedFormat.addSegment(token, token, false, false, value, entry, po);
            }
        }
    }

    private static void addSegment(Object min, Object max, boolean sexcl, boolean eexcl, String value, ValueEntry entry, PictureOptions po) {
        RangeSegment segment;
        String start = (String)min;
        String end = (String)max;
        if (start.charAt(0) != '.' && end.charAt(0) != '.') {
            if (entry.isCharacterFormat()) {
                segment = SASUserDefinedFormat.addCharacterRange(start, end);
            } else {
                segment = SASUserDefinedFormat.addNumericRange(start, end);
                if (po != null) {
                    segment = new PictureRangeSegment((NumericRangeSegment)segment, po);
                }
            }
        } else if (start.charAt(0) == '.' && end.charAt(0) == '.') {
            segment = new MissingValueRangeSegment(start, end);
            if (po != null) {
                segment = new PictureRangeSegment((MissingValueRangeSegment)segment, po);
            }
        } else {
            throw new RuntimeException("Error: Cannot mix missing and non-missing values in same range");
        }
        segment.setValue(value);
        segment.setMinExclude(sexcl);
        segment.setMaxExclude(eexcl);
        entry.addRangeSegment(segment);
    }

    private static RangeSegment addNumericRange(String min, String max) {
        double end;
        double start;
        char c = min.charAt(0);
        if (min.equalsIgnoreCase(keywords[KW_LOW])) {
            start = Double.NEGATIVE_INFINITY;
        } else if (min.equalsIgnoreCase(keywords[KW_HIGH])) {
            start = Double.POSITIVE_INFINITY;
        } else if (c == '-' || Character.isDigit(c)) {
            start = Double.valueOf(min);
        } else {
            throw new RuntimeException("Error: The quoted string " + min + " is not acceptable to a numeric format");
        }
        c = max.charAt(0);
        if (max.equalsIgnoreCase(keywords[KW_LOW])) {
            end = Double.NEGATIVE_INFINITY;
        } else if (max.equalsIgnoreCase(keywords[KW_HIGH])) {
            end = Double.POSITIVE_INFINITY;
        } else if (c == '-' || Character.isDigit(c)) {
            end = Double.valueOf(max);
        } else {
            throw new RuntimeException("Error: The quoted string " + max + " is not acceptable to a numeric format");
        }
        if (start > end) {
            throw new RuntimeException("Error: The start value (" + min + ") is greater then the end value (" + max + ")");
        }
        return new NumericRangeSegment(start, end);
    }

    private static RangeSegment addCharacterRange(String min, String max) {
        if (min.equalsIgnoreCase(keywords[KW_HIGH]) || max.equalsIgnoreCase(keywords[KW_LOW]) || min.compareTo(max) > 0) {
            throw new RuntimeException("Error: Start value is greater then end value");
        }
        String end = max.equalsIgnoreCase(keywords[KW_HIGH]) ? null : (max.charAt(0) == '\'' && max.charAt(max.length() - 1) == '\'' ? max.substring(1, max.length() - 1) : max);
        String start = min.equalsIgnoreCase(keywords[KW_LOW]) ? null : (min.charAt(0) == '\'' && min.charAt(min.length() - 1) == '\'' ? min.substring(1, min.length() - 1) : min);
        return new StringRangeSegment(start, end);
    }

    static TableEntry getUserDefinedFormat(String format) {
        return (TableEntry)lookUpTable.get(format);
    }
}

