/*****************************************************************************
FILE:  easytest.cpp
AUTHOR:	Patrick S. Hamilton
REVISED:	5/13/2002 (PSH); 4/10/2003 (GBM)
  ___________________________________________________________________________

easytest.cpp: Use bdac to generate an annotation file.
Copyright (C) 2001 Patrick S. Hamilton
Copyright (C) 1999 George B. Moody

This file is free software; you can redistribute it and/or modify it under
the terms of the GNU Library General Public License as published by the Free
Software Foundation; either version 2 of the License, or (at your option) any
later version.

This software is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
PARTICULAR PURPOSE.  See the GNU Library General Public License for more
details.

You should have received a copy of the GNU Library General Public License along
with this library; if not, write to the Free Software Foundation, Inc., 59
Temple Place - Suite 330, Boston, MA 02111-1307, USA.

You may contact the author by e-mail (pat@eplimited.edu) or postal mail
(Patrick Hamilton, E.P. Limited, 35 Medford St., Suite 204 Somerville,
MA 02143 USA).  For updates to this software, please visit our website
(http://www.eplimited.com).
  __________________________________________________________________________

Easytest.exe is a simple program to help test the performance of our
beat detection and classification software. Data is read from the
indicated ECG file, the channel 1 signal is fed to bdac.c, and the
resulting detections are saved in the annotation file <record>.ate.
<record>.ate may then be compared to <record>.atr to using bxb to
analyze the performance of the the beat detector and classifier detector.

Note that data in the MIT/BIH Arrythmia database file has been sampled
at 360 samples-per-second, but the beat detection and classification
software has been written for data sampled at 200 samples-per-second.
Date is converterted from 360 sps to 200 sps with the function NextSample.
Code for resampling was copied from George Moody's xform utility.  The beat
locations are then adjusted back to coincide with the original sample
rate of 360 samples/second so that the annotation files generated by
easytest can be compared to the "atruth" annotation files.

This file must be linked with object files produced from:
	wfdb software library (source available at www.physionet.org)
	analbeat.cpp
	match.cpp
	rythmchk.cpp
	classify.cpp
	bdac.cpp
	qrsfilt.cpp
	qrsdet.cpp
	postclass.cpp
	noisechk.cpp
  __________________________________________________________________________

  Revisions
	4/13/02:
		Added conditional define statements that allow MIT/BIH or AHA
			records to be processed.
		Normalize input to 5 mV/LSB (200 A-to-D units/mV).

	4/10/03:
		Moved definitions of Record[] array, ECG_DB_PATH, and REC_COUNT
			into "input.h"
	07/07/06:
		Added the compare with WQRS to find noise segments using the Matt's
		algorithm. So the annot output is: time-detection time; anntyp-QRS for 
		beats, NOISE for kurtosis<5(non-ECG) or kurtosis>127(invalid data);
		subtyp- if <0 means kurtosis value and no WQRS annot, if >=0 means
		SQI of Matt's algorithm, 0-100 (matched/all detection beats for 10s), 
		if SQI>50, means Good Quality.
*******************************************************************************/

#include <wfdb/wfdb.h>
#include <wfdb/ecgcodes.h>
#include <wfdb/ecgmap.h>
#include "string.h"
#include "stdio.h"
#include "stdlib.h"
#include "math.h"
#include "qrsdet.h"		// For sample rate.

#include "inputs.h"	/* list of records to analyze and definitions of
			   ECG_DB_PATH and REC_COUNT */

// External function prototypes.
void ResetBDAC(void) ;
int BeatDetectAndClassify(int ecgSample, int *beatType, int *beatMatch) ;

// Local Prototypes.
int  NextSample(int *vout,int nosig,int ifreq,
						int ofreq,int init) ;
int gcd(int x, int y);

// Global variables.

int ADCZero, ADCUnit, InputFileSampleFrequency ;

WFDB_Sample *v;
WFDB_Siginfo *s;
FILE *fp;

#ifdef __STDC__
#define MAINTYPE int
#else
#define MAINTYPE void
#endif
void myquit(char *tempfname2) 
{
		free(s);
		free(v);
    	wfdbquit();
		fscanf(fp,"%s",tempfname2);
}

char *ecglead[19]={"I","II","III","AVR","AVL","AVF","V","V1","V2","V3","V4","V5","V6","MCL1","MCL2","MCL3","MCL4","MCL5","MCL6"};

double mykurtosis(int *data,int n) {
	
	int i;
	double mean,mean4,std,std4;

	mean=0;
	for (i=0;i<n;i++) {
		mean+=data[i];
	}
	mean/=n;
	std=0;
	mean4=0;
	for (i=0;i<n;i++) {
		std+=((data[i]-mean)*(data[i]-mean));
		mean4+=(pow((data[i]-mean),4));
	}
	std4=std*std;
	mean4*=n;
	return(mean4/std4);
}

MAINTYPE main(int argc,char *argv[])
	{
	char record[50], fname[50] ;
	int i, ecg[20], delay, recNum ;
//	WFDB_Siginfo si[3] ;
	WFDB_Anninfo a[2] ;
	WFDB_Annotation annot,annotin ;
	WFDB_Siginfo s[100];
	WFDB_Sample v[20];
	int leadi,leadj;

	unsigned char byte ;
	FILE *newAnn0, *newAnn1 ;
	long SampleCount = 0, lTemp;
	double DetectionTime ; // Changed to double for MIMIC II
	int beatType, beatMatch ;
	char tempfname1[50],tempfname2[50],tempfname[100];
	int nsig,n;
	char *p;
	char tempname[10],tempname1[10],wqrsname[10];
	long next_minute;
	int minutes,spm=60*125,sp5s=5*125,sp10s=10*125;
	int buf5s[5*125],ibuf5s;
	double tempk;
	int filtold,dataold,filt;
	int iswqrs;
	long epltdbuf[100],wqrsbuf[100],matchbuf[100],ismatchbuf[100],timelast,timethis;
	int epltdbufp,wqrsbufp,matchbufp,matchn,epltdn,wqrsn;
	int match_dt;
	char aux1[255];

	// Set up path to database directory
	if (argc<2) {
		fprintf(stderr,"Usage: %s recordfile \n",argv[0]);
		exit(-1);
	}
	wfdbquiet();
	fp=fopen(argv[1],"r");
	if (fp==NULL) {
		fprintf(stderr,"Open recordfile - %s error!\n",argv[1]);
		exit(-1);
	}
	if ((p=index(argv[1],'.'))==NULL) {
		fprintf(stderr,"Recordfile - %s name style error!\n",argv[1]);
		exit(-1);
	}
	n=p-argv[1];
	for (i=0;i<n;i++)
		tempfname1[i]=argv[1][i];
	tempfname1[i++]='/';
	tempfname1[i]='\0';
	fscanf(fp,"%s",tempfname2);
	while (!feof(fp)) 
	{
		strcpy(tempfname,tempfname1);
		strcat(tempfname,tempfname2);
		strcat(tempfname,"/");
		strcat(tempfname,tempfname2);
		printf("\nProcessing %s ... \n",tempfname);

//	setwfdb(ECG_DB_PATH) ;

	// Analyze all 48 MIT/BIH Records.

//	for(recNum = 0; recNum < REC_COUNT; ++recNum)
//		{
//		sprintf(record,"%s","m2w08968");//Records[recNum]) ;
//		printf("Record %s\n","m2w08968");//Records[recNum]) ;
		strcpy(record,tempfname);

		// Open a 2 channel record
		nsig=isigopen(record,NULL,0);
  
/*	    s = (WFDB_Siginfo *)calloc(sizeof(WFDB_Siginfo),nsig);
	    v = (WFDB_Sample *)calloc(sizeof(WFDB_Sample),nsig);
		if (s == NULL || v == NULL ) {
			fprintf(stderr, "insufficient memory\n");
			myquit(tempfname2);
			continue;
	    }
*/
		if(isigopen(record,s,nsig) < 1)
			{
			printf("Couldn't open %s\n",record) ;
			return ;
			}

		setgvmode(WFDB_GVPAD+WFDB_LOWRES);

		InputFileSampleFrequency = 125;//sampfreq(record) ;

		// Setup for output annotations
		for (leadi=0;leadi<nsig;leadi++) 
		for (leadj=0;leadj<19;leadj++) 
			if (strcmp(s[leadi].desc,ecglead[leadj])==0) {
				ADCZero = s[leadi].adczero ;
				ADCUnit = s[leadi].gain ;






		strcpy(tempname1,"A");
		strcpy(tempname,"epltd");
		strcpy(wqrsname,"wqrs");
		
		tempname1[0]+=leadj;
		strcat(tempname,tempname1);
		strcat(wqrsname,tempname1);
		a[0].name = tempname; a[0].stat = WFDB_WRITE ;
		a[1].name = wqrsname; a[1].stat = WFDB_READ;
		
				
		printf("\nECG: %s, leader: %s, annot file: %s\n",tempfname,ecglead[leadj],a[0].name);
		
		if(annopen(record, a, 2) < 0) {
			iswqrs=0;
			if(annopen(record, a, 1) < 0)
				return ;
		}
		else
			iswqrs=1;

		match_dt = (int)strtim(".15");
		timelast=timethis=0;
		for (i=0;i<100;i++) {
			epltdbuf[i]=wqrsbuf[i]=matchbuf[i]=ismatchbuf[i]=0;
		}
		epltdbufp=wqrsbufp=matchbufp=0;
		annotin.time=0;

		// Initialize sampling frequency adjustment.

		NextSample(ecg,nsig,InputFileSampleFrequency,SAMPLE_RATE,1) ;

		// Initialize beat detection and classification.

		ResetBDAC() ;
		SampleCount = 0 ;
		next_minute=spm;
		minutes=0;
		ibuf5s=0;
		filtold=dataold=0;

		// Read data from MIT/BIH file until there is none left.

		while(NextSample(ecg,nsig,InputFileSampleFrequency,SAMPLE_RATE,0) >= 0)
			{
			++SampleCount ;
			
			// Set baseline to 0 and resolution to 5 mV/lsb (200 units/mV)

			lTemp = ecg[leadi]-ADCZero ;
			lTemp *= 200 ;			lTemp /= ADCUnit ;			ecg[leadi] = lTemp ;

			filt=filtold*0.9913112+ecg[leadi]*0.9956556-dataold*0.9956556;  // High pass 0.5Hz filter
			filtold=filt;
			dataold=ecg[leadi];
			
			buf5s[ibuf5s]=filt;
//			buf5s[ibuf5s]=ecg[leadi];
			ibuf5s++;
			if (ibuf5s>=sp5s)
				ibuf5s=0;
			
			// Pass sample to beat detection and classification.

			delay = BeatDetectAndClassify(ecg[leadi], &beatType, &beatMatch) ;

			// If a beat was detected, annotate the beat location
			// and type.

			if(delay != 0)
				{
				DetectionTime = SampleCount - delay ;

				// Convert sample count to input file sample
				// rate.

				DetectionTime *= InputFileSampleFrequency ;
				DetectionTime /= SAMPLE_RATE ;
				annot.time = DetectionTime ;
				annot.anntyp = beatType ;
				tempk=mykurtosis(buf5s,sp5s);
				if (tempk>127) {
					tempk=127;
					annot.anntyp=NOISE;
				}

				annot.subtyp = (char)tempk;
				if (annot.subtyp<5)
					annot.anntyp=NOISE;
				if (annot.subtyp>=127)
					annot.subtyp=-1;
				annot.subtyp = annot.subtyp>1?-annot.subtyp:-1;
				if (iswqrs) {
					while ((getann(0,&annotin)==0)&&(annotin.time<annot.time+match_dt)) {
						wqrsbuf[wqrsbufp]=annotin.time;
						ismatchbuf[wqrsbufp]=0;
						wqrsbufp++;
						if (wqrsbufp>=100)
							wqrsbufp=0;
					}
					ungetann(0,&annotin);
					for (i=0;i<100;i++) {
						if ((abs(annot.time-wqrsbuf[i])<match_dt) && (ismatchbuf[i]==0)) {
							matchbuf[matchbufp++]=annot.time;
							annot.chan=1;
							if (matchbufp>=100)
								matchbufp=0;
							ismatchbuf[i]=1;
						}
					}
					epltdbuf[epltdbufp++]=annot.time;
					if (epltdbufp>=100)
						epltdbufp=0;
					matchn=epltdn=wqrsn=0;
					for (i=0;i<100;i++) {
						if (abs(matchbuf[i]-annot.time)<sp10s) 
							matchn++;
						if (abs(epltdbuf[i]-annot.time)<sp10s) 
							epltdn++;
						if (abs(wqrsbuf[i]-annot.time)<sp10s) 
							wqrsn++;
					}
					if ((wqrsn+epltdn-matchn>0) && (annot.chan==1)) {
						annot.subtyp=(char)(1.0*matchn/(wqrsn+epltdn-matchn)*100);
						if (annot.subtyp>100)
							annot.subtyp=100;
//						sprintf(aux1,"%d%d/%d/%d",8,matchn,epltdn,wqrsn);
//						annot.aux=aux1;
						annot.aux=NULL;
					}
					else {
						annot.subtyp=0;
						annot.aux=NULL;
					}
				}	
				annot.chan = 0;
				annot.num = leadj+1;
//				annot.aux = NULL ;
//				if (annot.subtyp>=5)
					putann(0,&annot) ;
				}
			if (SampleCount>=next_minute) {
				(void)fprintf(stderr, ".");
				(void)fflush(stderr);
				if (++minutes>=60) {
					(void)fprintf(stderr,"%d\n",next_minute/spm);
					minutes=0;
				}
				next_minute+=spm;
			}
			}


		// Reset database after record is done.

//		wfdbquit() ;
 


			isigsettime(0);


				break;
			}


		printf("Processing %s end \n",tempfname);
		myquit(tempfname2);


//#if 0
		/* This code is obsolete.  The annotation files are always
		   written into "<record>.ate" in the current directory.
                   They do not need to be copied in order to be read by bxbep,
		   if the WFDB path includes both the current current directory
		   and the one containing the .atr reference annotation files.
                 */

		// Copy "atest.<record>" to "<record>.ate" for future ascess.
		// (This is necessary for PC files)

/*		sprintf(fname,"%s.ate",record) ;
		newAnn0 = fopen(fname,"rb") ;
		sprintf(fname,"%s%s.ate",ECG_DB_PATH,record) ;
		newAnn1 = fopen(fname,"wb") ;

		// Copy byte image of annotation file in this
		// directory to a correctly named file in the
		// database directory.

		while(fread(&byte,sizeof(char),1,newAnn0) == 1)
			fwrite(&byte,sizeof(char),1,newAnn1) ;

		fclose(newAnn0) ;
		fclose(newAnn1) ;
*/
//#endif
		}
	}

/**********************************************************************
	NextSample reads MIT/BIH Arrhythmia data from a file of data
	sampled at ifreq and returns data sampled at ofreq.  Data is
	returned in vout via *vout.  NextSample must be initialized by
	passing in a nonzero value in init.  NextSample returns -1 when
   there is no more data left.
***********************************************************************/

int  NextSample(int *vout,int nosig,int ifreq,
						int ofreq,int init)
	{
	int i ;
	static int m, n, mn, ot, it, vv[WFDB_MAXSIG], v[WFDB_MAXSIG], rval ;

	if(init)
		{
		i = gcd(ifreq, ofreq);
		m = ifreq/i;
		n = ofreq/i;
		mn = m*n;
		ot = it = 0 ;
		getvec(vv) ;
		rval = getvec(v) ;
		}

	else
		{
		while(ot > it)
			{
	    	for(i = 0; i < nosig; ++i)
	    		vv[i] = v[i] ;
			rval = getvec(v) ;
		    if (it > mn) { it -= mn; ot -= mn; }
		    it += n;
		    }		
	    for(i = 0; i < nosig; ++i)
	    	vout[i] = vv[i] + (ot%n)*(v[i]-vv[i])/n;
		ot += m;
		}

	return(rval) ;
	}

// Greatest common divisor of x and y (Euclid's algorithm)

int gcd(int x, int y)
	{
	while (x != y) {
		if (x > y) x-=y;
		else y -= x;
		}
	return (x);
	}


