import logging
logging.basicConfig(level=logging.INFO)
from devopsX.abstractdevops import AbstractDevOps

# Represents a software Project
class Project(AbstractDevOps):

	def __init__(self,personal_access_token, organization_url):
		super(Project,self).__init__(personal_access_token=personal_access_token,organization_url=organization_url)
	
	# Returns a list of project
	def get_all(self, today=False): 
		projects = []
		try:
			logging.info("Start function: get_projects")
			
			projects = self.core_client.get_projects().value
				
		except Exception as e: 
			logging.error("OS error: {0}".format(e))
			logging.error(e.__dict__) 

		logging.info("Retrieve All Projects")
		
		return projects

	def get_processes(self):
		return self.work_item_process_tracking_client.get_list_of_processes()

	def get_process_behaviors(self, process_id):
		return self.work_item_process_tracking_client.get_process_behaviors(process_id)
    
	def get_process_by_its_id(self, process_type_id):
		return self.work_item_process_tracking_client.get_process_by_its_id(process_type_id)
    
	def get_state_definitions(self, process_id):
		return self.work_item_process_tracking_client.get_state_definitions(process_id)