import * as ec2 from 'aws-cdk-lib/aws-ec2';
export interface SessionManagerEndpointProps {
    /**
     *
     */
    readonly services: ec2.InterfaceVpcEndpointAwsService[];
    /**
     * Prefix used to identity CloudFormation cross-stack exports.
     *
     * @default 'SessionManagerEndpoints'
     */
    readonly exportPrefix?: string;
    /**
     * To which VPC these endpoints are assigned.
     */
    readonly vpc: ec2.IVpc;
    /**
     * To which subnets the endpoints are assigned.
     *
     * @default
     * { subnetType: ec2.SubnetType.PRIVATE_ISOLATED }
     */
    readonly subnets?: ec2.SubnetSelection;
    /**
     * The security groups to associate with this interface VPC endpoint.
     *
     * @default - a new security group is created
     */
    readonly securityGroups?: ec2.ISecurityGroup[];
    /**
     * Whether to automatically allow VPC traffic to the endpoint.
     *
     * If enabled, all traffic to the endpoint from within the VPC will be automatically allowed. This is done based on the VPC's CIDR range.
     *
     * @default
     * true
     */
    readonly open?: boolean;
}
