"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.AwsInterfaceEndpoints = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdk = require("aws-cdk-lib");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const ec2 = require("aws-cdk-lib/aws-ec2");
const change_case_1 = require("change-case");
const constructs_1 = require("constructs");
class AwsInterfaceEndpoints extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        const { exportPrefix = 'SessionManagerEndpoints', services } = props;
        const endpointProps = {
            vpc: props.vpc,
            subnets: props.subnets || { subnetType: ec2.SubnetType.PRIVATE_ISOLATED },
            open: typeof props.open !== 'undefined' ? props.open : true,
            securityGroups: props.securityGroups,
        };
        this.endpointServices = services.map(service => ({
            service: service,
            endpoint: this.defineEndpoint(this, change_case_1.pascalCase(service.name), {
                service,
                ...endpointProps,
                exportPrefix,
            }),
        }));
    }
    static fromAttributes(scope, id, props) {
        const { exportPrefix = 'SessionManagerEndpoints', services } = props;
        class Import extends aws_cdk_lib_1.Resource {
            constructor(_scope, _id) {
                super(_scope, _id);
                this.endpointServices = services.map(service => ({
                    service,
                    endpoint: ec2.InterfaceVpcEndpoint.fromInterfaceVpcEndpointAttributes(_scope, service.name, {
                        port: service.port,
                        vpcEndpointId: cdk.Fn.importValue(`${exportPrefix}/${service.name}`),
                    }),
                }));
            }
            allowDefaultPromFrom(connectable) {
                this.endpointServices.forEach(endpointService => endpointService.endpoint.connections.allowDefaultPortFrom(connectable));
            }
        }
        return new Import(scope, id);
    }
    defineEndpoint(scope, id, props) {
        const endpoint = new ec2.InterfaceVpcEndpoint(scope, id, props);
        const tags = cdk.Tags.of(endpoint);
        tags.add('Name', endpoint.node.path);
        const { exportPrefix, service } = props;
        new cdk.CfnOutput(this, service.name, {
            value: endpoint.vpcEndpointId,
            exportName: `${exportPrefix}/${service.name}`,
        });
        return endpoint;
    }
    allowDefaultPromFrom(connectable) {
        this.endpointServices.forEach(endpointService => endpointService.endpoint.connections.allowDefaultPortFrom(connectable));
    }
}
exports.AwsInterfaceEndpoints = AwsInterfaceEndpoints;
_a = JSII_RTTI_SYMBOL_1;
AwsInterfaceEndpoints[_a] = { fqn: "@alma-cdk/aws-interface-endpoints.AwsInterfaceEndpoints", version: "0.0.2" };
AwsInterfaceEndpoints.SessionManagerConnect = [
    ec2.InterfaceVpcEndpointAwsService.SSM,
    ec2.InterfaceVpcEndpointAwsService.EC2_MESSAGES,
    ec2.InterfaceVpcEndpointAwsService.SSM_MESSAGES,
];
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiZW5kcG9pbnQuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi9zcmMvZW5kcG9pbnQudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7Ozs7QUFBQSxtQ0FBbUM7QUFDbkMsNkNBQXVDO0FBQ3ZDLDJDQUEyQztBQUMzQyw2Q0FBeUM7QUFDekMsMkNBQXVDO0FBeUJ2QyxNQUFhLHFCQUFzQixTQUFRLHNCQUFTO0lBeUNsRCxZQUFZLEtBQWdCLEVBQUUsRUFBVSxFQUFFLEtBQWtDO1FBQzFFLEtBQUssQ0FBQyxLQUFLLEVBQUUsRUFBRSxDQUFDLENBQUM7UUFFakIsTUFBTSxFQUFFLFlBQVksR0FBRyx5QkFBeUIsRUFBRSxRQUFRLEVBQUUsR0FBRyxLQUFLLENBQUM7UUFFckUsTUFBTSxhQUFhLEdBQXdCO1lBQ3pDLEdBQUcsRUFBRSxLQUFLLENBQUMsR0FBRztZQUNkLE9BQU8sRUFBRSxLQUFLLENBQUMsT0FBTyxJQUFJLEVBQUUsVUFBVSxFQUFFLEdBQUcsQ0FBQyxVQUFVLENBQUMsZ0JBQWdCLEVBQUU7WUFDekUsSUFBSSxFQUFFLE9BQU8sS0FBSyxDQUFDLElBQUksS0FBSyxXQUFXLENBQUMsQ0FBQyxDQUFDLEtBQUssQ0FBQyxJQUFJLENBQUMsQ0FBQyxDQUFDLElBQUk7WUFDM0QsY0FBYyxFQUFFLEtBQUssQ0FBQyxjQUFjO1NBQ3JDLENBQUM7UUFFRixJQUFJLENBQUMsZ0JBQWdCLEdBQUcsUUFBUSxDQUFDLEdBQUcsQ0FBQyxPQUFPLENBQUMsRUFBRSxDQUFDLENBQUM7WUFDL0MsT0FBTyxFQUFFLE9BQU87WUFDaEIsUUFBUSxFQUFFLElBQUksQ0FBQyxjQUFjLENBQUMsSUFBSSxFQUFFLHdCQUFVLENBQUMsT0FBTyxDQUFDLElBQUksQ0FBQyxFQUFFO2dCQUM1RCxPQUFPO2dCQUNQLEdBQUcsYUFBYTtnQkFDaEIsWUFBWTthQUNiLENBQUM7U0FDSCxDQUFDLENBQUMsQ0FBQztJQUVOLENBQUM7SUFyRE0sTUFBTSxDQUFDLGNBQWMsQ0FBQyxLQUFnQixFQUFFLEVBQVUsRUFBRSxLQUFrQjtRQUUzRSxNQUFNLEVBQUUsWUFBWSxHQUFHLHlCQUF5QixFQUFFLFFBQVEsRUFBRSxHQUFHLEtBQUssQ0FBQztRQUVyRSxNQUFNLE1BQU8sU0FBUSxzQkFBUTtZQUkzQixZQUFZLE1BQWlCLEVBQUUsR0FBVztnQkFDeEMsS0FBSyxDQUFDLE1BQU0sRUFBRSxHQUFHLENBQUMsQ0FBQztnQkFFbkIsSUFBSSxDQUFDLGdCQUFnQixHQUFHLFFBQVEsQ0FBQyxHQUFHLENBQUMsT0FBTyxDQUFDLEVBQUUsQ0FBQyxDQUFDO29CQUMvQyxPQUFPO29CQUNQLFFBQVEsRUFBRSxHQUFHLENBQUMsb0JBQW9CLENBQUMsa0NBQWtDLENBQUMsTUFBTSxFQUFFLE9BQU8sQ0FBQyxJQUFJLEVBQUU7d0JBQzFGLElBQUksRUFBRSxPQUFPLENBQUMsSUFBSTt3QkFDbEIsYUFBYSxFQUFFLEdBQUcsQ0FBQyxFQUFFLENBQUMsV0FBVyxDQUFDLEdBQUcsWUFBWSxJQUFJLE9BQU8sQ0FBQyxJQUFJLEVBQUUsQ0FBQztxQkFDckUsQ0FBQztpQkFDSCxDQUFDLENBQUMsQ0FBQztZQUVOLENBQUM7WUFFTSxvQkFBb0IsQ0FBQyxXQUE2QjtnQkFDdkQsSUFBSSxDQUFDLGdCQUFnQixDQUFDLE9BQU8sQ0FBQyxlQUFlLENBQUMsRUFBRSxDQUFDLGVBQWUsQ0FBQyxRQUFRLENBQUMsV0FBVyxDQUFDLG9CQUFvQixDQUFDLFdBQVcsQ0FBQyxDQUFDLENBQUM7WUFDM0gsQ0FBQztTQUNGO1FBRUQsT0FBTyxJQUFJLE1BQU0sQ0FBQyxLQUFLLEVBQUUsRUFBRSxDQUFDLENBQUM7SUFDL0IsQ0FBQztJQTRCTyxjQUFjLENBQUMsS0FBZ0IsRUFBRSxFQUFVLEVBQUUsS0FBMEI7UUFDN0UsTUFBTSxRQUFRLEdBQUcsSUFBSSxHQUFHLENBQUMsb0JBQW9CLENBQUMsS0FBSyxFQUFFLEVBQUUsRUFBRSxLQUFLLENBQUMsQ0FBQztRQUVoRSxNQUFNLElBQUksR0FBRyxHQUFHLENBQUMsSUFBSSxDQUFDLEVBQUUsQ0FBQyxRQUFRLENBQUMsQ0FBQztRQUVuQyxJQUFJLENBQUMsR0FBRyxDQUFDLE1BQU0sRUFBRSxRQUFRLENBQUMsSUFBSSxDQUFDLElBQUksQ0FBQyxDQUFDO1FBRXJDLE1BQU0sRUFBRSxZQUFZLEVBQUUsT0FBTyxFQUFFLEdBQUcsS0FBSyxDQUFDO1FBRXhDLElBQUksR0FBRyxDQUFDLFNBQVMsQ0FBQyxJQUFJLEVBQUUsT0FBTyxDQUFDLElBQUksRUFBRTtZQUNwQyxLQUFLLEVBQUUsUUFBUSxDQUFDLGFBQWE7WUFDN0IsVUFBVSxFQUFFLEdBQUcsWUFBWSxJQUFJLE9BQU8sQ0FBQyxJQUFJLEVBQUU7U0FDOUMsQ0FBQyxDQUFDO1FBRUgsT0FBTyxRQUFRLENBQUM7SUFDbEIsQ0FBQztJQUVNLG9CQUFvQixDQUFDLFdBQTZCO1FBQ3ZELElBQUksQ0FBQyxnQkFBZ0IsQ0FBQyxPQUFPLENBQUMsZUFBZSxDQUFDLEVBQUUsQ0FBQyxlQUFlLENBQUMsUUFBUSxDQUFDLFdBQVcsQ0FBQyxvQkFBb0IsQ0FBQyxXQUFXLENBQUMsQ0FBQyxDQUFDO0lBQzNILENBQUM7O0FBbkZILHNEQXFGQzs7O0FBbEZ3QiwyQ0FBcUIsR0FBRztJQUM3QyxHQUFHLENBQUMsOEJBQThCLENBQUMsR0FBRztJQUN0QyxHQUFHLENBQUMsOEJBQThCLENBQUMsWUFBWTtJQUMvQyxHQUFHLENBQUMsOEJBQThCLENBQUMsWUFBWTtDQUNoRCxDQUFDIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0ICogYXMgY2RrIGZyb20gJ2F3cy1jZGstbGliJztcbmltcG9ydCB7IFJlc291cmNlIH0gZnJvbSAnYXdzLWNkay1saWInO1xuaW1wb3J0ICogYXMgZWMyIGZyb20gJ2F3cy1jZGstbGliL2F3cy1lYzInO1xuaW1wb3J0IHsgcGFzY2FsQ2FzZSB9IGZyb20gJ2NoYW5nZS1jYXNlJztcbmltcG9ydCB7IENvbnN0cnVjdCB9IGZyb20gJ2NvbnN0cnVjdHMnO1xuaW1wb3J0IHsgSUF3c0ludGVyZmFjZUVuZHBvaW50cyB9IGZyb20gJy4vY29udHJhY3QnO1xuaW1wb3J0IHsgU2Vzc2lvbk1hbmFnZXJFbmRwb2ludFByb3BzIH0gZnJvbSAnLi9wcm9wcyc7XG5cblxuaW50ZXJmYWNlIFNoYXJlZEVuZHBvaW50UHJvcHMge1xuICByZWFkb25seSB2cGM6IGVjMi5JVnBjO1xuICByZWFkb25seSBzdWJuZXRzOiBlYzIuU3VibmV0U2VsZWN0aW9uO1xuICByZWFkb25seSBvcGVuOiBib29sZWFuO1xuICByZWFkb25seSBzZWN1cml0eUdyb3Vwcz86IGVjMi5JU2VjdXJpdHlHcm91cFtdO1xufVxuXG5cbmludGVyZmFjZSBDcmVhdGVFbmRwb2ludFByb3BzIGV4dGVuZHMgU2hhcmVkRW5kcG9pbnRQcm9wcyB7XG4gIHJlYWRvbmx5IHNlcnZpY2U6IGVjMi5JbnRlcmZhY2VWcGNFbmRwb2ludEF3c1NlcnZpY2U7XG4gIHJlYWRvbmx5IGV4cG9ydFByZWZpeDogc3RyaW5nO1xufVxuXG5cbmludGVyZmFjZSBFbmRwb2ludFNlcnZpY2Uge1xuICBlbmRwb2ludDogZWMyLklJbnRlcmZhY2VWcGNFbmRwb2ludDtcbiAgc2VydmljZTogZWMyLkludGVyZmFjZVZwY0VuZHBvaW50QXdzU2VydmljZTtcbn1cblxuXG5leHBvcnQgY2xhc3MgQXdzSW50ZXJmYWNlRW5kcG9pbnRzIGV4dGVuZHMgQ29uc3RydWN0IGltcGxlbWVudHMgSUF3c0ludGVyZmFjZUVuZHBvaW50cyB7XG5cblxuICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IFNlc3Npb25NYW5hZ2VyQ29ubmVjdCA9IFtcbiAgICBlYzIuSW50ZXJmYWNlVnBjRW5kcG9pbnRBd3NTZXJ2aWNlLlNTTSxcbiAgICBlYzIuSW50ZXJmYWNlVnBjRW5kcG9pbnRBd3NTZXJ2aWNlLkVDMl9NRVNTQUdFUyxcbiAgICBlYzIuSW50ZXJmYWNlVnBjRW5kcG9pbnRBd3NTZXJ2aWNlLlNTTV9NRVNTQUdFUyxcbiAgXTtcblxuICBwdWJsaWMgc3RhdGljIGZyb21BdHRyaWJ1dGVzKHNjb3BlOiBDb25zdHJ1Y3QsIGlkOiBzdHJpbmcsIHByb3BzOiBMb29rdXBQcm9wcyk6IElBd3NJbnRlcmZhY2VFbmRwb2ludHMge1xuXG4gICAgY29uc3QgeyBleHBvcnRQcmVmaXggPSAnU2Vzc2lvbk1hbmFnZXJFbmRwb2ludHMnLCBzZXJ2aWNlcyB9ID0gcHJvcHM7XG5cbiAgICBjbGFzcyBJbXBvcnQgZXh0ZW5kcyBSZXNvdXJjZSBpbXBsZW1lbnRzIElBd3NJbnRlcmZhY2VFbmRwb2ludHMge1xuXG4gICAgICBwcml2YXRlIHJlYWRvbmx5IGVuZHBvaW50U2VydmljZXM6IEVuZHBvaW50U2VydmljZVtdO1xuXG4gICAgICBjb25zdHJ1Y3Rvcihfc2NvcGU6IENvbnN0cnVjdCwgX2lkOiBzdHJpbmcpIHtcbiAgICAgICAgc3VwZXIoX3Njb3BlLCBfaWQpO1xuXG4gICAgICAgIHRoaXMuZW5kcG9pbnRTZXJ2aWNlcyA9IHNlcnZpY2VzLm1hcChzZXJ2aWNlID0+ICh7XG4gICAgICAgICAgc2VydmljZSxcbiAgICAgICAgICBlbmRwb2ludDogZWMyLkludGVyZmFjZVZwY0VuZHBvaW50LmZyb21JbnRlcmZhY2VWcGNFbmRwb2ludEF0dHJpYnV0ZXMoX3Njb3BlLCBzZXJ2aWNlLm5hbWUsIHtcbiAgICAgICAgICAgIHBvcnQ6IHNlcnZpY2UucG9ydCxcbiAgICAgICAgICAgIHZwY0VuZHBvaW50SWQ6IGNkay5Gbi5pbXBvcnRWYWx1ZShgJHtleHBvcnRQcmVmaXh9LyR7c2VydmljZS5uYW1lfWApLFxuICAgICAgICAgIH0pLFxuICAgICAgICB9KSk7XG5cbiAgICAgIH1cblxuICAgICAgcHVibGljIGFsbG93RGVmYXVsdFByb21Gcm9tKGNvbm5lY3RhYmxlOiBlYzIuSUNvbm5lY3RhYmxlKTogdm9pZCB7XG4gICAgICAgIHRoaXMuZW5kcG9pbnRTZXJ2aWNlcy5mb3JFYWNoKGVuZHBvaW50U2VydmljZSA9PiBlbmRwb2ludFNlcnZpY2UuZW5kcG9pbnQuY29ubmVjdGlvbnMuYWxsb3dEZWZhdWx0UG9ydEZyb20oY29ubmVjdGFibGUpKTtcbiAgICAgIH1cbiAgICB9XG5cbiAgICByZXR1cm4gbmV3IEltcG9ydChzY29wZSwgaWQpO1xuICB9XG5cblxuICBwcml2YXRlIHJlYWRvbmx5IGVuZHBvaW50U2VydmljZXM6IEVuZHBvaW50U2VydmljZVtdO1xuXG4gIGNvbnN0cnVjdG9yKHNjb3BlOiBDb25zdHJ1Y3QsIGlkOiBzdHJpbmcsIHByb3BzOiBTZXNzaW9uTWFuYWdlckVuZHBvaW50UHJvcHMpIHtcbiAgICBzdXBlcihzY29wZSwgaWQpO1xuXG4gICAgY29uc3QgeyBleHBvcnRQcmVmaXggPSAnU2Vzc2lvbk1hbmFnZXJFbmRwb2ludHMnLCBzZXJ2aWNlcyB9ID0gcHJvcHM7XG5cbiAgICBjb25zdCBlbmRwb2ludFByb3BzOiBTaGFyZWRFbmRwb2ludFByb3BzID0ge1xuICAgICAgdnBjOiBwcm9wcy52cGMsXG4gICAgICBzdWJuZXRzOiBwcm9wcy5zdWJuZXRzIHx8IHsgc3VibmV0VHlwZTogZWMyLlN1Ym5ldFR5cGUuUFJJVkFURV9JU09MQVRFRCB9LFxuICAgICAgb3BlbjogdHlwZW9mIHByb3BzLm9wZW4gIT09ICd1bmRlZmluZWQnID8gcHJvcHMub3BlbiA6IHRydWUsXG4gICAgICBzZWN1cml0eUdyb3VwczogcHJvcHMuc2VjdXJpdHlHcm91cHMsXG4gICAgfTtcblxuICAgIHRoaXMuZW5kcG9pbnRTZXJ2aWNlcyA9IHNlcnZpY2VzLm1hcChzZXJ2aWNlID0+ICh7XG4gICAgICBzZXJ2aWNlOiBzZXJ2aWNlLFxuICAgICAgZW5kcG9pbnQ6IHRoaXMuZGVmaW5lRW5kcG9pbnQodGhpcywgcGFzY2FsQ2FzZShzZXJ2aWNlLm5hbWUpLCB7XG4gICAgICAgIHNlcnZpY2UsXG4gICAgICAgIC4uLmVuZHBvaW50UHJvcHMsXG4gICAgICAgIGV4cG9ydFByZWZpeCxcbiAgICAgIH0pLFxuICAgIH0pKTtcblxuICB9XG5cbiAgcHJpdmF0ZSBkZWZpbmVFbmRwb2ludChzY29wZTogQ29uc3RydWN0LCBpZDogc3RyaW5nLCBwcm9wczogQ3JlYXRlRW5kcG9pbnRQcm9wcyk6IGVjMi5JbnRlcmZhY2VWcGNFbmRwb2ludCB7XG4gICAgY29uc3QgZW5kcG9pbnQgPSBuZXcgZWMyLkludGVyZmFjZVZwY0VuZHBvaW50KHNjb3BlLCBpZCwgcHJvcHMpO1xuXG4gICAgY29uc3QgdGFncyA9IGNkay5UYWdzLm9mKGVuZHBvaW50KTtcblxuICAgIHRhZ3MuYWRkKCdOYW1lJywgZW5kcG9pbnQubm9kZS5wYXRoKTtcblxuICAgIGNvbnN0IHsgZXhwb3J0UHJlZml4LCBzZXJ2aWNlIH0gPSBwcm9wcztcblxuICAgIG5ldyBjZGsuQ2ZuT3V0cHV0KHRoaXMsIHNlcnZpY2UubmFtZSwge1xuICAgICAgdmFsdWU6IGVuZHBvaW50LnZwY0VuZHBvaW50SWQsXG4gICAgICBleHBvcnROYW1lOiBgJHtleHBvcnRQcmVmaXh9LyR7c2VydmljZS5uYW1lfWAsXG4gICAgfSk7XG5cbiAgICByZXR1cm4gZW5kcG9pbnQ7XG4gIH1cblxuICBwdWJsaWMgYWxsb3dEZWZhdWx0UHJvbUZyb20oY29ubmVjdGFibGU6IGVjMi5JQ29ubmVjdGFibGUpOiB2b2lkIHtcbiAgICB0aGlzLmVuZHBvaW50U2VydmljZXMuZm9yRWFjaChlbmRwb2ludFNlcnZpY2UgPT4gZW5kcG9pbnRTZXJ2aWNlLmVuZHBvaW50LmNvbm5lY3Rpb25zLmFsbG93RGVmYXVsdFBvcnRGcm9tKGNvbm5lY3RhYmxlKSk7XG4gIH1cblxufVxuXG5leHBvcnQgaW50ZXJmYWNlIExvb2t1cFByb3BzIHtcblxuICAvKipcbiAgICpcbiAgICovXG4gIHJlYWRvbmx5IHNlcnZpY2VzOiBlYzIuSW50ZXJmYWNlVnBjRW5kcG9pbnRBd3NTZXJ2aWNlW107XG5cbiAgLyoqXG4gICAqIFByZWZpeCB1c2VkIHRvIGlkZW50aXR5IENsb3VkRm9ybWF0aW9uIGNyb3NzLXN0YWNrIGV4cG9ydHMuXG4gICAqXG4gICAqIEBkZWZhdWx0ICdTZXNzaW9uTWFuYWdlckVuZHBvaW50cydcbiAgICovXG4gIHJlYWRvbmx5IGV4cG9ydFByZWZpeD86IHN0cmluZztcbn1cblxuIl19