import * as cdk from 'aws-cdk-lib';
import * as ec2 from 'aws-cdk-lib/aws-ec2';
import { Construct } from 'constructs';
import { IAwsInterfaceEndpoints } from './contract';
import { SessionManagerEndpointProps } from './props';
export declare class AwsInterfaceEndpoints extends Construct implements IAwsInterfaceEndpoints {
    static readonly SessionManagerConnect: cdk.aws_ec2.InterfaceVpcEndpointAwsService[];
    static fromAttributes(scope: Construct, id: string, props: LookupProps): IAwsInterfaceEndpoints;
    private readonly endpointServices;
    constructor(scope: Construct, id: string, props: SessionManagerEndpointProps);
    private defineEndpoint;
    allowDefaultPromFrom(connectable: ec2.IConnectable): void;
}
export interface LookupProps {
    /**
     *
     */
    readonly services: ec2.InterfaceVpcEndpointAwsService[];
    /**
     * Prefix used to identity CloudFormation cross-stack exports.
     *
     * @default 'SessionManagerEndpoints'
     */
    readonly exportPrefix?: string;
}
