# API Reference <a name="API Reference" id="api-reference"></a>

## Constructs <a name="Constructs" id="Constructs"></a>

### AwsInterfaceEndpoints <a name="AwsInterfaceEndpoints" id="@alma-cdk/aws-interface-endpoints.AwsInterfaceEndpoints"></a>

- *Implements:* <a href="#@alma-cdk/aws-interface-endpoints.IAwsInterfaceEndpoints">IAwsInterfaceEndpoints</a>

#### Initializers <a name="Initializers" id="@alma-cdk/aws-interface-endpoints.AwsInterfaceEndpoints.Initializer"></a>

```typescript
import { AwsInterfaceEndpoints } from '@alma-cdk/aws-interface-endpoints'

new AwsInterfaceEndpoints(scope: Construct, id: string, props: SessionManagerEndpointProps)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@alma-cdk/aws-interface-endpoints.AwsInterfaceEndpoints.Initializer.parameter.scope">scope</a></code> | <code>constructs.Construct</code> | *No description.* |
| <code><a href="#@alma-cdk/aws-interface-endpoints.AwsInterfaceEndpoints.Initializer.parameter.id">id</a></code> | <code>string</code> | *No description.* |
| <code><a href="#@alma-cdk/aws-interface-endpoints.AwsInterfaceEndpoints.Initializer.parameter.props">props</a></code> | <code><a href="#@alma-cdk/aws-interface-endpoints.SessionManagerEndpointProps">SessionManagerEndpointProps</a></code> | *No description.* |

---

##### `scope`<sup>Required</sup> <a name="scope" id="@alma-cdk/aws-interface-endpoints.AwsInterfaceEndpoints.Initializer.parameter.scope"></a>

- *Type:* constructs.Construct

---

##### `id`<sup>Required</sup> <a name="id" id="@alma-cdk/aws-interface-endpoints.AwsInterfaceEndpoints.Initializer.parameter.id"></a>

- *Type:* string

---

##### `props`<sup>Required</sup> <a name="props" id="@alma-cdk/aws-interface-endpoints.AwsInterfaceEndpoints.Initializer.parameter.props"></a>

- *Type:* <a href="#@alma-cdk/aws-interface-endpoints.SessionManagerEndpointProps">SessionManagerEndpointProps</a>

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#@alma-cdk/aws-interface-endpoints.AwsInterfaceEndpoints.toString">toString</a></code> | Returns a string representation of this construct. |
| <code><a href="#@alma-cdk/aws-interface-endpoints.AwsInterfaceEndpoints.allowDefaultPromFrom">allowDefaultPromFrom</a></code> | *No description.* |

---

##### `toString` <a name="toString" id="@alma-cdk/aws-interface-endpoints.AwsInterfaceEndpoints.toString"></a>

```typescript
public toString(): string
```

Returns a string representation of this construct.

##### `allowDefaultPromFrom` <a name="allowDefaultPromFrom" id="@alma-cdk/aws-interface-endpoints.AwsInterfaceEndpoints.allowDefaultPromFrom"></a>

```typescript
public allowDefaultPromFrom(connectable: IConnectable): void
```

###### `connectable`<sup>Required</sup> <a name="connectable" id="@alma-cdk/aws-interface-endpoints.AwsInterfaceEndpoints.allowDefaultPromFrom.parameter.connectable"></a>

- *Type:* aws-cdk-lib.aws_ec2.IConnectable

---

#### Static Functions <a name="Static Functions" id="Static Functions"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#@alma-cdk/aws-interface-endpoints.AwsInterfaceEndpoints.isConstruct">isConstruct</a></code> | Checks if `x` is a construct. |
| <code><a href="#@alma-cdk/aws-interface-endpoints.AwsInterfaceEndpoints.fromAttributes">fromAttributes</a></code> | *No description.* |

---

##### ~~`isConstruct`~~ <a name="isConstruct" id="@alma-cdk/aws-interface-endpoints.AwsInterfaceEndpoints.isConstruct"></a>

```typescript
import { AwsInterfaceEndpoints } from '@alma-cdk/aws-interface-endpoints'

AwsInterfaceEndpoints.isConstruct(x: any)
```

Checks if `x` is a construct.

###### `x`<sup>Required</sup> <a name="x" id="@alma-cdk/aws-interface-endpoints.AwsInterfaceEndpoints.isConstruct.parameter.x"></a>

- *Type:* any

Any object.

---

##### `fromAttributes` <a name="fromAttributes" id="@alma-cdk/aws-interface-endpoints.AwsInterfaceEndpoints.fromAttributes"></a>

```typescript
import { AwsInterfaceEndpoints } from '@alma-cdk/aws-interface-endpoints'

AwsInterfaceEndpoints.fromAttributes(scope: Construct, id: string, props: LookupProps)
```

###### `scope`<sup>Required</sup> <a name="scope" id="@alma-cdk/aws-interface-endpoints.AwsInterfaceEndpoints.fromAttributes.parameter.scope"></a>

- *Type:* constructs.Construct

---

###### `id`<sup>Required</sup> <a name="id" id="@alma-cdk/aws-interface-endpoints.AwsInterfaceEndpoints.fromAttributes.parameter.id"></a>

- *Type:* string

---

###### `props`<sup>Required</sup> <a name="props" id="@alma-cdk/aws-interface-endpoints.AwsInterfaceEndpoints.fromAttributes.parameter.props"></a>

- *Type:* <a href="#@alma-cdk/aws-interface-endpoints.LookupProps">LookupProps</a>

---

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@alma-cdk/aws-interface-endpoints.AwsInterfaceEndpoints.property.node">node</a></code> | <code>constructs.Node</code> | The tree node. |

---

##### `node`<sup>Required</sup> <a name="node" id="@alma-cdk/aws-interface-endpoints.AwsInterfaceEndpoints.property.node"></a>

```typescript
public readonly node: Node;
```

- *Type:* constructs.Node

The tree node.

---

#### Constants <a name="Constants" id="Constants"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@alma-cdk/aws-interface-endpoints.AwsInterfaceEndpoints.property.SessionManagerConnect">SessionManagerConnect</a></code> | <code>aws-cdk-lib.aws_ec2.InterfaceVpcEndpointAwsService[]</code> | *No description.* |

---

##### `SessionManagerConnect`<sup>Required</sup> <a name="SessionManagerConnect" id="@alma-cdk/aws-interface-endpoints.AwsInterfaceEndpoints.property.SessionManagerConnect"></a>

```typescript
public readonly SessionManagerConnect: InterfaceVpcEndpointAwsService[];
```

- *Type:* aws-cdk-lib.aws_ec2.InterfaceVpcEndpointAwsService[]

---

## Structs <a name="Structs" id="Structs"></a>

### LookupProps <a name="LookupProps" id="@alma-cdk/aws-interface-endpoints.LookupProps"></a>

#### Initializer <a name="Initializer" id="@alma-cdk/aws-interface-endpoints.LookupProps.Initializer"></a>

```typescript
import { LookupProps } from '@alma-cdk/aws-interface-endpoints'

const lookupProps: LookupProps = { ... }
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@alma-cdk/aws-interface-endpoints.LookupProps.property.services">services</a></code> | <code>aws-cdk-lib.aws_ec2.InterfaceVpcEndpointAwsService[]</code> | *No description.* |
| <code><a href="#@alma-cdk/aws-interface-endpoints.LookupProps.property.exportPrefix">exportPrefix</a></code> | <code>string</code> | Prefix used to identity CloudFormation cross-stack exports. |

---

##### `services`<sup>Required</sup> <a name="services" id="@alma-cdk/aws-interface-endpoints.LookupProps.property.services"></a>

```typescript
public readonly services: InterfaceVpcEndpointAwsService[];
```

- *Type:* aws-cdk-lib.aws_ec2.InterfaceVpcEndpointAwsService[]

---

##### `exportPrefix`<sup>Optional</sup> <a name="exportPrefix" id="@alma-cdk/aws-interface-endpoints.LookupProps.property.exportPrefix"></a>

```typescript
public readonly exportPrefix: string;
```

- *Type:* string
- *Default:* 'SessionManagerEndpoints'

Prefix used to identity CloudFormation cross-stack exports.

---

### SessionManagerEndpointProps <a name="SessionManagerEndpointProps" id="@alma-cdk/aws-interface-endpoints.SessionManagerEndpointProps"></a>

#### Initializer <a name="Initializer" id="@alma-cdk/aws-interface-endpoints.SessionManagerEndpointProps.Initializer"></a>

```typescript
import { SessionManagerEndpointProps } from '@alma-cdk/aws-interface-endpoints'

const sessionManagerEndpointProps: SessionManagerEndpointProps = { ... }
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#@alma-cdk/aws-interface-endpoints.SessionManagerEndpointProps.property.services">services</a></code> | <code>aws-cdk-lib.aws_ec2.InterfaceVpcEndpointAwsService[]</code> | *No description.* |
| <code><a href="#@alma-cdk/aws-interface-endpoints.SessionManagerEndpointProps.property.vpc">vpc</a></code> | <code>aws-cdk-lib.aws_ec2.IVpc</code> | To which VPC these endpoints are assigned. |
| <code><a href="#@alma-cdk/aws-interface-endpoints.SessionManagerEndpointProps.property.exportPrefix">exportPrefix</a></code> | <code>string</code> | Prefix used to identity CloudFormation cross-stack exports. |
| <code><a href="#@alma-cdk/aws-interface-endpoints.SessionManagerEndpointProps.property.open">open</a></code> | <code>boolean</code> | Whether to automatically allow VPC traffic to the endpoint. |
| <code><a href="#@alma-cdk/aws-interface-endpoints.SessionManagerEndpointProps.property.securityGroups">securityGroups</a></code> | <code>aws-cdk-lib.aws_ec2.ISecurityGroup[]</code> | The security groups to associate with this interface VPC endpoint. |
| <code><a href="#@alma-cdk/aws-interface-endpoints.SessionManagerEndpointProps.property.subnets">subnets</a></code> | <code>aws-cdk-lib.aws_ec2.SubnetSelection</code> | To which subnets the endpoints are assigned. |

---

##### `services`<sup>Required</sup> <a name="services" id="@alma-cdk/aws-interface-endpoints.SessionManagerEndpointProps.property.services"></a>

```typescript
public readonly services: InterfaceVpcEndpointAwsService[];
```

- *Type:* aws-cdk-lib.aws_ec2.InterfaceVpcEndpointAwsService[]

---

##### `vpc`<sup>Required</sup> <a name="vpc" id="@alma-cdk/aws-interface-endpoints.SessionManagerEndpointProps.property.vpc"></a>

```typescript
public readonly vpc: IVpc;
```

- *Type:* aws-cdk-lib.aws_ec2.IVpc

To which VPC these endpoints are assigned.

---

##### `exportPrefix`<sup>Optional</sup> <a name="exportPrefix" id="@alma-cdk/aws-interface-endpoints.SessionManagerEndpointProps.property.exportPrefix"></a>

```typescript
public readonly exportPrefix: string;
```

- *Type:* string
- *Default:* 'SessionManagerEndpoints'

Prefix used to identity CloudFormation cross-stack exports.

---

##### `open`<sup>Optional</sup> <a name="open" id="@alma-cdk/aws-interface-endpoints.SessionManagerEndpointProps.property.open"></a>

```typescript
public readonly open: boolean;
```

- *Type:* boolean
- *Default:* true

Whether to automatically allow VPC traffic to the endpoint.

If enabled, all traffic to the endpoint from within the VPC will be automatically allowed. This is done based on the VPC's CIDR range.

---

##### `securityGroups`<sup>Optional</sup> <a name="securityGroups" id="@alma-cdk/aws-interface-endpoints.SessionManagerEndpointProps.property.securityGroups"></a>

```typescript
public readonly securityGroups: ISecurityGroup[];
```

- *Type:* aws-cdk-lib.aws_ec2.ISecurityGroup[]
- *Default:* a new security group is created

The security groups to associate with this interface VPC endpoint.

---

##### `subnets`<sup>Optional</sup> <a name="subnets" id="@alma-cdk/aws-interface-endpoints.SessionManagerEndpointProps.property.subnets"></a>

```typescript
public readonly subnets: SubnetSelection;
```

- *Type:* aws-cdk-lib.aws_ec2.SubnetSelection
- *Default:* { subnetType: ec2.SubnetType.PRIVATE_ISOLATED }

To which subnets the endpoints are assigned.

---


## Protocols <a name="Protocols" id="Protocols"></a>

### IAwsInterfaceEndpoints <a name="IAwsInterfaceEndpoints" id="@alma-cdk/aws-interface-endpoints.IAwsInterfaceEndpoints"></a>

- *Implemented By:* <a href="#@alma-cdk/aws-interface-endpoints.AwsInterfaceEndpoints">AwsInterfaceEndpoints</a>, <a href="#@alma-cdk/aws-interface-endpoints.IAwsInterfaceEndpoints">IAwsInterfaceEndpoints</a>

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#@alma-cdk/aws-interface-endpoints.IAwsInterfaceEndpoints.allowDefaultPromFrom">allowDefaultPromFrom</a></code> | *No description.* |

---

##### `allowDefaultPromFrom` <a name="allowDefaultPromFrom" id="@alma-cdk/aws-interface-endpoints.IAwsInterfaceEndpoints.allowDefaultPromFrom"></a>

```typescript
public allowDefaultPromFrom(connectable: IConnectable): void
```

###### `connectable`<sup>Required</sup> <a name="connectable" id="@alma-cdk/aws-interface-endpoints.IAwsInterfaceEndpoints.allowDefaultPromFrom.parameter.connectable"></a>

- *Type:* aws-cdk-lib.aws_ec2.IConnectable

---


