from typing import Any, Dict, List, Type, TypeVar

import attr

T = TypeVar("T", bound="GetDatabaseTableGridViewFieldAggregationResponse200ValueType3")


@attr.s(auto_attribs=True)
class GetDatabaseTableGridViewFieldAggregationResponse200ValueType3:
    """The aggregation result for the specified field."""

    additional_properties: Dict[str, Any] = attr.ib(init=False, factory=dict)

    def to_dict(self) -> Dict[str, Any]:
        field_dict: Dict[str, Any] = {}
        field_dict.update(self.additional_properties)
        field_dict.update({})

        return field_dict

    @classmethod
    def from_dict(cls: Type[T], src_dict: Dict[str, Any]) -> T:
        d = src_dict.copy()
        get_database_table_grid_view_field_aggregation_response_200_value_type_3 = cls()

        get_database_table_grid_view_field_aggregation_response_200_value_type_3.additional_properties = d
        return get_database_table_grid_view_field_aggregation_response_200_value_type_3

    @property
    def additional_keys(self) -> List[str]:
        return list(self.additional_properties.keys())

    def __getitem__(self, key: str) -> Any:
        return self.additional_properties[key]

    def __setitem__(self, key: str, value: Any) -> None:
        self.additional_properties[key] = value

    def __delitem__(self, key: str) -> None:
        del self.additional_properties[key]

    def __contains__(self, key: str) -> bool:
        return key in self.additional_properties
