# coding: utf-8

"""
    Lidarr

    Lidarr API docs  # noqa: E501

    The version of the OpenAPI document: 1.0.0
    Generated by: https://openapi-generator.tech
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from typing import Optional
from pydantic import BaseModel
from lidarr.models.media_info_resource import MediaInfoResource
from lidarr.models.parsed_track_info import ParsedTrackInfo
from lidarr.models.quality_model import QualityModel

class TrackFileResource(BaseModel):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """
    id: Optional[int]
    artist_id: Optional[int]
    album_id: Optional[int]
    path: Optional[str]
    size: Optional[int]
    date_added: Optional[datetime]
    scene_name: Optional[str]
    release_group: Optional[str]
    quality: Optional[QualityModel]
    quality_weight: Optional[int]
    media_info: Optional[MediaInfoResource]
    quality_cutoff_not_met: Optional[bool]
    audio_tags: Optional[ParsedTrackInfo]
    __properties = ["id", "artistId", "albumId", "path", "size", "dateAdded", "sceneName", "releaseGroup", "quality", "qualityWeight", "mediaInfo", "qualityCutoffNotMet", "audioTags"]

    class Config:
        allow_population_by_field_name = True
        validate_assignment = True
        alias_generator = lambda x: x.split("_")[0] + "".join(word.capitalize() for word in x.split("_")[1:])

    def __getitem__(self, item):
        return getattr(self, item)

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> TrackFileResource:
        """Create an instance of TrackFileResource from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of quality
        if self.quality:
            _dict['quality'] = self.quality.to_dict()
        # override the default output from pydantic by calling `to_dict()` of media_info
        if self.media_info:
            _dict['mediaInfo'] = self.media_info.to_dict()
        # override the default output from pydantic by calling `to_dict()` of audio_tags
        if self.audio_tags:
            _dict['audioTags'] = self.audio_tags.to_dict()
        # set to None if path (nullable) is None
        if self.path is None:
            _dict['path'] = None

        # set to None if scene_name (nullable) is None
        if self.scene_name is None:
            _dict['sceneName'] = None

        # set to None if release_group (nullable) is None
        if self.release_group is None:
            _dict['releaseGroup'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> TrackFileResource:
        """Create an instance of TrackFileResource from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return TrackFileResource.parse_obj(obj)

        _obj = TrackFileResource.parse_obj({
            "id": obj.get("id"),
            "artist_id": obj.get("artistId"),
            "album_id": obj.get("albumId"),
            "path": obj.get("path"),
            "size": obj.get("size"),
            "date_added": obj.get("dateAdded"),
            "scene_name": obj.get("sceneName"),
            "release_group": obj.get("releaseGroup"),
            "quality": QualityModel.from_dict(obj.get("quality")) if obj.get("quality") is not None else None,
            "quality_weight": obj.get("qualityWeight"),
            "media_info": MediaInfoResource.from_dict(obj.get("mediaInfo")) if obj.get("mediaInfo") is not None else None,
            "quality_cutoff_not_met": obj.get("qualityCutoffNotMet"),
            "audio_tags": ParsedTrackInfo.from_dict(obj.get("audioTags")) if obj.get("audioTags") is not None else None
        })
        return _obj

