Chainer Examples
================

This page contains a list of example codes written with Chainer.
More examples can be found in [Awesome Chainer](https://github.com/chainer-community/awesome-chainer) maintained by the community.

**It should be noted that examples marked with :zzz: have not been tested with current version of Chainer and whether it can work with current version of Chainer or not is not guaranteed.**

### <a name="natual-language-processing"></a> Natural Language Processing

* [Recurrent Net Language Model](https://github.com/chainer/chainer/tree/master/examples/ptb)
* [Recursive Nets for Sentiment Analysis](https://github.com/chainer/chainer/tree/master/examples/sentiment)
* [Word2Vec - WordEmbedding](https://github.com/chainer/chainer/tree/master/examples/word2vec)
* [Sequence-to-sequnce Learning for Machine Translation](https://github.com/chainer/chainer/tree/master/examples/seq2seq)
* [Text Classification](https://github.com/chainer/chainer/tree/master/examples/text_classification)
* [POS-tagging](https://github.com/chainer/chainer/tree/master/examples/pos)

### <a name="image-classification"></a> Image Classification

* [Multi-Layer Perceptron for MNIST Classification](https://github.com/chainer/chainer/tree/master/examples/mnist)
* [Convolutional neural networks for CIFAR-10 and CIFAR-100 Classification](https://github.com/chainer/chainer/tree/master/examples/cifar)
* [ImageNet: Large Scale ConvNets](https://github.com/chainer/chainer/tree/master/examples/imagenet)
* [Evaluate a Caffe reference model](https://github.com/chainer/chainer/tree/master/examples/modelzoo)

### <a name="object-detection"></a> Object Detection

* [ChainerCV example: Faster R-CNN](https://github.com/chainer/chainercv/tree/master/examples/faster_rcnn)
* [ChainerCV example: Single Shot Multibox Detector (SSD)](https://github.com/chainer/chainercv/tree/master/examples/ssd)

### <a name="semantic-segmentation"></a> Semantic Segmentation

* [ChainerCV example: SegNet](https://github.com/chainer/chainercv/tree/master/examples/segnet)

### <a name="generative-models"></a> Generative Models

* [Variational AutoEncoder](https://github.com/chainer/chainer/tree/master/examples/vae)
* [DCGAN](https://github.com/chainer/chainer/tree/master/examples/dcgan)
* [Image Captioning](https://github.com/chainer/chainer/tree/master/examples/image_captioning)
* [pfnet-research example: Chainer-GAN-lib](https://github.com/pfnet-research/chainer-gan-lib)
* [:zzz: pfnet-research example: Pix2Pix](https://github.com/pfnet-research/chainer-pix2pix)

### <a name="graph-cnn"></a> Graph Convolutional Network

* [:zzz: pfnet-research example: Chainer Graph CNN](https://github.com/pfnet-research/chainer-graph-cnn)

### <a name="reinforcement-learning"></a> Reinforcement Learning

* [DQN and DoubleDQN on discrete-action tasks](https://github.com/chainer/chainer/tree/master/examples/reinforcement_learning)
* [DDPG on continuous-action tasks](https://github.com/chainer/chainer/tree/master/examples/reinforcement_learning)
* [ChainerRL examples: more examples for OpenAI Gym and Arcade Learning environments](https://github.com/chainer/chainerrl/tree/master/examples)
