# AUTOGENERATED! DO NOT EDIT! File to edit: 02_Projects.ipynb (unless otherwise specified).

__all__ = ['Project']

# Cell
import sidis
import mif
import quartustcl
import numpy as np
import os
from .devices import *
from .scripting import *
from typing import Optional, Tuple, Dict, Callable, Union

# Cell
class Project:
    def __init__(self,
                projname,
                projdir='./',
                chip=DE10,
                templatefile=None,
                **kwargs
                ):
        self.__dict__.update(locals())
        self.cwd=os.getcwd()
        os.chdir(self.projdir)
        self.q=quartustcl.QuartusTcl()
        try:
            self.get_fpgas()
        except:
            print('No FPGAs found. Try connecting them and run <your project>.get_fpgas().')
            pass
        if templatefile:
            self.template=sidis.Template(templatefile,**kwargs)

    def get_fpgas(self,parse=True):
        "Use `GetPorts` and `FindInsts` to return all FPGA and memory info."
        device_dict=get_fpgas(q=self.q,parse=parse)
        self.hw=list(device_dict.keys())
        self.dev=list(device_dict.values())

    def get_insts(self,N_levels=2):
        if self.hw is None:
            self.get_fpgas()
        return get_insts(q=self.q,hwnames=self.hw,devnames=self.dev,N_levels=N_levels)

    def begin(self,hw=None,dev=None):
        if hw is None:
            hw=self.hw[0]
        if dev is None:
            dev=self.dev[0]
        begin_mem(q=self.q,hw=hw,dev=dev)

    def end(self):
        end_mem(q=self.q)

    def read(self,
             inst=0,
             hw=None,
             dev=None,
             begin=True,
             end=True,
             fname=None,
             delete_mif=True):
        if hw is None:
            hw=self.hw[0]
        if dev is None:
            dev=self.dev[0]
        data = np.array(read(q=self.q,inst=inst,hw=hw,dev=dev,begin=begin,end=end,
                               fname=fname,delete_mif=delete_mif))
        if data.shape[1]==1:
            data=data[0]
        return data

    def write(self,
              inst=0,
              data=1,
              hw=None,
              dev=None,
              bits=None,
              begin=True,
              end=True,
              fname=None,
              delete_mif=True):
        if hw is None:
            hw=self.hw[0]
        if dev is None:
            dev=self.dev[0]
        write(q=self.q,inst=inst,data=data,bits=bits,
              hw=hw,dev=dev,begin=begin,end=end,fname=fname,delete_mif=delete_mif)

    def read_write(self,
                  args=[[0,'w',1,1],[0,'r']],
                  hw=None,
                  dev=None,
                  reps=1,
                  begin=True,
                  end=True):

        if hw is None:
            hw=self.hw[0]
        if dev is None:
            dev=self.dev[0]
        return read_write(q=self.q,args=args,hw=hw,dev=dev,reps=reps,begin=begin,end=end)

    def read_all(self,
             inst=0,
             begin=True,
             end=True,
             fname=None,
             delete_mif=True):
        data=[]
        for hw,dev in zip(self.hw,self.dev):
            data+=[self.read(inst=inst,hw=hw,dev=dev,begin=begin,end=end,fname=fname,delete_mif=delete_mif)]
        data=np.array(data)
        if data.shape[0]==1:
            data=data[0]
        return data

    def write_all(self,
              inst=0,
              data=1,
              bits=None,
              begin=True,
              end=True,
              fname=None,
              delete_mif=True):
        for hw,dev in zip(self.hw,self.dev):
            write(q=self.q,inst=inst,data=data,bits=bits,
                  hw=hw,dev=dev,begin=begin,end=end,fname=fname,delete_mif=delete_mif)

    def read_write_all(self,
                 args=[[0,'w',1,1],[0,'r']],
                 reps=1,
                 begin=True,
                 end=True):
        return read_write_all(q=self.q,args=args,fpgas=list(zip(self.hw,self.dev)),reps=reps,begin=begin,end=end)


    def program(self,fpga=0,path='output_files',fname=None):
        "`Program` a single FPGA with index `fpga`."
        if self.hw is None:
            self.get_fpgas()
        filename=fname or self.projname+'.cdf'
        filename=path+'\\'+filename
        hdwname='\"'+str(self.hw[fpga])+'\"'
        os.system(r'quartus_pgm -c {0} {1}'.format(hdwname,filename))

    def program_all(self,path='output_files',fname=None):
        "`Program` all connected FPGAs."
        if self.hw is None:
            self.get_fpgas()
        for i in range(len(self.hw)):
            self.program(fpga=i,path='output_files',fname=None)

    def archive(self,name=None):
        "`Archive` the current project."
        name=name or self.projname+'-'+str(date.today())
        archive_proj(self.projname,name)

    def compile(self):
        compile_proj(self.projname)

    def annotate(self,routing=True,logic=True):
        if self.qsf is None:
            with open(self.projname+'.qsf','r') as f:
                self.original_qsf=f.readlines()

        back_annotate(projectname=self.projname,routing=routing,logic=logic)

    def de_annotate(self):
        with open(self.projname+'.qsf','r') as f:
            f.writelines(self.original_qsf)

    def write_qsf(self,txt,style='w'):
        write_qsf(txt=txt,style=style,projectname=self.projname)

    def set_loc(self,x,y,n,name=None,style='a'):
        txt=self.chip.SLA(x=x,y=y,n=n,name=name)
        self.write_qsf(txt=txt,style=style)

    def analyze_timing(self,
           _from = '[get_clocks {MyClock}]',
           _to = '[get_cells {MyCell}]',
           detail='summary', #or 'full_path'
           filename='timing.txt',
           npaths = 1
          ):
        return timing_analyzer(projectname=self.projname,_from=_from,_to=_to,detail=detail,
                        filename=filename,npaths=npaths)

