# Generated by Django 3.2.13 on 2023-02-01 14:55

import django.core.validators
import random
import string
from django.db import migrations, models


def generate_unique_external_ids(apps, schema_editor):
    participant_model = apps.get_model('ddm', 'participant')
    for p in participant_model.objects.all():
        p.external_id = ''.join(random.choices(string.ascii_letters + string.digits, k=24))
        p.save()


class Migration(migrations.Migration):

    dependencies = [
        ('ddm', '0032_auto_20230130_1733'),
    ]

    operations = [
        migrations.AddField(
            model_name='participant',
            name='external_id',
            field=models.CharField(default='rSnmWUWmKXhGwGrFEqVeM9c2', max_length=24, null=True, validators=[django.core.validators.MinLengthValidator(24)]),
        ),
        migrations.RunPython(generate_unique_external_ids),
        migrations.AlterField(
            model_name='participant',
            name='external_id',
            field=models.CharField(max_length=24, unique=True,
                                   validators=[django.core.validators.MinLengthValidator(24)]),
        ),
    ]
