"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.AccountLinking = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const constructs_1 = require("constructs");
const ask_custom_resource_1 = require("../ask/ask-custom-resource");
/**
 * Represents an Account Linking resource for an Alexa Skill.
 */
class AccountLinking extends constructs_1.Construct {
    /**
     * Creates an instance of the Account Linking resource.
     * @param scope - The construct scope.
     * @param id - The construct ID.
     * @param props - The Account Linking properties.
     */
    constructor(scope, id, props) {
        super(scope, id);
        this.resource = new ask_custom_resource_1.AskCustomResource(this, 'Default', {
            authenticationConfiguration: props.authenticationConfiguration,
            authenticationConfigurationSecret: props.authenticationConfigurationSecret,
            authenticationConfigurationParameter: props.authenticationConfigurationParameter,
            onUpdate: {
                action: 'updateAccountLinkingInfoV1',
                parameters: [
                    props.skill.skillId,
                    props.skill.skillStage,
                    {
                        accountLinkingRequest: {
                            ...props.request,
                            type: props.request.authenticationFlowType,
                            authenticationFlowType: undefined,
                        },
                    },
                ],
            },
            onDelete: {
                action: 'deleteAccountLinkingInfoV1',
                parameters: [props.skill.skillId, props.skill.skillStage],
            },
        });
        this.resource.node.addDependency(props.skill);
    }
}
exports.AccountLinking = AccountLinking;
_a = JSII_RTTI_SYMBOL_1;
AccountLinking[_a] = { fqn: "cdk-skill-management.AccountLinking", version: "1.0.26" };
//# sourceMappingURL=data:application/json;base64,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