"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.AskCustomResource = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const constructs_1 = require("constructs");
const path = require("path");
const aws_iam_1 = require("aws-cdk-lib/aws-iam");
/**
 * A custom CloudFormation resource for Alexa Skill Kit SDK calls.
 */
class AskCustomResource extends constructs_1.Construct {
    /**
     * Creates an instance of the Ask Custom Resource.
     * @param scope - The construct scope.
     * @param id - The construct ID.
     * @param props - The Ask Custom Resource properties.
     */
    constructor(scope, id, props) {
        super(scope, id);
        const authPropsCount = [
            props.authenticationConfiguration,
            props.authenticationConfigurationParameter,
            props.authenticationConfigurationSecret,
        ].filter(it => !!it).length;
        if (authPropsCount !== 1) {
            throw new Error('Exactly one authentication configuration needs to be provided!');
        }
        const codeDir = path.extname(__filename) === '.ts'
            ? path.join(__dirname, '..', '..', 'dist', 'src', 'handlers', 'ask-custom-resource')
            : path.join(__dirname, '..', '..', 'src', 'handlers', 'ask-custom-resource');
        this.provider = aws_cdk_lib_1.CustomResourceProvider.getOrCreateProvider(this, 'Custom::ASK', {
            codeDirectory: codeDir,
            runtime: aws_cdk_lib_1.CustomResourceProviderRuntime.NODEJS_18_X,
        });
        this.providerRole = aws_iam_1.Role.fromRoleArn(this, 'ProviderRole', this.provider.roleArn);
        let grant;
        if (props.authenticationConfigurationSecret) {
            grant = props.authenticationConfigurationSecret.grantRead(this.providerRole);
        }
        if (props.authenticationConfigurationParameter) {
            grant = props.authenticationConfigurationParameter.grantRead(this.providerRole);
        }
        this.customResource = new aws_cdk_lib_1.CustomResource(this, 'Resource', {
            resourceType: 'Custom::ASK',
            serviceToken: this.provider.serviceToken,
            removalPolicy: props.removalPolicy,
            properties: {
                authenticationConfiguration: props.authenticationConfiguration
                    ? this.encodeJson(props.authenticationConfiguration)
                    : undefined,
                authenticationConfigurationParameter: props.authenticationConfigurationParameter?.parameterName,
                authenticationConfigurationSecret: props.authenticationConfigurationSecret?.secretArn,
                create: props.onCreate ? this.encodeJson(props.onCreate) : undefined,
                update: props.onUpdate ? this.encodeJson(props.onUpdate) : undefined,
                delete: props.onDelete ? this.encodeJson(props.onDelete) : undefined,
            },
        });
        if (grant) {
            this.customResource.node.addDependency(grant);
        }
    }
    /**
     * Gets the response field from the custom resource.
     * @param dataPath - The data path to retrieve from the response.
     * @returns The value of the response field.
     */
    getResponseField(dataPath) {
        return this.customResource.getAttString(dataPath);
    }
    encodeJson(obj) {
        return aws_cdk_lib_1.Lazy.uncachedString({ produce: () => aws_cdk_lib_1.Stack.of(this).toJsonString(obj) });
    }
}
exports.AskCustomResource = AskCustomResource;
_a = JSII_RTTI_SYMBOL_1;
AskCustomResource[_a] = { fqn: "cdk-skill-management.AskCustomResource", version: "1.0.26" };
//# sourceMappingURL=data:application/json;base64,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