import { Duration, RemovalPolicy } from 'aws-cdk-lib';
import { Construct } from 'constructs';
import { AskSdkCall } from './ask-sdk-call';
import { SkillAuthenticationProps } from '../constructs/skill-authentication-props';
/**
 * Properties for configuring an Ask Custom Resource.
 */
export interface AskCustomResourceProps extends SkillAuthenticationProps {
    /** Timeout for the custom resource. */
    readonly timeout?: Duration;
    /** Removal policy for the custom resource. */
    readonly removalPolicy?: RemovalPolicy;
    /** Action to perform on resource creation. */
    readonly onCreate?: AskSdkCall;
    /** Action to perform on resource update. */
    readonly onUpdate?: AskSdkCall;
    /** Action to perform on resource deletion. */
    readonly onDelete?: AskSdkCall;
}
/**
 * A custom CloudFormation resource for Alexa Skill Kit SDK calls.
 */
export declare class AskCustomResource extends Construct {
    private readonly provider;
    private readonly customResource;
    private readonly providerRole;
    /**
     * Creates an instance of the Ask Custom Resource.
     * @param scope - The construct scope.
     * @param id - The construct ID.
     * @param props - The Ask Custom Resource properties.
     */
    constructor(scope: Construct, id: string, props: AskCustomResourceProps);
    /**
     * Gets the response field from the custom resource.
     * @param dataPath - The data path to retrieve from the response.
     * @returns The value of the response field.
     */
    getResponseField(dataPath: string): string;
    private encodeJson;
}
