Efficient random sampling in convex polytopes relies on a 'rounding' preprocessing step, in which the polytope is rescaled so that the width is as uniform as possible across different dimensions.
PolyRound rounds polytopes on the general form:

![equation](https://latex.codecogs.com/gif.latex?P&space;:=&space;\{x&space;\in&space;\mathcal{R}^n:&space;A_{eq}x&space;=&space;b_{eq},&space;A_{ineq}x&space;\leq&space;b_{ineq}\}) with matrices ![equation](https://latex.codecogs.com/gif.latex?A_{eq}&space;\in&space;\mathcal{R}^{m,n}) and ![equation](https://latex.codecogs.com/gif.latex?A_{ineq}\in&space;\mathcal{R}^{k,n}) and vectors ![equation](https://latex.codecogs.com/gif.latex?b_{eq}&space;\in&space;\mathcal{R}^{m}) and ![equation](https://latex.codecogs.com/gif.latex?b_{ineq}\in&space;\mathcal{R}^{k}). 

This formulation often arises in Systems Biology as the flux space of a metabolic network.

As output, PolyRound produces a polytope on the form ![equation](https://latex.codecogs.com/gif.latex?P^{r}&space;:=&space;\{v&space;\in&space;\mathcal{R}^l:&space;A^{r}_{ineq}v&space;\leq&space;b^{r}_{ineq}\}) where ![equation](https://latex.codecogs.com/gif.latex?l&space;\leq&space;n) and the zero vector is a stricly interior point. For transforming points back to the original space, it also provides a matrix ![equation](https://latex.codecogs.com/gif.latex?S&space;\in&space;\mathcal{R}^{n,l}) and a vector ![equation](https://latex.codecogs.com/gif.latex?t&space;\in&space;\mathcal{R}^{n}), so that ![equation](https://latex.codecogs.com/gif.latex?x&space;=&space;Sv&space;&plus;&space;t).

Currently, PolyRound is supported for python 3.7 and 3.8.

PolyRound no longer depends on a Gurobi installation and uses optlang (https://github.com/opencobra/optlang) to delegate linear programs to GLPK in case Gurobi is not installed. However, PolyRound is more reliable with Gurobi. Free Gurobi licenses for academic use can be obtained at https://www.gurobi.com/. Once the license is installed, the easiest way to get gurobi to work in python is through Anaconda https://www.anaconda.com/. Installation of gurobi in a conda environment is done with "conda install -c gurobi gurobi".

An easy example of how to get started is presented in the jupyter notebook "example_usage".
