from .CartesianProduct import product
from .Types import SpecialGenerator


__all__ = ["pure_bruteforce_wordlist", "_pure_bruteforce_rule"]


# chars, minlength, maxlength
def _pure_bruteforce_rule(rule: str):
    """Function that creates a virtual wordlist based on rules.

    Necessary:
        - `chars=string` : All the chars that are going to be used during the cartesian product
        - `minlength=int` : Minimum length of generated words
        - `maxlength=` : maximum length of generated words

    Arguments:
        - rule: The rule the is going to be used to create the virtual wordlist

    Returns:
        - yield each word generated by the virtual wordlist
    """
    # noinspection PyTypeChecker
    rule = dict(value.split("=") for value in rule.split(","))
    rule["minlength"] = int(rule["minlength"])
    rule["maxlength"] = int(rule["maxlength"])
    for length in range(rule["minlength"], rule["maxlength"] + 1):
        for word in product(rule["chars"], length):
            yield "".join(word)


def pure_bruteforce_wordlist(rule):
    return SpecialGenerator(_pure_bruteforce_rule, rule)
