/*
 * Decompiled with CFR 0.152.
 */
package librec.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import librec.util.Maths;
import librec.util.StringMap;
import librec.util.Strings;

public class LineConfiger
extends StringMap {
    private Map<String, List<String>> params = new HashMap<String, List<String>>();
    private static final String headKey = "main.paramater";

    public LineConfiger(String setup) {
        this(setup.split("[,\t ]"));
    }

    public LineConfiger(String[] parameters) {
        int i = 0;
        String head = parameters[i];
        if (!head.startsWith("-") && !head.startsWith("--")) {
            this.params.put(headKey, Arrays.asList(head));
            ++i;
        }
        ArrayList<String> vals = null;
        while (i < parameters.length) {
            boolean isWithDash;
            boolean isString = !Maths.isNumeric(parameters[i]);
            boolean bl = isWithDash = parameters[i].startsWith("-") || parameters[i].startsWith("--");
            if (isWithDash && isString) {
                vals = new ArrayList<String>();
                this.params.put(parameters[i], vals);
            } else {
                vals.add(parameters[i]);
            }
            ++i;
        }
    }

    public List<String> getOptions(String key) {
        return this.params.containsKey(key) ? this.params.get(key) : null;
    }

    public String getMainParam() {
        return this.getString(headKey);
    }

    public boolean isMainOn() {
        return Strings.isOn(this.getMainParam());
    }

    @Override
    public String getString(String key) {
        List<String> options = this.getOptions(key);
        if (options != null && options.size() > 0) {
            return options.get(0);
        }
        return null;
    }

    @Override
    public boolean contains(String key) {
        return this.params.containsKey(key);
    }
}

