/*
 * Decompiled with CFR 0.152.
 */
package librec.util;

import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import librec.util.FileIO;
import librec.util.LineConfiger;
import librec.util.StringMap;
import librec.util.Systems;

public class FileConfiger
extends StringMap {
    private Properties p = new Properties();

    public FileConfiger(String conf) throws Exception {
        this.p.load(new FileInputStream(FileIO.getResource(conf)));
    }

    public LineConfiger getParamOptions(String key) {
        String lineOptions = this.getString(key);
        return lineOptions == null ? null : new LineConfiger(lineOptions);
    }

    @Override
    public String getString(String key) {
        String str = this.p.getProperty(key);
        return str == null ? str : str.trim();
    }

    public void setString(String key, String val) {
        this.p.setProperty(key, val);
    }

    public String getPath(String key) {
        String path = this.getString(key);
        if (path != null) {
            return path;
        }
        switch (Systems.getOs()) {
            case Windows: {
                return this.getString(String.valueOf(key) + ".wins");
            }
        }
        return this.getString(String.valueOf(key) + ".lins");
    }

    public List<Float> getRange(String key) {
        String delim = "[, \t]";
        String str = this.getString(key);
        StringTokenizer st = new StringTokenizer(str, delim);
        if (st.countTokens() > 1) {
            return this.getMultiValues(str, delim);
        }
        if (str.contains("..")) {
            return this.getPlusValues(str);
        }
        if (str.contains("**")) {
            return this.getTimesValues(str);
        }
        ArrayList<Float> res = new ArrayList<Float>();
        res.add(Float.valueOf(this.getFloat(key)));
        return res;
    }

    /*
     * Unable to fully structure code
     */
    private List<Float> getPlusValues(String str) {
        block4: {
            vals = this.getMultiValues(str, "(\\.\\.)");
            if (vals.size() < 3) {
                return vals;
            }
            min = vals.get(0).floatValue();
            step = vals.get(1).floatValue();
            max = vals.get(2).floatValue();
            vals.clear();
            if (!(min > max)) ** GOTO lbl20
            while (min > max) {
                vals.add(Float.valueOf(min));
                min -= step;
            }
            vals.add(Float.valueOf(max));
            break block4;
lbl-1000:
            // 1 sources

            {
                vals.add(Float.valueOf(min));
                min += step;
lbl20:
                // 2 sources

                ** while (min < max)
            }
lbl21:
            // 1 sources

            if ((double)Math.abs(max + step - min) > 1.0E-6) {
                vals.add(Float.valueOf(max));
            }
        }
        return vals;
    }

    /*
     * Unable to fully structure code
     */
    private List<Float> getTimesValues(String str) {
        block4: {
            vals = this.getMultiValues(str, "(\\*\\*)");
            if (vals.size() < 3) {
                return vals;
            }
            min = vals.get(0).floatValue();
            step = vals.get(1).floatValue();
            max = vals.get(2).floatValue();
            vals.clear();
            if (!(min > max)) ** GOTO lbl20
            while (min > max) {
                vals.add(Float.valueOf(min));
                min /= step;
            }
            vals.add(Float.valueOf(max));
            break block4;
lbl-1000:
            // 1 sources

            {
                vals.add(Float.valueOf(min));
                min *= step;
lbl20:
                // 2 sources

                ** while (min < max)
            }
lbl21:
            // 1 sources

            if ((double)Math.abs(max + step - min) > 1.0E-6) {
                vals.add(Float.valueOf(max));
            }
        }
        return vals;
    }

    public List<Float> getMultiValues(String val, String reg) {
        ArrayList<Float> values = new ArrayList<Float>();
        if (val != null) {
            String[] data = val.split(reg);
            int i = 0;
            while (i < data.length) {
                values.add(new Float(data[i]));
                ++i;
            }
        }
        return values;
    }

    @Override
    public boolean contains(String key) {
        return this.p.containsKey(key);
    }
}

