/*
 * Decompiled with CFR 0.152.
 */
package librec.util;

import java.io.FileInputStream;
import java.util.Date;
import java.util.Properties;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.Multipart;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import librec.util.Logs;

public class EMailer {
    protected String from;
    protected String to;
    protected String cc;
    protected String bcc;
    protected String subject;
    protected String text;
    protected String attachment;
    protected Properties props = new Properties();

    protected void config(String filename) throws Exception {
        this.props.load(new FileInputStream(filename));
    }

    public void send() throws Exception {
        if (this.text == null) {
            this.text = this.props.getProperty("mail.text");
        }
        if (this.attachment == null) {
            this.attachment = this.props.getProperty("mail.attachment");
        }
        this.send(this.text, this.attachment);
    }

    public void config163() {
        this.props.setProperty("mail.transport.protocol", "smtp");
        this.props.setProperty("mail.smtp.host", "smtp.163.com");
        this.props.setProperty("mail.smtp.port", "25");
        this.props.setProperty("mail.smtp.auth", "true");
    }

    public void send(String text) throws Exception {
        this.send(text, null);
    }

    public void send(String text, String attachment) throws Exception {
        Session session = Session.getInstance((Properties)this.props, (Authenticator)new Authenticator(){

            protected PasswordAuthentication getPasswordAuthentication() {
                return new PasswordAuthentication(EMailer.this.props.getProperty("mail.smtp.user"), EMailer.this.props.getProperty("mail.smtp.password"));
            }
        });
        if (this.from == null) {
            this.from = this.props.getProperty("mail.from");
        }
        if (this.to == null) {
            this.to = this.props.getProperty("mail.to");
        }
        if (this.cc == null) {
            this.cc = this.props.getProperty("mail.cc");
        }
        if (this.bcc == null) {
            this.bcc = this.props.getProperty("mail.bcc");
        }
        if (this.subject == null) {
            this.subject = this.props.getProperty("mail.subject");
        }
        MimeMessage msg = new MimeMessage(session);
        msg.setFrom((Address)new InternetAddress(this.from));
        msg.setRecipient(Message.RecipientType.TO, (Address)new InternetAddress(this.to));
        if (this.cc != null) {
            msg.setRecipient(Message.RecipientType.CC, (Address)new InternetAddress(this.cc));
        }
        if (this.bcc != null) {
            msg.setRecipient(Message.RecipientType.BCC, (Address)new InternetAddress(this.bcc));
        }
        msg.setSubject(this.subject);
        msg.setSentDate(new Date());
        if (attachment != null) {
            MimeBodyPart tp = new MimeBodyPart();
            tp.setText(text);
            MimeBodyPart ap = new MimeBodyPart();
            FileDataSource fds = new FileDataSource(attachment);
            ap.setDataHandler(new DataHandler((DataSource)fds));
            ap.setFileName(fds.getName());
            MimeMultipart mp = new MimeMultipart();
            mp.addBodyPart((BodyPart)tp);
            mp.addBodyPart((BodyPart)ap);
            msg.setContent((Multipart)mp);
        } else {
            msg.setText(text);
        }
        Transport.send((Message)msg);
        Logs.debug("Have sent an email notification to {}. ", (Object)this.to);
    }

    public Properties getProps() {
        return this.props;
    }
}

