/*
 * Decompiled with CFR 0.152.
 */
package librec.ranking;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import librec.data.DenseMatrix;
import librec.data.DenseVector;
import librec.data.SparseMatrix;
import librec.data.SparseVector;
import librec.data.VectorEntry;
import librec.intf.SocialRecommender;
import librec.util.Randoms;
import librec.util.Strings;

public class SBPR
extends SocialRecommender {
    private Map<Integer, List<Integer>> SP;

    public SBPR(SparseMatrix trainMatrix, SparseMatrix testMatrix, int fold) {
        super(trainMatrix, testMatrix, fold);
        isRankingPred = true;
        this.initByNorm = false;
    }

    @Override
    protected void initModel() throws Exception {
        super.initModel();
        this.itemBias = new DenseVector(numItems);
        this.itemBias.init();
        this.userItemsCache = this.trainMatrix.rowColumnsCache(cacheSpec);
        this.SP = new HashMap<Integer, List<Integer>>();
        int u = 0;
        int um = this.trainMatrix.numRows();
        while (u < um) {
            List uRatedItems = (List)this.userItemsCache.get(u);
            if (uRatedItems.size() != 0) {
                List<Integer> trustedUsers = socialMatrix.getColumns(u);
                ArrayList<Integer> items = new ArrayList<Integer>();
                for (int v : trustedUsers) {
                    if (v >= um) continue;
                    List vRatedItems = (List)this.userItemsCache.get(v);
                    Iterator iterator = vRatedItems.iterator();
                    while (iterator.hasNext()) {
                        int j = (Integer)iterator.next();
                        if (uRatedItems.contains(j) || items.contains(j)) continue;
                        items.add(j);
                    }
                }
                this.SP.put(u, items);
            }
            ++u;
        }
    }

    @Override
    protected void postModel() throws Exception {
        this.SP = null;
    }

    @Override
    protected void buildModel() throws Exception {
        int iter = 1;
        while (iter <= numIters) {
            this.loss = 0.0;
            int s = 0;
            int smax = numUsers * 100;
            while (s < smax) {
                int u = 0;
                int i = 0;
                int j = 0;
                List ratedItems = null;
                while ((ratedItems = (List)this.userItemsCache.get(u = Randoms.uniform(this.trainMatrix.numRows()))).size() == 0) {
                }
                i = (Integer)Randoms.random(ratedItems);
                double xui = this.predict(u, i);
                List<Integer> SPu = this.SP.get(u);
                while (ratedItems.contains(j = Randoms.uniform(numItems)) || SPu.contains(j)) {
                }
                double xuj = this.predict(u, j);
                if (SPu.size() > 0) {
                    int k = Randoms.random(SPu);
                    double xuk = this.predict(u, k);
                    SparseVector Tu = socialMatrix.row(u);
                    double suk = 0.0;
                    for (VectorEntry ve : Tu) {
                        double rvk;
                        int v = ve.index();
                        if (v >= this.trainMatrix.numRows() || !((rvk = this.trainMatrix.get(v, k)) > 0.0)) continue;
                        suk += 1.0;
                    }
                    double xuik = (xui - xuk) / (1.0 + suk);
                    double xukj = xuk - xuj;
                    double vals = -Math.log(this.g(xuik)) - Math.log(this.g(xukj));
                    this.loss += vals;
                    double cik = this.g(-xuik);
                    double ckj = this.g(-xukj);
                    double bi = this.itemBias.get(i);
                    this.itemBias.add(i, this.lRate * (cik / (1.0 + suk) - (double)regB * bi));
                    this.loss += (double)regB * bi * bi;
                    double bk = this.itemBias.get(k);
                    this.itemBias.add(k, this.lRate * (-cik / (1.0 + suk) + ckj - (double)regB * bk));
                    this.loss += (double)regB * bk * bk;
                    double bj = this.itemBias.get(j);
                    this.itemBias.add(j, this.lRate * (-ckj - (double)regB * bj));
                    this.loss += (double)regB * bj * bj;
                    int f = 0;
                    while (f < numFactors) {
                        double puf = this.P.get(u, f);
                        double qif = this.Q.get(i, f);
                        double qkf = this.Q.get(k, f);
                        double qjf = this.Q.get(j, f);
                        double delta_puf = cik * (qif - qkf) / (1.0 + suk) + ckj * (qkf - qjf);
                        this.P.add(u, f, this.lRate * (delta_puf - (double)regU * puf));
                        this.Q.add(i, f, this.lRate * (cik * puf / (1.0 + suk) - (double)regI * qif));
                        double delta_qkf = cik * (-puf / (1.0 + suk)) + ckj * puf;
                        this.Q.add(k, f, this.lRate * (delta_qkf - (double)regI * qkf));
                        this.Q.add(j, f, this.lRate * (ckj * -puf - (double)regI * qjf));
                        this.loss += (double)regU * puf * puf + (double)regI * qif * qif;
                        this.loss += (double)regI * qkf * qkf + (double)regI * qjf * qjf;
                        ++f;
                    }
                } else {
                    double xuij = xui - xuj;
                    double vals = -Math.log(this.g(xuij));
                    this.loss += vals;
                    double cij = this.g(-xuij);
                    double bi = this.itemBias.get(i);
                    this.itemBias.add(i, this.lRate * (cij - (double)regB * bi));
                    this.loss += (double)regB * bi * bi;
                    double bj = this.itemBias.get(j);
                    this.itemBias.add(j, this.lRate * (-cij - (double)regB * bj));
                    this.loss += (double)regB * bj * bj;
                    int f = 0;
                    while (f < numFactors) {
                        double puf = this.P.get(u, f);
                        double qif = this.Q.get(i, f);
                        double qjf = this.Q.get(j, f);
                        this.P.add(u, f, this.lRate * (cij * (qif - qjf) - (double)regU * puf));
                        this.Q.add(i, f, this.lRate * (cij * puf - (double)regI * qif));
                        this.Q.add(j, f, this.lRate * (cij * -puf - (double)regI * qjf));
                        this.loss += (double)regU * puf * puf + (double)regI * qif * qif + (double)regI * qjf * qjf;
                        ++f;
                    }
                }
                ++s;
            }
            if (this.isConverged(iter)) break;
            ++iter;
        }
    }

    @Override
    protected double predict(int u, int j) {
        return this.itemBias.get(j) + DenseMatrix.rowMult(this.P, u, this.Q, j);
    }

    @Override
    public String toString() {
        return Strings.toString(new Object[]{Float.valueOf(binThold), numFactors, Float.valueOf(initLRate), Float.valueOf(maxLRate), Float.valueOf(regU), Float.valueOf(regI), Float.valueOf(regB), numIters});
    }
}

