/*
 * Decompiled with CFR 0.152.
 */
package librec.ranking;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import librec.data.DenseVector;
import librec.data.SparseMatrix;
import librec.data.SparseVector;
import librec.intf.IterativeRecommender;
import librec.util.Lists;
import librec.util.Randoms;
import librec.util.Stats;
import librec.util.Strings;

public class AoBPR
extends IterativeRecommender {
    private static int loopNumber;
    private static int lamda_Item;
    private double[] var;
    private int[][] factorRanking;
    private double[] RankingPro;

    public AoBPR(SparseMatrix trainMatrix, SparseMatrix testMatrix, int fold) {
        super(trainMatrix, testMatrix, fold);
        isRankingPred = true;
        this.initByNorm = false;
    }

    @Override
    protected void initModel() throws Exception {
        super.initModel();
        lamda_Item = (int)(algoOptions.getFloat("-lambda") * (float)numItems);
        loopNumber = (int)((double)numItems * Math.log(numItems));
        this.var = new double[numFactors];
        this.factorRanking = new int[numFactors][numItems];
        this.RankingPro = new double[numItems];
        double sum = 0.0;
        int i = 0;
        while (i < numItems) {
            this.RankingPro[i] = Math.exp(-(i + 1) / lamda_Item);
            sum += this.RankingPro[i];
            ++i;
        }
        i = 0;
        while (i < numItems) {
            int n = i++;
            this.RankingPro[n] = this.RankingPro[n] / sum;
        }
    }

    @Override
    protected void buildModel() throws Exception {
        int countIter = 0;
        int iter = 1;
        while (iter <= numIters) {
            this.loss = 0.0;
            int s = 0;
            int smax = numUsers * 100;
            while (s < smax) {
                int randomJIndex;
                double[] pfc;
                int f;
                SparseVector pu;
                if (countIter % loopNumber == 0) {
                    this.updateRankingInFactor();
                    countIter = 0;
                }
                ++countIter;
                int u = 0;
                int i = 0;
                int j = 0;
                while ((pu = this.trainMatrix.row(u = Randoms.uniform(numUsers))).getCount() == 0) {
                }
                int[] is = pu.getIndex();
                i = is[Randoms.uniform(is.length)];
                do {
                    randomJIndex = 0;
                    while ((randomJIndex = Randoms.discrete(this.RankingPro)) > numItems) {
                    }
                    pfc = new double[numFactors];
                    double sumfc = 0.0;
                    int index = 0;
                    while (index < numFactors) {
                        double temp = Math.abs(this.P.get(u, index));
                        sumfc += temp * this.var[index];
                        pfc[index] = temp * this.var[index];
                        ++index;
                    }
                    index = 0;
                    while (index < numFactors) {
                        int n = index++;
                        pfc[n] = pfc[n] / sumfc;
                    }
                } while (pu.contains(j = this.P.get(u, f = Randoms.discrete(pfc)) > 0.0 ? this.factorRanking[f][randomJIndex] : this.factorRanking[f][numItems - randomJIndex - 1]));
                double xui = this.predict(u, i);
                double xuj = this.predict(u, j);
                double xuij = xui - xuj;
                double vals = -Math.log(this.g(xuij));
                this.loss += vals;
                double cmg = this.g(-xuij);
                int f2 = 0;
                while (f2 < numFactors) {
                    double puf = this.P.get(u, f2);
                    double qif = this.Q.get(i, f2);
                    double qjf = this.Q.get(j, f2);
                    this.P.add(u, f2, this.lRate * (cmg * (qif - qjf) - (double)regU * puf));
                    this.Q.add(i, f2, this.lRate * (cmg * puf - (double)regI * qif));
                    this.Q.add(j, f2, this.lRate * (cmg * -puf - (double)regI * qjf));
                    this.loss += (double)regU * puf * puf + (double)regI * qif * qif + (double)regI * qjf * qjf;
                    ++f2;
                }
                ++s;
            }
            if (this.isConverged(iter)) break;
            ++iter;
        }
    }

    public void updateRankingInFactor() {
        int factorIndex = 0;
        while (factorIndex < numFactors) {
            DenseVector factorVector = this.Q.column(factorIndex).clone();
            List<Map.Entry<Integer, Double>> sort = this.sortByDenseVectorValue(factorVector);
            double[] valueList = new double[numItems];
            int i = 0;
            while (i < numItems) {
                this.factorRanking[factorIndex][i] = sort.get(i).getKey();
                valueList[i] = sort.get(i).getValue();
                ++i;
            }
            this.var[factorIndex] = Stats.var(valueList);
            ++factorIndex;
        }
    }

    public List<Map.Entry<Integer, Double>> sortByDenseVectorValue(DenseVector vector) {
        HashMap<Integer, Double> keyValPair = new HashMap<Integer, Double>();
        int i = 0;
        int length = vector.getData().length;
        while (i < length) {
            keyValPair.put(i, vector.get(i));
            ++i;
        }
        return Lists.sortMap(keyValPair, true);
    }

    @Override
    public String toString() {
        return Strings.toString(new Object[]{Float.valueOf(binThold), numFactors, Float.valueOf(initLRate), Float.valueOf(regU), Float.valueOf(regI), numIters, lamda_Item}, ",");
    }
}

