/*
 * Decompiled with CFR 0.152.
 */
package librec.ext;

import java.util.HashMap;
import java.util.Iterator;
import librec.data.SparseMatrix;
import librec.data.SparseVector;
import librec.data.VectorEntry;
import librec.intf.Recommender;
import librec.util.Lists;

public class PD
extends Recommender {
    private float sigma;
    private double prior;

    public PD(SparseMatrix trainMatrix, SparseMatrix testMatrix, int fold) {
        super(trainMatrix, testMatrix, fold);
    }

    @Override
    protected void initModel() throws Exception {
        this.prior = 1.0 / (double)numUsers;
        this.sigma = algoOptions.getFloat("-sigma");
    }

    @Override
    protected double predict(int a, int j) {
        HashMap<Double, Double> scaleProbs = new HashMap<Double, Double>();
        SparseVector pa = this.trainMatrix.row(a);
        SparseVector qj = this.trainMatrix.column(j);
        Iterator iterator = ratingScale.iterator();
        while (iterator.hasNext()) {
            double h = (Double)iterator.next();
            double prob = 0.0;
            for (VectorEntry ve : qj) {
                int i = ve.index();
                double rij = ve.get();
                SparseVector pi = this.trainMatrix.row(i);
                double prod = 1.0;
                for (VectorEntry ae : pa) {
                    int l = ae.index();
                    double ral = ae.get();
                    double ril = pi.get(l);
                    if (!(ril > 0.0)) continue;
                    prod *= this.gaussian(ral, ril, this.sigma);
                }
                prob += this.gaussian(h, rij, this.sigma) * prod;
            }
            scaleProbs.put(h, prob *= this.prior);
        }
        return (Double)Lists.sortMap(scaleProbs, true).get(0).getKey();
    }

    @Override
    public String toString() {
        return String.valueOf(super.toString()) + "," + this.sigma;
    }
}

