/*
 * Decompiled with CFR 0.152.
 */
package happy.coding.math;

import happy.coding.io.Lists;
import happy.coding.math.Stats;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public class Sims {
    public static double cos(List<Double> a, List<Double> b) {
        if (Lists.isEmpty(a) || Lists.isEmpty(b) || a.size() != b.size()) {
            return Double.NaN;
        }
        double sum = 0.0;
        double sum_a = 0.0;
        double sum_b = 0.0;
        int i = 0;
        while (i < a.size()) {
            double ai = a.get(i);
            double bi = b.get(i);
            sum += ai * bi;
            sum_a += ai * ai;
            sum_b += bi * bi;
            ++i;
        }
        double val = Math.sqrt(sum_a) * Math.sqrt(sum_b);
        return sum / val;
    }

    public static double cpc(List<Double> u, List<Double> v, double median) {
        if (Lists.isEmpty(u) || Lists.isEmpty(v)) {
            return Double.NaN;
        }
        double sumNum = 0.0;
        double sumDen1 = 0.0;
        double sumDen2 = 0.0;
        int i = 0;
        while (i < u.size()) {
            double ui = u.get(i) - median;
            double vi = v.get(i) - median;
            sumNum += ui * vi;
            sumDen1 += Math.pow(ui, 2.0);
            sumDen2 += Math.pow(vi, 2.0);
            ++i;
        }
        return sumNum / (Math.sqrt(sumDen1) * Math.sqrt(sumDen2));
    }

    public static double msd(List<Double> u, List<Double> v) {
        double sum = 0.0;
        int i = 0;
        while (i < u.size()) {
            double ui = u.get(i);
            double vi = v.get(i);
            sum += Math.pow(ui - vi, 2.0);
            ++i;
        }
        double sim = (double)u.size() / sum;
        if (Double.isInfinite(sim)) {
            sim = 1.0;
        }
        return sim;
    }

    public static double pcc(List<? extends Number> a, List<? extends Number> b) {
        if (a == null || b == null || a.size() < 2 || b.size() < 2 || a.size() != b.size()) {
            return Double.NaN;
        }
        double mu_a = Stats.mean(a);
        double mu_b = Stats.mean(b);
        double num = 0.0;
        double den_a = 0.0;
        double den_b = 0.0;
        int i = 0;
        while (i < a.size()) {
            double ai = a.get(i).doubleValue() - mu_a;
            double bi = b.get(i).doubleValue() - mu_b;
            num += ai * bi;
            den_a += ai * ai;
            den_b += bi * bi;
            ++i;
        }
        return num / (Math.sqrt(den_a) * Math.sqrt(den_b));
    }

    public static double exJaccard(List<Double> a, List<Double> b) {
        double num = 0.0;
        double den_a = 0.0;
        double den_b = 0.0;
        int i = 0;
        while (i < a.size()) {
            double ai = a.get(i);
            double bi = b.get(i);
            num += ai * bi;
            den_a += ai * ai;
            den_b += bi * bi;
            ++i;
        }
        return num / (den_a + den_b - num);
    }

    public static double dice(List<Double> a, List<Double> b) {
        double num = 0.0;
        double den_a = 0.0;
        double den_b = 0.0;
        int i = 0;
        while (i < a.size()) {
            double ai = a.get(i);
            double bi = b.get(i);
            num += 2.0 * ai * bi;
            den_a += ai * ai;
            den_b += bi * bi;
            ++i;
        }
        return num / (den_a + den_b);
    }

    public static double jaccard(List<Integer> uItems, List<Integer> vItems) {
        int common = 0;
        int all = 0;
        HashSet<Integer> items = new HashSet<Integer>();
        items.addAll(uItems);
        items.addAll(vItems);
        all = items.size();
        common = uItems.size() + vItems.size() - all;
        return ((double)common + 0.0) / (double)all;
    }

    public static double krcc(List<Double> uItems, List<Double> vItems) {
        int common = 0;
        int all = 0;
        double sum = 0.0;
        ArrayList<Integer> temp = new ArrayList<Integer>();
        HashSet<Double> items = new HashSet<Double>();
        items.addAll(uItems);
        items.addAll(vItems);
        all = items.size();
        common = uItems.size() + vItems.size() - all;
        int i = 0;
        while (i < uItems.size()) {
            if (uItems.get(i) > 0.0 && vItems.get(i) > 0.0) {
                temp.add(i);
            }
            ++i;
        }
        int m = 0;
        while (m < temp.size()) {
            int n = m;
            while (n < temp.size()) {
                if ((uItems.get((Integer)temp.get(m)) - uItems.get((Integer)temp.get(n))) * (vItems.get((Integer)temp.get(m)) - vItems.get((Integer)temp.get(n))) < 0.0) {
                    sum += 1.0;
                }
                ++n;
            }
            ++m;
        }
        return 1.0 - 4.0 * sum / (double)common * (double)(common - 1);
    }
}

