/*
 * Decompiled with CFR 0.152.
 */
package happy.coding.io.table;

import com.google.common.base.Strings;
import happy.coding.io.table.TablePrinter;
import happy.coding.io.table.TextTableModel;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Writer;
import javax.swing.table.TableModel;

public class TextTableRenderer {
    protected String[] formats;
    protected int[] lengths;
    protected TablePrinter textTable;
    protected TableModel tableModel;
    private boolean showNulls = false;

    public TextTableRenderer(TablePrinter textTable) {
        this.textTable = textTable;
        this.tableModel = textTable.getTableModel();
    }

    public TextTableRenderer(TablePrinter textTable, boolean showNulls) {
        this.textTable = textTable;
        this.tableModel = textTable.getTableModel();
        this.showNulls = showNulls;
    }

    public void render(OutputStream os, int indent) {
        PrintStream ps = os instanceof PrintStream ? (PrintStream)os : new PrintStream(os);
        TableModel tableModel = this.textTable.getTableModel();
        String indentStr = Strings.repeat(" ", indent);
        this.resolveColumnLengths();
        String separator = this.resolveSeparator(this.lengths);
        int rowCount = tableModel.getRowCount();
        int rowCountStrSize = Integer.toString(rowCount).length();
        String indexFormat1 = "%1$-" + rowCountStrSize + "s  ";
        String indexFormat2 = "%1$" + rowCountStrSize + "s. ";
        int totLength = this.resolveFormats();
        String headerStartSep = "+" + Strings.repeat("-", totLength + tableModel.getColumnCount() * 2 - 1) + "+";
        ps.print(indentStr);
        this.indentAccordingToNumbering(ps, indexFormat1);
        ps.println(headerStartSep);
        ps.print(indentStr);
        this.indentAccordingToNumbering(ps, indexFormat1);
        int j = 0;
        while (j < tableModel.getColumnCount()) {
            ps.printf(this.formats[j], tableModel.getColumnName(j));
            ++j;
        }
        this.indentAccordingToNumbering(ps, indexFormat1);
        String headerSep = Strings.repeat("-", totLength + tableModel.getColumnCount() * 2 - 1);
        ps.print(indentStr);
        ps.print("+");
        ps.print(headerSep);
        ps.println("+");
        int i = 0;
        while (i < tableModel.getRowCount()) {
            this.addSeparatorIfNeeded(ps, separator, indexFormat1, i, indentStr);
            ps.print(indentStr);
            if (this.textTable.addRowNumbering) {
                if (!this.modelAllowsNumberingAt(i)) {
                    this.indentAccordingToNumbering(ps, indexFormat1);
                } else {
                    ps.printf(indexFormat2, i + 1);
                }
            }
            int j2 = 0;
            while (j2 < tableModel.getColumnCount()) {
                this.printValue(ps, i, j2, false);
                ++j2;
            }
            ++i;
        }
    }

    private void resolveColumnLengths() {
        this.lengths = new int[this.tableModel.getColumnCount()];
        int col = 0;
        while (col < this.tableModel.getColumnCount()) {
            int row = 0;
            while (row < this.tableModel.getRowCount()) {
                Object val = this.tableModel.getValueAt(row, col);
                String valStr = String.valueOf(val);
                if (!this.showNulls && val == null) {
                    valStr = "";
                }
                this.lengths[col] = Math.max(valStr.length(), this.lengths[col]);
                ++row;
            }
            ++col;
        }
    }

    private String resolveSeparator(int[] lengths) {
        StringBuilder sepSb = new StringBuilder();
        int j = 0;
        while (j < this.tableModel.getColumnCount()) {
            if (j == 0) {
                sepSb.append("|");
            }
            lengths[j] = Math.max(this.tableModel.getColumnName(j).length(), lengths[j]);
            sepSb.append(Strings.repeat("-", lengths[j] + 1));
            sepSb.append("|");
            ++j;
        }
        String separator = sepSb.toString();
        return separator;
    }

    private void addSeparatorIfNeeded(PrintStream ps, String separator, String indexFormat1, int i, String indentStr) {
        if (!this.textTable.separatorPolicies.isEmpty() && this.textTable.hasSeparatorAt(i) || this.tableModel instanceof TextTableModel && ((TextTableModel)this.tableModel).addSeparatorAt(i)) {
            this.indentAccordingToNumbering(ps, indexFormat1);
            ps.print(indentStr);
            ps.println(separator);
        }
    }

    protected boolean modelAllowsNumberingAt(int row) {
        if (row == 8) {
            System.out.print("");
        }
        if (this.tableModel instanceof TextTableModel) {
            TextTableModel ttm = (TextTableModel)this.tableModel;
            return ttm.allowNumberingAt(row);
        }
        return this.textTable.addRowNumbering;
    }

    protected void printValue(PrintStream ps, int row, int col, boolean empty) {
        Object val;
        int rowIndex = row;
        if (this.textTable.rowSorter != null) {
            rowIndex = this.textTable.rowSorter.convertRowIndexToModel(row);
        }
        if ((val = this.tableModel.getValueAt(rowIndex, col)) == null && !this.showNulls) {
            val = "";
        }
        Object value = empty ? "" : val;
        ps.printf(this.formats[col], value);
    }

    private int resolveFormats() {
        int totLength = 0;
        this.formats = new String[this.lengths.length];
        int i = 0;
        while (i < this.lengths.length) {
            StringBuilder sb = new StringBuilder();
            if (i == 0) {
                sb.append("|");
            }
            sb.append(" %1$-");
            sb.append(this.lengths[i]);
            sb.append("s|");
            sb.append(i + 1 == this.lengths.length ? "\n" : "");
            this.formats[i] = sb.toString();
            totLength += this.lengths[i];
            ++i;
        }
        return totLength;
    }

    private void indentAccordingToNumbering(PrintStream ps, String indexFormat1) {
        if (this.textTable.addRowNumbering) {
            ps.printf(indexFormat1, "");
        }
    }

    public void render(Writer w, int indent) {
        throw new UnsupportedOperationException();
    }
}

