/*
 * Decompiled with CFR 0.152.
 */
package carskit.main;

import carskit.alg.baseline.avg.ContextAverage;
import carskit.alg.baseline.avg.GlobalAverage;
import carskit.alg.baseline.avg.ItemAverage;
import carskit.alg.baseline.avg.ItemContextAverage;
import carskit.alg.baseline.avg.UserAverage;
import carskit.alg.baseline.avg.UserContextAverage;
import carskit.alg.baseline.avg.UserItemAverage;
import carskit.alg.baseline.cf.BPMF;
import carskit.alg.baseline.cf.BiasedMF;
import carskit.alg.baseline.cf.ItemKNN;
import carskit.alg.baseline.cf.NMF;
import carskit.alg.baseline.cf.PMF;
import carskit.alg.baseline.cf.SVDPlusPlus;
import carskit.alg.baseline.cf.SlopeOne;
import carskit.alg.baseline.cf.UserKNN;
import carskit.alg.baseline.ranking.BPR;
import carskit.alg.baseline.ranking.LRMF;
import carskit.alg.baseline.ranking.RankALS;
import carskit.alg.baseline.ranking.RankSGD;
import carskit.alg.baseline.ranking.SLIM;
import carskit.alg.cars.adaptation.dependent.FM;
import carskit.alg.cars.adaptation.dependent.dev.CAMF_C;
import carskit.alg.cars.adaptation.dependent.dev.CAMF_CI;
import carskit.alg.cars.adaptation.dependent.dev.CAMF_CU;
import carskit.alg.cars.adaptation.dependent.dev.CAMF_CUCI;
import carskit.alg.cars.adaptation.dependent.dev.CSLIM_C;
import carskit.alg.cars.adaptation.dependent.dev.CSLIM_CI;
import carskit.alg.cars.adaptation.dependent.dev.CSLIM_CU;
import carskit.alg.cars.adaptation.dependent.dev.CSLIM_CUCI;
import carskit.alg.cars.adaptation.dependent.dev.GCSLIM_CC;
import carskit.alg.cars.adaptation.dependent.sim.CAMF_ICS;
import carskit.alg.cars.adaptation.dependent.sim.CAMF_LCS;
import carskit.alg.cars.adaptation.dependent.sim.CAMF_MCS;
import carskit.alg.cars.adaptation.dependent.sim.CSLIM_ICS;
import carskit.alg.cars.adaptation.dependent.sim.CSLIM_LCS;
import carskit.alg.cars.adaptation.dependent.sim.CSLIM_MCS;
import carskit.alg.cars.adaptation.dependent.sim.GCSLIM_ICS;
import carskit.alg.cars.adaptation.dependent.sim.GCSLIM_LCS;
import carskit.alg.cars.adaptation.dependent.sim.GCSLIM_MCS;
import carskit.alg.cars.adaptation.independent.CPTF;
import carskit.alg.cars.transformation.hybridfiltering.DCR;
import carskit.alg.cars.transformation.hybridfiltering.DCW;
import carskit.alg.cars.transformation.prefiltering.ExactFiltering;
import carskit.alg.cars.transformation.prefiltering.SPF;
import carskit.alg.cars.transformation.prefiltering.splitting.ItemSplitting;
import carskit.alg.cars.transformation.prefiltering.splitting.UISplitting;
import carskit.alg.cars.transformation.prefiltering.splitting.UserSplitting;
import carskit.data.processor.DataDAO;
import carskit.data.processor.DataSplitter;
import carskit.data.processor.DataTransformer;
import carskit.data.structure.SparseMatrix;
import carskit.generic.IterativeRecommender;
import carskit.generic.Recommender;
import com.google.common.collect.Table;
import happy.coding.io.FileConfiger;
import happy.coding.io.FileIO;
import happy.coding.io.LineConfiger;
import happy.coding.io.Logs;
import happy.coding.io.Strings;
import happy.coding.math.Randoms;
import happy.coding.system.Dates;
import java.io.BufferedReader;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CARSKit {
    protected static String version = "0.3.5";
    protected static String defaultConfigFileName = "setting.conf";
    public static boolean isMeasuresOnly = false;
    protected static String WorkingFolder;
    protected static String DefaultWorkingFolder;
    protected static String WorkingPath;
    protected FileConfiger cf;
    protected List<String> configFiles;
    protected String algorithm;
    protected float binThold;
    private boolean fullStat = false;
    protected DataDAO rateDao;
    protected SparseMatrix rateMatrix;
    protected LineConfiger ratingOptions;
    protected LineConfiger outputOptions;

    public static void main(String[] args) throws Exception {
        try {
            new CARSKit().execute(args);
        }
        catch (Exception e) {
            Logs.error(e.getMessage());
            e.printStackTrace();
        }
    }

    protected void execute(String[] args) throws Exception {
        this.cmdLine(args);
        for (String config : this.configFiles) {
            this.preset(config);
            this.readData();
            this.runAlgorithm();
        }
        String filename = (this.configFiles.size() > 1 ? "multiAlgorithms" : this.algorithm) + "@" + Dates.now() + ".txt";
        String results = Recommender.workingPath + filename;
        FileIO.copyFile("results.txt", results);
    }

    protected void preset(String configFile) throws Exception {
        this.cf = new FileConfiger(configFile);
        String separator = System.getProperty("file.separator");
        Recommender.cf = this.cf;
        Recommender.resetStatics = true;
        IterativeRecommender.resetStatics = true;
        String currentRatingFile = this.cf.getPath("dataset.ratings");
        if (!FileIO.exist(currentRatingFile)) {
            Logs.error("Your rating file path is incorrect: File doesn't exist. Please double check your configuration.");
        } else {
            String currentFilePath = currentRatingFile.substring(0, currentRatingFile.lastIndexOf(separator) + 1);
            this.outputOptions = this.cf.getParamOptions("output.setup");
            if (this.outputOptions != null) {
                isMeasuresOnly = this.outputOptions.contains("--measures-only");
            }
            WorkingFolder = this.outputOptions.getString("-folder", DefaultWorkingFolder);
            WorkingPath = currentFilePath + WorkingFolder + separator;
            Logs.info("WorkingPath: " + WorkingPath);
            Recommender.workingPath = FileIO.makeDirectory(WorkingPath);
        }
        LineConfiger evalOptions = this.cf.getParamOptions("evaluation.setup");
        Randoms.seed(evalOptions.getLong("--rand-seed", System.currentTimeMillis()));
    }

    protected boolean isBinaryNumber(int number) {
        for (int copyOfInput = number; copyOfInput != 0; copyOfInput /= 10) {
            if (copyOfInput % 10 <= 1) continue;
            return false;
        }
        return true;
    }

    protected int validateDataFormat(String dataPath) throws Exception {
        int flag = 0;
        BufferedReader br = FileIO.getReader(dataPath);
        String header = br.readLine();
        String dataline = br.readLine();
        br.close();
        String[] sheader = header.split(",", -1);
        String[] sdata = dataline.split(",", -1);
        String lastColumn = sheader[sheader.length - 1].trim().toLowerCase();
        if (sheader[sheader.length - 2].trim().toLowerCase().equals("dimension") && lastColumn.equals("condition")) {
            flag = 2;
        } else {
            boolean isBinary = true;
            for (int i = 3; i < sheader.length; ++i) {
                if (sheader[i].indexOf(":") != -1 && this.isBinaryNumber(Integer.valueOf(sdata[i]))) continue;
                isBinary = false;
                break;
            }
            flag = isBinary ? 1 : 3;
        }
        return flag;
    }

    protected void readData() throws Exception {
        String OriginalRatingDataPath = this.cf.getPath("dataset.ratings");
        Logs.info("Your original rating data path: " + OriginalRatingDataPath);
        Logs.info("Current working path: " + WorkingPath);
        if (!FileIO.exist(OriginalRatingDataPath)) {
            Logs.error("Your rating file path is incorrect: File doesn't exist. Please double check your configuration.");
        }
        this.ratingOptions = this.cf.getParamOptions("ratings.setup");
        int dataTransformation = this.ratingOptions.getInt("-datatransformation");
        if (dataTransformation > 0) {
            String setup = this.cf.getString("evaluation.setup");
            LineConfiger evalOptions = new LineConfiger(setup);
            String evMethod = evalOptions.getMainParam().toLowerCase().trim();
            boolean testTransfer = false;
            String testPath = null;
            if (evMethod.equals("test-set")) {
                testTransfer = true;
                testPath = evalOptions.getString("-f");
            }
            DataTransformer transformer = new DataTransformer();
            int flag_train = this.validateDataFormat(OriginalRatingDataPath);
            int flag_test = -1;
            if (testTransfer) {
                flag_test = this.validateDataFormat(testPath);
            }
            transformer.setParameters(flag_train, OriginalRatingDataPath, flag_test, testPath, WorkingPath);
            Thread t = new Thread(transformer);
            t.start();
            t.join();
        }
        this.rateDao = new DataDAO(WorkingPath + "train.csv");
        this.binThold = this.ratingOptions.getFloat("-threshold");
        this.fullStat = this.ratingOptions.getInt("-fullstat", -1) > 0;
        this.rateDao.setFullStat(this.fullStat);
        this.rateMatrix = this.rateDao.readData(this.binThold);
        this.rateDao.printSpecs();
        Recommender.rateMatrix = this.rateMatrix;
        Recommender.rateDao = this.rateDao;
        Recommender.binThold = this.binThold;
    }

    protected void cmdLine(String[] args) throws Exception {
        if (args == null || args.length < 1) {
            if (this.configFiles == null) {
                this.configFiles = Arrays.asList(defaultConfigFileName);
            }
            return;
        }
        LineConfiger paramOptions = new LineConfiger(args);
        List<String> list = this.configFiles = paramOptions.contains("-c") ? paramOptions.getOptions("-c") : Arrays.asList(defaultConfigFileName);
        if (paramOptions.contains("-version")) {
            this.about();
            System.exit(0);
        }
        if (paramOptions.contains("-v")) {
            System.out.println("CARSKit version " + version);
            System.exit(0);
        }
    }

    protected void runAlgorithm() throws Exception {
        String setup = this.cf.getString("evaluation.setup");
        LineConfiger evalOptions = new LineConfiger(setup);
        if (isMeasuresOnly) {
            Logs.debug("With Setup: {}", (Object)setup);
        } else {
            Logs.info("With Setup: {}", (Object)setup);
        }
        Recommender algo = null;
        DataSplitter ds = new DataSplitter(this.rateMatrix);
        SparseMatrix[] data = null;
        switch (evalOptions.getMainParam().toLowerCase()) {
            case "cv": {
                this.runCrossValidation(evalOptions);
                return;
            }
            case "test-set": {
                DataDAO testDao = new DataDAO(WorkingPath + "test.csv", this.rateDao.getUserIds(), this.rateDao.getItemIds(), this.rateDao.getContextIds(), this.rateDao.getUserItemIds(), this.rateDao.getContextDimensionIds(), this.rateDao.getContextConditionIds(), this.rateDao.getURatedList(), this.rateDao.getIRatedList(), this.rateDao.getDimConditionsList(), this.rateDao.getConditionDimensionMap(), this.rateDao.getConditionContextsList(), this.rateDao.getContextConditionsList(), this.rateDao.getUiUserIds(), this.rateDao.getUiItemIds());
                SparseMatrix testData = testDao.readData(this.binThold);
                data = new SparseMatrix[]{this.rateMatrix, testData};
                break;
            }
            case "given-ratio": {
                double ratio = evalOptions.getDouble("-r", 0.8);
                data = ds.getRatioByRating(ratio);
                break;
            }
            default: {
                double ratio = evalOptions.getDouble("-r", 0.8);
                data = ds.getRatioByRating(ratio);
            }
        }
        algo = this.getRecommender(data, -1);
        algo.execute();
        this.printEvalInfo(algo, algo.measures);
    }

    private void printEvalInfo(Recommender algo, Map<Recommender.Measure, Double> ms) throws Exception {
        String result = Recommender.getEvalInfo(ms);
        String time = String.format("'%s','%s'", Dates.parse(ms.get((Object)Recommender.Measure.TrainTime).longValue()), Dates.parse(ms.get((Object)Recommender.Measure.TestTime).longValue()));
        String evalInfo = String.format("Final Results by %s, %s, %s, Time: %s%s", algo.algoName, result, algo.toString(), time, this.outputOptions.contains("--measures-only") ? "" : "\n");
        Logs.info(evalInfo);
        if (this.outputOptions.contains("--to-clipboard")) {
            Strings.toClipboard(evalInfo);
            Logs.debug("Have been copied to clipboard!");
        }
        if (this.outputOptions.contains("--to-file")) {
            String filePath = this.outputOptions.getString("--to-file", WorkingPath + this.algorithm + ".txt");
            FileIO.writeString(filePath, evalInfo, true);
            Logs.debug("Have been collected to file: {}", (Object)filePath);
        }
    }

    private void runCrossValidation(LineConfiger params) throws Exception {
        int kFold = params.getInt("-k", 5);
        boolean isParallelFold = params.isOn("-p", true);
        DataSplitter ds = new DataSplitter(this.rateMatrix, kFold);
        Thread[] ts = new Thread[kFold];
        Recommender[] algos = new Recommender[kFold];
        for (int i = 0; i < kFold; ++i) {
            Recommender algo;
            algos[i] = algo = this.getRecommender(ds.getKthFold(i + 1), i + 1);
            ts[i] = new Thread(algo);
            ts[i].start();
            if (isParallelFold) continue;
            ts[i].join();
        }
        if (isParallelFold) {
            for (Thread t : ts) {
                t.join();
            }
        }
        HashMap<Recommender.Measure, Double> avgMeasure = new HashMap<Recommender.Measure, Double>();
        for (Recommender algo : algos) {
            for (Map.Entry<Recommender.Measure, Double> en : algo.measures.entrySet()) {
                Recommender.Measure m = en.getKey();
                double val = avgMeasure.containsKey((Object)m) ? (Double)avgMeasure.get((Object)m) : 0.0;
                avgMeasure.put(m, val + en.getValue() / (double)kFold);
            }
        }
        this.printEvalInfo(algos[0], avgMeasure);
    }

    protected Recommender getRecommender(SparseMatrix[] data, int fold) throws Exception {
        this.algorithm = this.cf.getString("recommender");
        LineConfiger algOptions = new LineConfiger(this.algorithm);
        SparseMatrix trainMatrix = data[0];
        SparseMatrix testMatrix = data[1];
        switch (algOptions.getMainParam().toLowerCase()) {
            case "globalavg": {
                return new GlobalAverage(trainMatrix, testMatrix, fold);
            }
            case "useravg": {
                return new UserAverage(trainMatrix, testMatrix, fold);
            }
            case "itemavg": {
                return new ItemAverage(trainMatrix, testMatrix, fold);
            }
            case "contextavg": {
                return new ContextAverage(trainMatrix, testMatrix, fold);
            }
            case "useritemavg": {
                return new UserItemAverage(trainMatrix, testMatrix, fold);
            }
            case "usercontextavg": {
                return new UserContextAverage(trainMatrix, testMatrix, fold);
            }
            case "itemcontextavg": {
                return new ItemContextAverage(trainMatrix, testMatrix, fold);
            }
            case "itemknn": {
                return new ItemKNN(trainMatrix, testMatrix, fold);
            }
            case "userknn": {
                return new UserKNN(trainMatrix, testMatrix, fold);
            }
            case "slopeone": {
                return new SlopeOne(trainMatrix, testMatrix, fold);
            }
            case "biasedmf": {
                return new BiasedMF(trainMatrix, testMatrix, fold);
            }
            case "pmf": {
                return new PMF(trainMatrix, testMatrix, fold);
            }
            case "bpmf": {
                return new BPMF(trainMatrix, testMatrix, fold);
            }
            case "nmf": {
                return new NMF(trainMatrix, testMatrix, fold);
            }
            case "svd++": {
                return new SVDPlusPlus(trainMatrix, testMatrix, fold);
            }
            case "slim": {
                return new SLIM(trainMatrix, testMatrix, fold);
            }
            case "bpr": {
                return new BPR(trainMatrix, testMatrix, fold);
            }
            case "lrmf": {
                return new LRMF(trainMatrix, testMatrix, fold);
            }
            case "rankals": {
                return new RankALS(trainMatrix, testMatrix, fold);
            }
            case "ranksgd": {
                return new RankSGD(trainMatrix, testMatrix, fold);
            }
            case "usersplitting": {
                String recsys_traditional = algOptions.getString("-traditional").trim().toLowerCase();
                int minListLenU = algOptions.getInt("-minlenu", 2);
                UserSplitting usp = new UserSplitting(this.rateDao.numUsers(), this.rateDao.getConditionContextsList(), this.rateDao.getURatedList());
                Table<Integer, Integer, Integer> userIdMapper = usp.split(trainMatrix, minListLenU);
                Logs.info("User Splitting is done... Algorithm '" + recsys_traditional + "' will be applied to the transformed data set.");
                Recommender recsys = null;
                switch (recsys_traditional) {
                    case "globalavg": {
                        recsys = new GlobalAverage(trainMatrix, testMatrix, fold);
                        break;
                    }
                    case "useravg": {
                        recsys = new UserAverage(trainMatrix, testMatrix, fold);
                        break;
                    }
                    case "itemavg": {
                        recsys = new ItemAverage(trainMatrix, testMatrix, fold);
                        break;
                    }
                    case "contextavg": {
                        recsys = new ContextAverage(trainMatrix, testMatrix, fold);
                        break;
                    }
                    case "useritemavg": {
                        recsys = new UserItemAverage(trainMatrix, testMatrix, fold);
                        break;
                    }
                    case "usercontextavg": {
                        recsys = new UserContextAverage(trainMatrix, testMatrix, fold);
                        break;
                    }
                    case "itemcontextavg": {
                        recsys = new ItemContextAverage(trainMatrix, testMatrix, fold);
                        break;
                    }
                    case "itemknn": {
                        recsys = new ItemKNN(trainMatrix, testMatrix, fold);
                        break;
                    }
                    case "userknn": {
                        recsys = new UserKNN(trainMatrix, testMatrix, fold);
                        break;
                    }
                    case "slopeone": {
                        recsys = new SlopeOne(trainMatrix, testMatrix, fold);
                        break;
                    }
                    case "biasedmf": {
                        recsys = new BiasedMF(trainMatrix, testMatrix, fold);
                        break;
                    }
                    case "pmf": {
                        recsys = new PMF(trainMatrix, testMatrix, fold);
                        break;
                    }
                    case "bpmf": {
                        recsys = new BPMF(trainMatrix, testMatrix, fold);
                        break;
                    }
                    case "nmf": {
                        recsys = new NMF(trainMatrix, testMatrix, fold);
                        break;
                    }
                    case "svd++": {
                        recsys = new SVDPlusPlus(trainMatrix, testMatrix, fold);
                        break;
                    }
                    case "slim": {
                        recsys = new SLIM(trainMatrix, testMatrix, fold);
                        break;
                    }
                    case "bpr": {
                        recsys = new BPR(trainMatrix, testMatrix, fold);
                        break;
                    }
                    case "lrmf": {
                        recsys = new LRMF(trainMatrix, testMatrix, fold);
                        break;
                    }
                    case "rankals": {
                        recsys = new RankALS(trainMatrix, testMatrix, fold);
                        break;
                    }
                    case "ranksgd": {
                        recsys = new RankSGD(trainMatrix, testMatrix, fold);
                        break;
                    }
                    default: {
                        recsys = null;
                    }
                }
                if (recsys == null) {
                    throw new Exception("No recommender is specified!");
                }
                recsys.setIdMappers(userIdMapper, null);
                return recsys;
            }
            case "itemsplitting": {
                String recsys_traditional = algOptions.getString("-traditional").trim().toLowerCase();
                int minListLenI = algOptions.getInt("-minleni", 2);
                ItemSplitting isp = new ItemSplitting(this.rateDao.numItems(), this.rateDao.getConditionContextsList(), this.rateDao.getIRatedList());
                Table<Integer, Integer, Integer> itemIdMapper = isp.split(trainMatrix, minListLenI);
                Logs.info("Item Splitting is done... Algorithm '" + recsys_traditional + "' will be applied to the transformed data set.");
                Recommender recsys = null;
                switch (recsys_traditional) {
                    case "globalavg": {
                        recsys = new GlobalAverage(trainMatrix, testMatrix, fold);
                        break;
                    }
                    case "useravg": {
                        recsys = new UserAverage(trainMatrix, testMatrix, fold);
                        break;
                    }
                    case "itemavg": {
                        recsys = new ItemAverage(trainMatrix, testMatrix, fold);
                        break;
                    }
                    case "contextavg": {
                        recsys = new ContextAverage(trainMatrix, testMatrix, fold);
                        break;
                    }
                    case "useritemavg": {
                        recsys = new UserItemAverage(trainMatrix, testMatrix, fold);
                        break;
                    }
                    case "usercontextavg": {
                        recsys = new UserContextAverage(trainMatrix, testMatrix, fold);
                        break;
                    }
                    case "itemcontextavg": {
                        recsys = new ItemContextAverage(trainMatrix, testMatrix, fold);
                        break;
                    }
                    case "itemknn": {
                        recsys = new ItemKNN(trainMatrix, testMatrix, fold);
                        break;
                    }
                    case "userknn": {
                        recsys = new UserKNN(trainMatrix, testMatrix, fold);
                        break;
                    }
                    case "slopeone": {
                        recsys = new SlopeOne(trainMatrix, testMatrix, fold);
                        break;
                    }
                    case "biasedmf": {
                        recsys = new BiasedMF(trainMatrix, testMatrix, fold);
                        break;
                    }
                    case "pmf": {
                        recsys = new PMF(trainMatrix, testMatrix, fold);
                        break;
                    }
                    case "bpmf": {
                        recsys = new BPMF(trainMatrix, testMatrix, fold);
                        break;
                    }
                    case "nmf": {
                        recsys = new NMF(trainMatrix, testMatrix, fold);
                        break;
                    }
                    case "svd++": {
                        recsys = new SVDPlusPlus(trainMatrix, testMatrix, fold);
                        break;
                    }
                    case "slim": {
                        recsys = new SLIM(trainMatrix, testMatrix, fold);
                        break;
                    }
                    case "bpr": {
                        recsys = new BPR(trainMatrix, testMatrix, fold);
                        break;
                    }
                    case "lrmf": {
                        recsys = new LRMF(trainMatrix, testMatrix, fold);
                        break;
                    }
                    case "rankals": {
                        recsys = new RankALS(trainMatrix, testMatrix, fold);
                        break;
                    }
                    case "ranksgd": {
                        recsys = new RankSGD(trainMatrix, testMatrix, fold);
                        break;
                    }
                    default: {
                        recsys = null;
                    }
                }
                if (recsys == null) {
                    throw new Exception("No recommender is specified!");
                }
                recsys.setIdMappers(null, itemIdMapper);
                return recsys;
            }
            case "uisplitting": {
                String recsys_traditional = algOptions.getString("-traditional").trim().toLowerCase();
                int minListLenU = algOptions.getInt("-minlenu", 2);
                int minListLenI = algOptions.getInt("-minleni", 2);
                UISplitting sp = new UISplitting(this.rateDao.numUsers(), this.rateDao.numItems(), this.rateDao.getConditionContextsList(), this.rateDao.getURatedList(), this.rateDao.getIRatedList());
                Table<Integer, Integer, Integer> itemIdMapper = sp.splitItem(trainMatrix, minListLenI);
                Table<Integer, Integer, Integer> userIdMapper = sp.splitUser(trainMatrix, minListLenU);
                Logs.info("UI Splitting is done... Algorithm '" + recsys_traditional + "' will be applied to the transformed data set.");
                Recommender recsys = null;
                switch (recsys_traditional) {
                    case "globalavg": {
                        recsys = new GlobalAverage(trainMatrix, testMatrix, fold);
                        break;
                    }
                    case "useravg": {
                        recsys = new UserAverage(trainMatrix, testMatrix, fold);
                        break;
                    }
                    case "itemavg": {
                        recsys = new ItemAverage(trainMatrix, testMatrix, fold);
                        break;
                    }
                    case "contextavg": {
                        recsys = new ContextAverage(trainMatrix, testMatrix, fold);
                        break;
                    }
                    case "useritemavg": {
                        recsys = new UserItemAverage(trainMatrix, testMatrix, fold);
                        break;
                    }
                    case "usercontextavg": {
                        recsys = new UserContextAverage(trainMatrix, testMatrix, fold);
                        break;
                    }
                    case "itemcontextavg": {
                        recsys = new ItemContextAverage(trainMatrix, testMatrix, fold);
                        break;
                    }
                    case "itemknn": {
                        recsys = new ItemKNN(trainMatrix, testMatrix, fold);
                        break;
                    }
                    case "userknn": {
                        recsys = new UserKNN(trainMatrix, testMatrix, fold);
                        break;
                    }
                    case "slopeone": {
                        recsys = new SlopeOne(trainMatrix, testMatrix, fold);
                        break;
                    }
                    case "biasedmf": {
                        recsys = new BiasedMF(trainMatrix, testMatrix, fold);
                        break;
                    }
                    case "pmf": {
                        recsys = new PMF(trainMatrix, testMatrix, fold);
                        break;
                    }
                    case "bpmf": {
                        recsys = new BPMF(trainMatrix, testMatrix, fold);
                        break;
                    }
                    case "nmf": {
                        recsys = new NMF(trainMatrix, testMatrix, fold);
                        break;
                    }
                    case "svd++": {
                        recsys = new SVDPlusPlus(trainMatrix, testMatrix, fold);
                        break;
                    }
                    case "slim": {
                        recsys = new SLIM(trainMatrix, testMatrix, fold);
                        break;
                    }
                    case "bpr": {
                        recsys = new BPR(trainMatrix, testMatrix, fold);
                        break;
                    }
                    case "lrmf": {
                        recsys = new LRMF(trainMatrix, testMatrix, fold);
                        break;
                    }
                    case "rankals": {
                        recsys = new RankALS(trainMatrix, testMatrix, fold);
                        break;
                    }
                    case "ranksgd": {
                        recsys = new RankSGD(trainMatrix, testMatrix, fold);
                        break;
                    }
                    default: {
                        recsys = null;
                    }
                }
                if (recsys == null) {
                    throw new Exception("No recommender is specified!");
                }
                recsys.setIdMappers(userIdMapper, itemIdMapper);
                return recsys;
            }
            case "exactfiltering": {
                return new ExactFiltering(trainMatrix, testMatrix, fold);
            }
            case "dcr": {
                return new DCR(trainMatrix, testMatrix, fold);
            }
            case "dcw": {
                return new DCW(trainMatrix, testMatrix, fold);
            }
            case "spf": {
                return new SPF(trainMatrix, testMatrix, fold);
            }
            case "cptf": {
                this.rateDao.LoadAsTensor();
                return new CPTF(trainMatrix, testMatrix, fold);
            }
            case "camf_c": {
                return new CAMF_C(trainMatrix, testMatrix, fold);
            }
            case "camf_ci": {
                return new CAMF_CI(trainMatrix, testMatrix, fold);
            }
            case "camf_cu": {
                return new CAMF_CU(trainMatrix, testMatrix, fold);
            }
            case "camf_cuci": {
                return new CAMF_CUCI(trainMatrix, testMatrix, fold);
            }
            case "camf_ics": {
                return new CAMF_ICS(trainMatrix, testMatrix, fold);
            }
            case "camf_lcs": {
                return new CAMF_LCS(trainMatrix, testMatrix, fold);
            }
            case "camf_mcs": {
                return new CAMF_MCS(trainMatrix, testMatrix, fold);
            }
            case "cslim_c": {
                return new CSLIM_C(trainMatrix, testMatrix, fold);
            }
            case "cslim_cu": {
                return new CSLIM_CU(trainMatrix, testMatrix, fold);
            }
            case "cslim_ci": {
                return new CSLIM_CI(trainMatrix, testMatrix, fold);
            }
            case "cslim_cuci": {
                return new CSLIM_CUCI(trainMatrix, testMatrix, fold);
            }
            case "gcslim_cc": {
                return new GCSLIM_CC(trainMatrix, testMatrix, fold);
            }
            case "cslim_ics": {
                return new CSLIM_ICS(trainMatrix, testMatrix, fold);
            }
            case "cslim_lcs": {
                return new CSLIM_LCS(trainMatrix, testMatrix, fold);
            }
            case "cslim_mcs": {
                return new CSLIM_MCS(trainMatrix, testMatrix, fold);
            }
            case "gcslim_ics": {
                return new GCSLIM_ICS(trainMatrix, testMatrix, fold);
            }
            case "gcslim_lcs": {
                return new GCSLIM_LCS(trainMatrix, testMatrix, fold);
            }
            case "gcslim_mcs": {
                return new GCSLIM_MCS(trainMatrix, testMatrix, fold);
            }
            case "fm": {
                return new FM(trainMatrix, testMatrix, fold);
            }
        }
        throw new Exception("No recommender is specified!");
    }

    public void setConfigFiles(String ... configurations) {
        this.configFiles = Arrays.asList(configurations);
    }

    private void about() {
        String about = "\nCARSKit version " + version + ", copyright (C) 2015-2019 Yong Zheng \n\n" + "CARSKit is free software: you can redistribute it and/or modify \n" + "it under the terms of the GNU General Public License as published by \n" + "the Free Software Foundation, either version 3 of the License, \n" + "or (at your option) any later version. \n\n" + "CARSKit is distributed in the hope that it will be useful, \n" + "but WITHOUT ANY WARRANTY; without even the implied warranty of \n" + "MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the \n" + "GNU General Public License for more details. \n\n" + "You should have received a copy of the GNU General Public License \n" + "along with CARSKit. If not, see <http://www.gnu.org/licenses/>.";
        System.out.println(about);
    }

    static {
        DefaultWorkingFolder = "CARSKit.Workspace";
    }
}

