/*
 * Decompiled with CFR 0.152.
 */
package carskit.generic;

import carskit.data.structure.SparseMatrix;
import carskit.generic.IterativeRecommender;
import carskit.generic.Recommender;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import librec.data.Configuration;
import librec.data.MatrixEntry;
import librec.data.SparseTensor;
import librec.data.TensorEntry;
import librec.util.FileIO;
import librec.util.Logs;
import librec.util.Strings;

@Configuration(value="factors, lRate, maxLRate, reg, iters, boldDriver")
public class TensorRecommender
extends IterativeRecommender {
    protected static SparseTensor rateTensor = rateDao.getRateTensor();
    protected static int numDimensions = rateTensor.numDimensions();
    protected static int userDimension;
    protected static int itemDimension;
    protected static int[] dimensions;
    protected SparseTensor trainTensor = rateTensor.clone();
    protected SparseTensor testTensor = new SparseTensor(dimensions);

    public TensorRecommender(SparseMatrix trainMatrix, SparseMatrix testMatrix, int fold) throws Exception {
        super(trainMatrix, testMatrix, fold);
        this.testTensor.setUserDimension(userDimension);
        this.testTensor.setItemDimension(itemDimension);
        for (MatrixEntry me : testMatrix) {
            int ui = me.row();
            int u = rateDao.getUserIdFromUI(ui);
            int i = rateDao.getItemIdFromUI(ui);
            List<Integer> indices = rateTensor.getIndices(u, i);
            for (int index : indices) {
                int[] keys = rateTensor.keys(index);
                this.testTensor.set(rateTensor.value(index), keys);
                this.trainTensor.remove(keys);
            }
        }
    }

    @Override
    protected Map<Recommender.Measure, Double> evalRatings() throws Exception {
        ArrayList<String> preds = null;
        String toFile = null;
        if (this.isResultsOut) {
            preds = new ArrayList<String>(1500);
            preds.add("# userId itemId rating prediction");
            toFile = workingPath + this.algoName + "-rating-predictions" + this.foldInfo + ".txt";
            FileIO.deleteFile(toFile);
        }
        double sum_maes = 0.0;
        double sum_mses = 0.0;
        double sum_r_maes = 0.0;
        double sum_r_rmses = 0.0;
        int numCount = 0;
        int numPEs = 0;
        for (TensorEntry te : this.testTensor) {
            double pred;
            int j;
            double rate = te.get();
            int u = te.key(userDimension);
            if (!this.isTestable(u, j = te.key(itemDimension)) || Double.isNaN(pred = this.predict(te.keys(), true))) continue;
            double rPred = (double)Math.round(pred / minRate) * minRate;
            double err = Math.abs(rate - pred);
            double r_err = Math.abs(rate - rPred);
            sum_maes += err;
            sum_mses += err * err;
            sum_r_maes += r_err;
            sum_r_rmses += r_err * r_err;
            ++numCount;
            if (r_err > 1.0E-5) {
                ++numPEs;
            }
            if (!this.isResultsOut) continue;
            preds.add(rateDao.getUserId(u) + " " + rateDao.getItemId(j) + " " + rate + " " + (float)pred);
            if (preds.size() < 1000) continue;
            FileIO.writeList(toFile, preds, true);
            preds.clear();
        }
        if (this.isResultsOut && preds.size() > 0) {
            FileIO.writeList(toFile, preds, true);
            Logs.debug("{}{} has writeen rating predictions to {}", this.algoName, this.foldInfo, toFile);
        }
        double mae = sum_maes / (double)numCount;
        double rmse = Math.sqrt(sum_mses / (double)numCount);
        double r_mae = sum_r_maes / (double)numCount;
        double r_rmse = Math.sqrt(sum_r_rmses / (double)numCount);
        HashMap<Recommender.Measure, Double> measures = new HashMap<Recommender.Measure, Double>();
        measures.put(Recommender.Measure.MAE, mae);
        measures.put(Recommender.Measure.NMAE, mae / (maxRate - minRate));
        measures.put(Recommender.Measure.RMSE, rmse);
        measures.put(Recommender.Measure.rMAE, r_mae);
        measures.put(Recommender.Measure.rRMSE, r_rmse);
        measures.put(Recommender.Measure.MPE, ((double)numPEs + 0.0) / (double)numCount);
        return measures;
    }

    protected double predict(int[] keys, boolean bound) throws Exception {
        double pred = this.predict(keys);
        if (bound) {
            if (pred > maxRate) {
                pred = maxRate;
            }
            if (pred < minRate) {
                pred = minRate;
            }
        }
        return pred;
    }

    protected double predict(int[] keys) throws Exception {
        return this.predict(keys[userDimension], keys[itemDimension]);
    }

    @Override
    public String toString() {
        return Strings.toString(new Object[]{numFactors, Float.valueOf(initLRate), Float.valueOf(maxLRate), Float.valueOf(reg), numIters, isBoldDriver});
    }

    public int[] getKeys(int u, int i, int c) {
        int[] keys = new int[numDimensions];
        keys[0] = u;
        keys[1] = i;
        HashMap<Integer, ArrayList<Integer>> dimensionConditionsList = rateDao.getDimensionConditionsList();
        ArrayList<Integer> conds = rateDao.getContextConditionsList().get(c);
        int start = -1;
        for (int k = 0; k < conds.size(); ++k) {
            int index;
            int condId = conds.get(k);
            if ((index = dimensionConditionsList.get(++start).indexOf(condId)) == -1) {
                Logs.error("Index == -1: dimId = " + start + ", condId = " + condId);
            }
            keys[2 + start] = index;
        }
        return keys;
    }

    static {
        dimensions = rateTensor.dimensions();
        userDimension = rateTensor.getUserDimension();
        itemDimension = rateTensor.getItemDimension();
    }
}

