/*
 * Decompiled with CFR 0.152.
 */
package carskit.generic;

import carskit.data.processor.DataDAO;
import carskit.data.setting.AddConfiguration;
import carskit.data.setting.Configuration;
import carskit.eval.Measures;
import com.google.common.base.Stopwatch;
import com.google.common.base.Strings;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Table;
import happy.coding.io.FileConfiger;
import happy.coding.io.FileIO;
import happy.coding.io.LineConfiger;
import happy.coding.io.Lists;
import happy.coding.io.Logs;
import happy.coding.math.Randoms;
import happy.coding.math.Sims;
import happy.coding.math.Stats;
import happy.coding.system.Dates;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import librec.data.MatrixEntry;
import librec.data.SparseMatrix;
import librec.data.SparseVector;
import librec.data.SymmMatrix;

public abstract class Recommender
implements Runnable {
    public static String workingPath;
    public static FileConfiger cf;
    public static carskit.data.structure.SparseMatrix rateMatrix;
    public static Map<String, List<Float>> params;
    protected static String cacheSpec;
    protected static int numCPUs;
    protected static boolean verbose;
    protected static LineConfiger rankOptions;
    protected static LineConfiger algoOptions;
    public static boolean isRankingPred;
    public static float binThold;
    public static float validationRatio;
    protected static boolean isDiverseUsed;
    protected static Measure earlyStopMeasure;
    protected static boolean isSaveModel;
    public static String view;
    public static DataDAO rateDao;
    protected static int numIgnore;
    protected static int numRecs;
    protected static List<Double> ratingScale;
    protected static int numLevels;
    protected static double maxRate;
    protected static double minRate;
    protected static double initMean;
    protected static double initStd;
    protected static double smallValue;
    protected static int knn;
    protected static String similarityMeasure;
    protected static int similarityShrinkage;
    public static boolean resetStatics;
    public String algoName;
    protected int fold;
    protected String foldInfo;
    protected boolean isResultsOut = true;
    protected int numUsers;
    protected int numItems;
    protected int numRates;
    protected LoadingCache<Integer, SparseVector> userCache;
    protected LoadingCache<Integer, SparseVector> itemCache;
    protected LoadingCache<Integer, List<Integer>> userItemsCache;
    protected LoadingCache<Integer, List<Integer>> itemUsersCache;
    protected carskit.data.structure.SparseMatrix trainMatrix;
    protected carskit.data.structure.SparseMatrix validationMatrix;
    protected carskit.data.structure.SparseMatrix testMatrix;
    protected boolean isUserSplitting = false;
    protected boolean isItemSplitting = false;
    protected boolean isCARSRecommender = false;
    protected Table<Integer, Integer, Integer> userIdMapper;
    protected Table<Integer, Integer, Integer> itemIdMapper;
    protected SparseMatrix train;
    protected SymmMatrix corrs;
    public Map<Measure, Double> measures;
    protected double globalMean;

    public Recommender(carskit.data.structure.SparseMatrix trainMatrix, carskit.data.structure.SparseMatrix testMatrix, int fold) {
        if (cf == null || rateMatrix == null) {
            Logs.error("Recommender is not well configed");
            System.exit(-1);
        }
        this.numUsers = rateDao.numUsers();
        this.numItems = rateDao.numItems();
        if (resetStatics) {
            resetStatics = false;
            ratingScale = rateDao.getRatingScale();
            minRate = ratingScale.get(0);
            maxRate = ratingScale.get(ratingScale.size() - 1);
            numLevels = ratingScale.size();
            initMean = 0.0;
            initStd = 0.1;
            cacheSpec = cf.getString("guava.cache.spec", "maximumSize=200,expireAfterAccess=2m");
            rankOptions = cf.getParamOptions("item.ranking");
            isRankingPred = rankOptions.isMainOn();
            isDiverseUsed = rankOptions.contains("-diverse");
            numRecs = rankOptions.getInt("-topN", -1);
            if (numRecs < 0) {
                numRecs = 10;
            }
            numIgnore = rankOptions.getInt("-ignore", -1);
            LineConfiger evalOptions = cf.getParamOptions("evaluation.setup");
            view = evalOptions.getString("--test-view", "all");
            String earlyStop = evalOptions.getString("--early-stop");
            if (earlyStop != null) {
                for (Measure m : Measure.values()) {
                    if (!m.name().equalsIgnoreCase(earlyStop)) continue;
                    earlyStopMeasure = m;
                    break;
                }
            }
            int numProcessors = Runtime.getRuntime().availableProcessors();
            numCPUs = evalOptions.getInt("-cpu", numProcessors);
            Randoms.seed(evalOptions.getLong("--rand-seed", System.currentTimeMillis()));
            LineConfiger outputOptions = cf.getParamOptions("output.setup");
            if (outputOptions != null) {
                verbose = outputOptions.isOn("-verbose", true);
                isSaveModel = outputOptions.contains("--save-model");
            }
            knn = cf.getInt("num.neighbors", 20);
            similarityMeasure = cf.getString("similarity", "PCC");
            similarityShrinkage = cf.getInt("num.shrinkage", 30);
        }
        this.trainMatrix = trainMatrix;
        this.testMatrix = testMatrix;
        this.fold = fold;
        this.foldInfo = fold > 0 ? " fold [" + fold + "]" : "";
        LineConfiger outputOptions = cf.getParamOptions("output.setup");
        if (outputOptions != null) {
            this.isResultsOut = true;
        }
        this.globalMean = trainMatrix.getGlobalAvg();
        this.algoName = this.getClass().getSimpleName();
        algoOptions = this.getModelParams(this.algoName);
        if (isRankingPred && isDiverseUsed) {
            this.corrs = new SymmMatrix(this.numItems);
        }
    }

    protected LineConfiger getModelParams(String algoName) {
        return cf.contains(algoName) ? cf.getParamOptions(algoName) : null;
    }

    protected double predict(int u, int j, int c) throws Exception {
        return this.globalMean;
    }

    protected double predict(int u, int j) throws Exception {
        return this.globalMean;
    }

    protected double predict(int u, int j, int c, boolean bound) throws Exception {
        double pred = this.predict(u, j, c);
        if (bound) {
            if (pred > maxRate) {
                pred = maxRate;
            }
            if (pred < minRate) {
                pred = minRate;
            }
        }
        return pred;
    }

    public void execute() throws Exception {
        Stopwatch sw = Stopwatch.createStarted();
        this.initModel();
        this.buildModel();
        this.postModel();
        long trainTime = sw.elapsed(TimeUnit.MILLISECONDS);
        if (verbose) {
            Logs.debug("{}{} evaluate test data ... ", this.algoName, this.foldInfo);
        }
        this.measures = isRankingPred ? this.evalRankings() : this.evalRatings();
        String measurements = Recommender.getEvalInfo(this.measures);
        sw.stop();
        long testTime = sw.elapsed(TimeUnit.MILLISECONDS) - trainTime;
        this.measures.put(Measure.TrainTime, Double.valueOf(trainTime));
        this.measures.put(Measure.TestTime, Double.valueOf(testTime));
        String evalInfo = this.algoName + this.foldInfo + ": " + measurements + "\tTime: " + Dates.parse(this.measures.get((Object)Measure.TrainTime).longValue()) + ", " + Dates.parse(this.measures.get((Object)Measure.TestTime).longValue());
        if (!isRankingPred) {
            evalInfo = evalInfo + "\tView: " + view;
        }
        if (this.fold > 0) {
            Logs.debug(evalInfo);
        }
        if (isSaveModel) {
            this.saveModel();
        }
    }

    protected double correlation(SparseVector iv, SparseVector jv) {
        return this.correlation(iv, jv, similarityMeasure);
    }

    protected double correlation(SparseVector iv, SparseVector jv, String method) {
        ArrayList<Double> is = new ArrayList<Double>();
        ArrayList<Double> js = new ArrayList<Double>();
        int[] arr$ = jv.getIndex();
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            Integer idx = arr$[i$];
            if (!iv.contains(idx)) continue;
            is.add(iv.get(idx));
            js.add(jv.get(idx));
        }
        double sim = 0.0;
        switch (method.toLowerCase()) {
            case "cos": {
                sim = Sims.cos(is, js);
                break;
            }
            case "cos-binary": {
                sim = iv.inner(jv) / (Math.sqrt(iv.inner(iv)) * Math.sqrt(jv.inner(jv)));
                break;
            }
            case "msd": {
                sim = Sims.msd(is, js);
                break;
            }
            case "cpc": {
                sim = Sims.cpc(is, js, (minRate + maxRate) / 2.0);
                break;
            }
            case "exjaccard": {
                sim = Sims.exJaccard(is, js);
                break;
            }
            default: {
                sim = Sims.pcc(is, js);
            }
        }
        if (!Double.isNaN(sim)) {
            int n = is.size();
            int shrinkage = cf.getInt("num.shrinkage");
            if (shrinkage > 0) {
                sim *= (double)n / ((double)(n + shrinkage) + 0.0);
            }
        }
        return sim;
    }

    public static String getEvalInfo(Map<Measure, Double> measures) {
        String evalInfo = null;
        if (isRankingPred) {
            evalInfo = numRecs != 10 ? (isDiverseUsed ? String.format("Pre5: %.6f,Pre10: %.6f, Pre" + numRecs + ": %.6f, Rec5: %.6f, Rec10: %.6f, Rec" + numRecs + ": %.6f, " + "AUC5: %.6f, AUC10: %.6f, AUC" + numRecs + ": %.6f, MAP5: %.6f, MAP10: %.6f, MAP" + numRecs + ": %.6f, " + "NDCG5: %.6f, NDCG10: %.6f,NDCG" + numRecs + ": %.6f,MRR5: %.6f, MRR10: %.6f,MRR" + numRecs + ": %.6f,D5: %.6f, D10: %.6f, D" + numRecs + ": %.6f", measures.get((Object)Measure.Pre5), measures.get((Object)Measure.Pre10), measures.get((Object)Measure.PreN), measures.get((Object)Measure.Rec5), measures.get((Object)Measure.Rec10), measures.get((Object)Measure.RecN), measures.get((Object)Measure.AUC5), measures.get((Object)Measure.AUC10), measures.get((Object)Measure.AUCN), measures.get((Object)Measure.MAP5), measures.get((Object)Measure.MAP10), measures.get((Object)Measure.MAPN), measures.get((Object)Measure.NDCG5), measures.get((Object)Measure.NDCG10), measures.get((Object)Measure.NDCGN), measures.get((Object)Measure.MRR5), measures.get((Object)Measure.MRR10), measures.get((Object)Measure.MRRN), measures.get((Object)Measure.D5), measures.get((Object)Measure.D10), measures.get((Object)Measure.DN)) : String.format("Pre5: %.6f,Pre10: %.6f, Pre" + numRecs + ": %.6f, Rec5: %.6f, Rec10: %.6f, Rec" + numRecs + ": %.6f, " + "AUC5: %.6f, AUC10: %.6f, AUC" + numRecs + ": %.6f, MAP5: %.6f, MAP10: %.6f, MAP" + numRecs + ": %.6f, " + "NDCG5: %.6f, NDCG10: %.6f,NDCG" + numRecs + ": %.6f,MRR5: %.6f, MRR10: %.6f,MRR" + numRecs + ": %.6f", measures.get((Object)Measure.Pre5), measures.get((Object)Measure.Pre10), measures.get((Object)Measure.PreN), measures.get((Object)Measure.Rec5), measures.get((Object)Measure.Rec10), measures.get((Object)Measure.RecN), measures.get((Object)Measure.AUC5), measures.get((Object)Measure.AUC10), measures.get((Object)Measure.AUCN), measures.get((Object)Measure.MAP5), measures.get((Object)Measure.MAP10), measures.get((Object)Measure.MAPN), measures.get((Object)Measure.NDCG5), measures.get((Object)Measure.NDCG10), measures.get((Object)Measure.NDCGN), measures.get((Object)Measure.MRR5), measures.get((Object)Measure.MRR10), measures.get((Object)Measure.MRRN))) : (isDiverseUsed ? String.format("Pre5: %.6f,Pre10: %.6f, Rec5: %.6f, Rec10: %.6f, AUC5: %.6f, AUC10: %.6f, MAP5: %.6f, MAP10: %.6f,NDCG5: %.6f, NDCG10: %.6f,MRR5: %.6f, MRR10: %.6f,D5: %.6f, D10: %.6f", measures.get((Object)Measure.Pre5), measures.get((Object)Measure.Pre10), measures.get((Object)Measure.Rec5), measures.get((Object)Measure.Rec10), measures.get((Object)Measure.AUC5), measures.get((Object)Measure.AUC10), measures.get((Object)Measure.MAP5), measures.get((Object)Measure.MAP10), measures.get((Object)Measure.NDCG5), measures.get((Object)Measure.NDCG10), measures.get((Object)Measure.MRR5), measures.get((Object)Measure.MRR10), measures.get((Object)Measure.D5), measures.get((Object)Measure.D10)) : String.format("Pre5: %.6f,Pre10: %.6f, Rec5: %.6f, Rec10: %.6f, AUC5: %.6f, AUC10: %.6f, MAP5: %.6f, MAP10: %.6f,NDCG5: %.6f, NDCG10: %.6f,MRR5: %.6f, MRR10: %.6f", measures.get((Object)Measure.Pre5), measures.get((Object)Measure.Pre10), measures.get((Object)Measure.Rec5), measures.get((Object)Measure.Rec10), measures.get((Object)Measure.AUC5), measures.get((Object)Measure.AUC10), measures.get((Object)Measure.MAP5), measures.get((Object)Measure.MAP10), measures.get((Object)Measure.NDCG5), measures.get((Object)Measure.NDCG10), measures.get((Object)Measure.MRR5), measures.get((Object)Measure.MRR10)));
        } else {
            evalInfo = String.format("MAE: %.6f, RMSE: %.6f, NAME: %.6f, rMAE: %.6f, rRMSE: %.6f, MPE: %.6f", measures.get((Object)Measure.MAE), measures.get((Object)Measure.RMSE), measures.get((Object)Measure.NMAE), measures.get((Object)Measure.rMAE), measures.get((Object)Measure.rRMSE), measures.get((Object)Measure.MPE));
            if (measures.containsKey((Object)Measure.Perplexity)) {
                evalInfo = evalInfo + String.format(",%.6f", measures.get((Object)Measure.Perplexity));
            }
        }
        return evalInfo;
    }

    protected Map<Measure, Double> evalRatings() throws Exception {
        ArrayList<String> preds = null;
        String toFile = null;
        if (this.isResultsOut) {
            preds = new ArrayList<String>(1500);
            preds.add("userId\titemId\tcontexts\trating\tprediction");
            toFile = workingPath + this.algoName + "-rating-predictions" + this.foldInfo + ".txt";
            FileIO.deleteFile(toFile);
        }
        double sum_maes = 0.0;
        double sum_mses = 0.0;
        double sum_r_maes = 0.0;
        double sum_r_rmses = 0.0;
        double sum_perps = 0.0;
        int numCount = 0;
        boolean numPEs = false;
        for (MatrixEntry me : this.testMatrix) {
            double pred;
            double rate = me.get();
            int ui = me.row();
            int ctx = me.column();
            int u = rateDao.getUserIdFromUI(ui);
            int j = rateDao.getItemIdFromUI(ui);
            if (this.isUserSplitting) {
                int n = u = this.userIdMapper.contains(u, ctx) ? this.userIdMapper.get(u, ctx) : u;
            }
            if (this.isItemSplitting) {
                int n = j = this.itemIdMapper.contains(j, ctx) ? this.itemIdMapper.get(j, ctx) : j;
            }
            if (Double.isNaN(pred = this.predict(u, j, ctx, true))) continue;
            double perp = this.perplexity(u, j, pred);
            sum_perps += perp;
            double rPred = (double)Math.round(pred / minRate) * minRate;
            double err = Math.abs(rate - pred);
            double r_err = Math.abs(rate - rPred);
            sum_maes += err;
            sum_mses += err * err;
            sum_r_maes += r_err;
            sum_r_rmses += r_err * r_err;
            ++numCount;
            if (!this.isResultsOut) continue;
            preds.add(rateDao.getUserId(u) + "\t" + rateDao.getItemId(j) + "\t" + rateDao.getContextSituationFromInnerId(ctx) + "\t" + rate + "\t" + (float)pred);
            if (preds.size() < 1000) continue;
            FileIO.writeList(toFile, preds, true);
            preds.clear();
        }
        if (this.isResultsOut && preds.size() > 0) {
            FileIO.writeList(toFile, preds, true);
            Logs.debug("{}{} has writeen rating predictions to {}", this.algoName, this.foldInfo, toFile);
        }
        double mae = sum_maes / (double)numCount;
        double rmse = Math.sqrt(sum_mses / (double)numCount);
        double r_mae = sum_r_maes / (double)numCount;
        double r_rmse = Math.sqrt(sum_r_rmses / (double)numCount);
        HashMap<Measure, Double> measures = new HashMap<Measure, Double>();
        measures.put(Measure.MAE, mae);
        measures.put(Measure.NMAE, mae / (maxRate - minRate));
        measures.put(Measure.RMSE, rmse);
        measures.put(Measure.rMAE, r_mae);
        measures.put(Measure.rRMSE, r_rmse);
        measures.put(Measure.MPE, ((double)numPEs + 0.0) / (double)numCount);
        if (sum_perps > 0.0) {
            measures.put(Measure.Perplexity, Math.exp(sum_perps / (double)numCount));
        }
        return measures;
    }

    public void setIdMappers(Table<Integer, Integer, Integer> uid, Table<Integer, Integer, Integer> iid) {
        this.userIdMapper = uid;
        this.itemIdMapper = iid;
        if (uid != null) {
            this.isUserSplitting = true;
        }
        if (iid != null) {
            this.isItemSplitting = true;
        }
        this.algoName = this.getAlgoName();
    }

    protected String getAlgoName() {
        if (this.isUserSplitting && this.isItemSplitting) {
            this.algoName = "UISplitting-" + this.algoName;
        } else if (this.isUserSplitting) {
            this.algoName = "UserSplitting-" + this.algoName;
        } else if (this.isItemSplitting) {
            this.algoName = "ItemSplitting-" + this.algoName;
        }
        return this.algoName;
    }

    protected SparseMatrix createTraditionalSparseMatrixBySplitting() {
        HashBasedTable<Integer, Integer, Double> newtable = HashBasedTable.create();
        HashMultimap<Integer, Integer> colMap = HashMultimap.create();
        HashMultimap records = HashMultimap.create();
        int maxUser = -1;
        int maxItem = -1;
        for (MatrixEntry me : this.trainMatrix) {
            int ui = me.row();
            int ctx = me.column();
            int u = rateDao.getUserIdFromUI(ui);
            int j = rateDao.getItemIdFromUI(ui);
            if (this.isUserSplitting) {
                int n = u = this.userIdMapper.contains(u, ctx) ? this.userIdMapper.get(u, ctx) : u;
            }
            if (this.isItemSplitting) {
                j = this.itemIdMapper.contains(j, ctx) ? this.itemIdMapper.get(j, ctx) : j;
            }
            records.put(u + "," + j, (Object)me.get());
            if (u > maxUser) {
                maxUser = u;
            }
            if (j <= maxItem) continue;
            maxItem = j;
        }
        for (String key : records.keySet()) {
            String[] ids = key.split(",");
            int u = Integer.valueOf(ids[0]);
            int j = Integer.valueOf(ids[1]);
            newtable.put(u, j, Stats.mean(records.get(key)));
            colMap.put(j, u);
        }
        this.numUsers = this.numUsers < ++maxUser ? maxUser : this.numUsers;
        this.numItems = this.numItems < maxItem ? ++maxItem : this.numItems;
        SparseMatrix sm = new SparseMatrix(this.numUsers, this.numItems, newtable, colMap);
        Logs.info("Density of transformed 2D rating matrix ============================== " + ((double)sm.getData().length + 0.0) / (double)(sm.numRows() * sm.numColumns()));
        return sm;
    }

    protected double perplexity(int u, int j, double r) throws Exception {
        return 0.0;
    }

    protected Map<Measure, Double> evalRankings() throws Exception {
        int numTopNRanks;
        HashMap<Integer, HashMultimap<Integer, Integer>> uciList = rateDao.getUserCtxList(this.testMatrix, binThold);
        HashMap<Integer, HashMultimap<Integer, Integer>> uciList_train = rateDao.getUserCtxList(this.trainMatrix);
        int capacity = uciList.keySet().size();
        ArrayList<Double> ds5 = new ArrayList<Double>(isDiverseUsed ? capacity : 0);
        ArrayList<Double> ds10 = new ArrayList<Double>(isDiverseUsed ? capacity : 0);
        ArrayList<Double> dsN = new ArrayList<Double>(isDiverseUsed ? capacity : 0);
        ArrayList<Double> precs5 = new ArrayList<Double>(capacity);
        ArrayList<Double> precs10 = new ArrayList<Double>(capacity);
        ArrayList<Double> precsN = new ArrayList<Double>(capacity);
        ArrayList<Double> recalls5 = new ArrayList<Double>(capacity);
        ArrayList<Double> recalls10 = new ArrayList<Double>(capacity);
        ArrayList<Double> recallsN = new ArrayList<Double>(capacity);
        ArrayList<Double> aps5 = new ArrayList<Double>(capacity);
        ArrayList<Double> aps10 = new ArrayList<Double>(capacity);
        ArrayList<Double> apsN = new ArrayList<Double>(capacity);
        ArrayList<Double> rrs5 = new ArrayList<Double>(capacity);
        ArrayList<Double> rrs10 = new ArrayList<Double>(capacity);
        ArrayList<Double> rrsN = new ArrayList<Double>(capacity);
        ArrayList<Double> aucs5 = new ArrayList<Double>(capacity);
        ArrayList<Double> aucs10 = new ArrayList<Double>(capacity);
        ArrayList<Double> aucsN = new ArrayList<Double>(capacity);
        ArrayList<Double> ndcgs5 = new ArrayList<Double>(capacity);
        ArrayList<Double> ndcgs10 = new ArrayList<Double>(capacity);
        ArrayList<Double> ndcgsN = new ArrayList<Double>(capacity);
        Set<Integer> candItems = rateDao.getItemList(this.trainMatrix);
        ArrayList<String> preds = null;
        String toFile = null;
        int n = numTopNRanks = numRecs < 0 ? 10 : numRecs;
        if (this.isResultsOut) {
            preds = new ArrayList<String>(1500);
            preds.add("# userId: recommendations in (itemId, ranking score) pairs, where a correct recommendation is denoted by symbol *.");
            toFile = workingPath + String.format("%s-top-%d-items%s.txt", this.algoName, numTopNRanks, this.foldInfo);
            FileIO.deleteFile(toFile);
        }
        if (verbose) {
            Logs.debug("{}{} has candidate items: {}", this.algoName, this.foldInfo, candItems.size());
        }
        if (numIgnore > 0) {
            ArrayList itemDegs = new ArrayList();
            for (Integer j : candItems) {
                itemDegs.add(new AbstractMap.SimpleImmutableEntry<Integer, Integer>(j, rateDao.getRatingCountByItem(this.trainMatrix, j)));
            }
            Lists.sortList(itemDegs, true);
            int k = 0;
            for (Map.Entry entry : itemDegs) {
                candItems.remove(entry.getKey());
                if (++k < numIgnore) continue;
                break;
            }
        }
        Iterator<Integer> i$ = uciList.keySet().iterator();
        while (i$.hasNext()) {
            int u;
            int uu = u = i$.next().intValue();
            Multimap multimap = uciList.get(u);
            int c_capacity = multimap.keySet().size();
            ArrayList<Double> c_ds5 = new ArrayList<Double>(isDiverseUsed ? c_capacity : 0);
            ArrayList<Double> c_ds10 = new ArrayList<Double>(isDiverseUsed ? c_capacity : 0);
            ArrayList<Double> c_dsN = new ArrayList<Double>(isDiverseUsed ? c_capacity : 0);
            ArrayList<Double> c_precs5 = new ArrayList<Double>(c_capacity);
            ArrayList<Double> c_precs10 = new ArrayList<Double>(c_capacity);
            ArrayList<Double> c_precsN = new ArrayList<Double>(c_capacity);
            ArrayList<Double> c_recalls5 = new ArrayList<Double>(c_capacity);
            ArrayList<Double> c_recalls10 = new ArrayList<Double>(c_capacity);
            ArrayList<Double> c_recallsN = new ArrayList<Double>(c_capacity);
            ArrayList<Double> c_aps5 = new ArrayList<Double>(c_capacity);
            ArrayList<Double> c_aps10 = new ArrayList<Double>(c_capacity);
            ArrayList<Double> c_apsN = new ArrayList<Double>(c_capacity);
            ArrayList<Double> c_rrs5 = new ArrayList<Double>(c_capacity);
            ArrayList<Double> c_rrs10 = new ArrayList<Double>(c_capacity);
            ArrayList<Double> c_rrsN = new ArrayList<Double>(c_capacity);
            ArrayList<Double> c_aucs5 = new ArrayList<Double>(c_capacity);
            ArrayList<Double> c_aucs10 = new ArrayList<Double>(c_capacity);
            ArrayList<Double> c_aucsN = new ArrayList<Double>(c_capacity);
            ArrayList<Double> c_ndcgs5 = new ArrayList<Double>(c_capacity);
            ArrayList<Double> c_ndcgs10 = new ArrayList<Double>(c_capacity);
            ArrayList<Double> c_ndcgsN = new ArrayList<Double>(c_capacity);
            HashMultimap cList_train = uciList_train.containsKey(u) ? uciList_train.get(u) : HashMultimap.create();
            Iterator i$2 = multimap.keySet().iterator();
            while (i$2.hasNext()) {
                int c = (Integer)i$2.next();
                if (verbose && (u + 1) % 100 == 0) {
                    Logs.debug("{}{} evaluates progress: {} / {}", this.algoName, this.foldInfo, u + 1, capacity);
                }
                int numCands = candItems.size();
                Collection posItems = multimap.get(c);
                ArrayList<Integer> correctItems = new ArrayList<Integer>();
                for (Integer j : posItems) {
                    if (!candItems.contains(j)) continue;
                    correctItems.add(j);
                }
                if (correctItems.size() == 0) continue;
                Set ratedItems = cList_train.containsKey(c) ? cList_train.get((Object)c) : new HashSet();
                ArrayList itemScores = new ArrayList(Lists.initSize(candItems));
                for (Integer j : candItems) {
                    int jj = j;
                    if (!ratedItems.contains(j)) {
                        double rank;
                        if (this.isUserSplitting) {
                            int n2 = u = this.userIdMapper.contains(u, c) ? this.userIdMapper.get(u, c) : u;
                        }
                        if (this.isItemSplitting) {
                            Integer n3 = j = this.itemIdMapper.contains(j, c) ? this.itemIdMapper.get(j, c) : j;
                        }
                        if (Double.isNaN(rank = this.ranking(u, j, c)) || !(rank > (double)binThold)) continue;
                        itemScores.add(new AbstractMap.SimpleImmutableEntry<Integer, Double>(jj, rank));
                        continue;
                    }
                    --numCands;
                }
                if (itemScores.size() == 0) continue;
                Lists.sortList(itemScores, true);
                ArrayList recomd = numRecs <= 0 || itemScores.size() <= numRecs ? itemScores : itemScores.subList(0, numRecs);
                ArrayList<Integer> rankedItems = new ArrayList<Integer>();
                StringBuilder sb = new StringBuilder();
                int count = 0;
                for (Map.Entry entry : recomd) {
                    Integer item = (Integer)entry.getKey();
                    rankedItems.add(item);
                    if (!this.isResultsOut || count >= numTopNRanks) continue;
                    sb.append("(").append(rateDao.getItemId(item));
                    if (posItems.contains(item)) {
                        sb.append("*");
                    }
                    sb.append(", ").append(((Double)entry.getValue()).floatValue()).append(")");
                    if (++count >= numTopNRanks) break;
                    if (count >= numTopNRanks) continue;
                    sb.append(", ");
                }
                int numDropped = numCands - rankedItems.size();
                List<Integer> list = Arrays.asList(5, 10, numRecs);
                Map<Integer, Double> precs = Measures.PrecAt(rankedItems, correctItems, list);
                Map<Integer, Double> recalls = Measures.RecallAt(rankedItems, correctItems, list);
                Map<Integer, Double> aucs = Measures.AUCAt(rankedItems, correctItems, numDropped, list);
                Map<Integer, Double> aps = Measures.APAt(rankedItems, correctItems, list);
                Map<Integer, Double> ndcgs = Measures.nDCGAt(rankedItems, correctItems, list);
                Map<Integer, Double> rrs = Measures.RRAt(rankedItems, correctItems, list);
                c_precs5.add(precs.get(5));
                c_precs10.add(precs.get(10));
                c_precsN.add(precs.get(numRecs));
                c_recalls5.add(recalls.get(5));
                c_recalls10.add(recalls.get(10));
                c_recallsN.add(recalls.get(numRecs));
                c_aucs5.add(aucs.get(5));
                c_aps5.add(aps.get(5));
                c_rrs5.add(rrs.get(5));
                c_ndcgs5.add(ndcgs.get(5));
                c_aucs10.add(aucs.get(10));
                c_aps10.add(aps.get(10));
                c_rrs10.add(rrs.get(10));
                c_ndcgs10.add(ndcgs.get(10));
                c_aucsN.add(aucs.get(numRecs));
                c_apsN.add(aps.get(numRecs));
                c_rrsN.add(rrs.get(numRecs));
                c_ndcgsN.add(ndcgs.get(numRecs));
                if (isDiverseUsed) {
                    double d5 = this.diverseAt(rankedItems, 5);
                    double d10 = this.diverseAt(rankedItems, 10);
                    double dN = this.diverseAt(rankedItems, numRecs);
                    c_ds5.add(d5);
                    c_ds10.add(d10);
                    c_dsN.add(dN);
                }
                if (!this.isResultsOut) continue;
                preds.add(rateDao.getUserId(uu) + ", " + rateDao.getContextSituationFromInnerId(c) + ": " + sb.toString());
                if (preds.size() < 1000) continue;
                FileIO.writeList(toFile, preds, true);
                preds.clear();
            }
            ds5.add(isDiverseUsed ? Stats.mean(c_ds5) : 0.0);
            ds10.add(isDiverseUsed ? Stats.mean(c_ds10) : 0.0);
            dsN.add(isDiverseUsed ? Stats.mean(c_dsN) : 0.0);
            precs5.add(Stats.mean(c_precs5));
            precs10.add(Stats.mean(c_precs10));
            precsN.add(Stats.mean(c_precsN));
            recalls5.add(Stats.mean(c_recalls5));
            recalls10.add(Stats.mean(c_recalls10));
            recallsN.add(Stats.mean(c_recallsN));
            aucs5.add(Stats.mean(c_aucs5));
            ndcgs5.add(Stats.mean(c_ndcgs5));
            aps5.add(Stats.mean(c_aps5));
            rrs5.add(Stats.mean(c_rrs5));
            aucs10.add(Stats.mean(c_aucs10));
            ndcgs10.add(Stats.mean(c_ndcgs10));
            aps10.add(Stats.mean(c_aps10));
            rrs10.add(Stats.mean(c_rrs10));
            aucsN.add(Stats.mean(c_aucsN));
            ndcgsN.add(Stats.mean(c_ndcgsN));
            apsN.add(Stats.mean(c_apsN));
            rrsN.add(Stats.mean(c_rrsN));
        }
        if (this.isResultsOut && preds.size() > 0) {
            FileIO.writeList(toFile, preds, true);
            Logs.debug("{}{} has writeen item recommendations to {}", this.algoName, this.foldInfo, toFile);
        }
        HashMap<Measure, Double> measures = new HashMap<Measure, Double>();
        measures.put(Measure.D5, isDiverseUsed ? Stats.mean(ds5) : 0.0);
        measures.put(Measure.D10, isDiverseUsed ? Stats.mean(ds10) : 0.0);
        measures.put(Measure.DN, isDiverseUsed ? Stats.mean(dsN) : 0.0);
        measures.put(Measure.Pre5, Stats.mean(precs5));
        measures.put(Measure.Pre10, Stats.mean(precs10));
        measures.put(Measure.PreN, Stats.mean(precsN));
        measures.put(Measure.Rec5, Stats.mean(recalls5));
        measures.put(Measure.Rec10, Stats.mean(recalls10));
        measures.put(Measure.RecN, Stats.mean(recallsN));
        measures.put(Measure.AUC5, Stats.mean(aucs5));
        measures.put(Measure.NDCG5, Stats.mean(ndcgs5));
        measures.put(Measure.MAP5, Stats.mean(aps5));
        measures.put(Measure.MRR5, Stats.mean(rrs5));
        measures.put(Measure.AUC10, Stats.mean(aucs10));
        measures.put(Measure.NDCG10, Stats.mean(ndcgs10));
        measures.put(Measure.MAP10, Stats.mean(aps10));
        measures.put(Measure.MRR10, Stats.mean(rrs10));
        measures.put(Measure.AUCN, Stats.mean(aucsN));
        measures.put(Measure.NDCGN, Stats.mean(ndcgsN));
        measures.put(Measure.MAPN, Stats.mean(apsN));
        measures.put(Measure.MRRN, Stats.mean(rrsN));
        return measures;
    }

    protected boolean isTestable(int u, int j) {
        String uiid = u + "," + j;
        int rowid = rateDao.getUserItemId(uiid);
        switch (view) {
            case "cold-start": {
                return this.trainMatrix.rowSize(rowid) < 5;
            }
        }
        return true;
    }

    protected double diverseAt(List<Integer> rankedItems, int cutoff) {
        int num = 0;
        double sum = 0.0;
        for (int id = 0; id < cutoff; ++id) {
            int i = rankedItems.get(id);
            SparseVector iv = this.trainMatrix.column(i);
            for (int jd = id + 1; jd < cutoff; ++jd) {
                int j = rankedItems.get(jd);
                double corr = this.corrs.get(i, j);
                if (corr == 0.0 && !Double.isNaN(corr = this.correlation(iv, this.trainMatrix.column(j)))) {
                    this.corrs.set(i, j, corr);
                }
                if (Double.isNaN(corr)) continue;
                sum += 1.0 - corr;
                ++num;
            }
        }
        return 0.5 * (sum / (double)num);
    }

    protected double ranking(int u, int j, int c) throws Exception {
        return this.predict(u, j, c, false);
    }

    protected SymmMatrix buildCorrs(boolean isUser) {
        Logs.debug("Build {} similarity matrix ...", (Object)(isUser ? "user" : "item"));
        int count = isUser ? this.numUsers : this.numItems;
        SymmMatrix corrs = new SymmMatrix(count);
        for (int i = 0; i < count; ++i) {
            SparseVector iv;
            SparseVector sparseVector = iv = isUser ? this.train.row(i) : this.train.column(i);
            if (iv.getCount() == 0) continue;
            for (int j = i + 1; j < count; ++j) {
                double sim;
                SparseVector jv;
                SparseVector sparseVector2 = jv = isUser ? this.train.row(j) : this.train.column(j);
                if (jv.getCount() == 0 || Double.isNaN(sim = this.correlation(iv, jv))) continue;
                corrs.set(i, j, sim);
            }
        }
        return corrs;
    }

    protected SymmMatrix buildCorrs(boolean isUser, carskit.data.structure.SparseMatrix train) {
        Logs.debug("Build {} similarity matrix ...", (Object)(isUser ? "user" : "item"));
        int count = isUser ? this.numUsers : this.numItems;
        SymmMatrix corrs = new SymmMatrix(count);
        for (int i = 0; i < count; ++i) {
            SparseVector iv;
            SparseVector sparseVector = iv = isUser ? train.row(i) : train.column(i);
            if (iv.getCount() == 0) continue;
            for (int j = i + 1; j < count; ++j) {
                double sim;
                SparseVector jv;
                SparseVector sparseVector2 = jv = isUser ? train.row(j) : train.column(j);
                if (jv.getCount() == 0 || Double.isNaN(sim = this.correlation(iv, jv))) continue;
                corrs.set(i, j, sim);
            }
        }
        return corrs;
    }

    protected void initModel() throws Exception {
        if (!(this.isItemSplitting || this.isUserSplitting || this.isCARSRecommender)) {
            this.train = rateDao.toTraditionalSparseMatrix(this.trainMatrix);
        } else if (!this.isCARSRecommender) {
            this.train = this.createTraditionalSparseMatrixBySplitting();
        }
    }

    protected void buildModel() throws Exception {
    }

    protected void postModel() throws Exception {
    }

    protected void saveModel() throws Exception {
    }

    protected void loadModel() throws Exception {
    }

    private void printAlgoConfig() {
        String algoInfo = this.toString();
        Class<?> cl = this.getClass();
        String algoConfig = cl.getAnnotation(Configuration.class).value();
        if (cl.isAnnotationPresent(AddConfiguration.class)) {
            String after;
            AddConfiguration add = cl.getAnnotation(AddConfiguration.class);
            String before = add.before();
            if (!Strings.isNullOrEmpty(before)) {
                algoConfig = before + ", " + algoConfig;
            }
            if (!Strings.isNullOrEmpty(after = add.after())) {
                algoConfig = algoConfig + ", " + after;
            }
        }
        if (!algoInfo.isEmpty()) {
            if (!algoConfig.isEmpty()) {
                Logs.debug("{}: [{}] = [{}]", this.algoName, algoConfig, algoInfo);
            } else {
                Logs.debug("{}: {}", this.algoName, algoInfo);
            }
        }
    }

    protected double g(double x) {
        return 1.0 / (1.0 + Math.exp(-x));
    }

    protected double gd(double x) {
        return this.g(x) * this.g(-x);
    }

    protected void checkBinary() {
        if (binThold < 0.0f) {
            Logs.error("val.binary.threshold={}, ratings must be binarized first! Try set a non-negative value.", (Object)Float.valueOf(binThold));
            System.exit(-1);
        }
    }

    @Override
    public void run() {
        try {
            this.execute();
        }
        catch (Exception e) {
            Logs.error(e.getMessage());
            e.printStackTrace();
        }
    }

    static {
        params = new HashMap<String, List<Float>>();
        verbose = true;
        earlyStopMeasure = null;
        isSaveModel = false;
        smallValue = 0.01;
        resetStatics = true;
    }

    public static enum Measure {
        MAE,
        RMSE,
        NMAE,
        rMAE,
        rRMSE,
        MPE,
        Perplexity,
        D5,
        D10,
        DN,
        Pre5,
        Pre10,
        PreN,
        Rec5,
        Rec10,
        RecN,
        MAP5,
        MAP10,
        MAPN,
        MRR5,
        MRR10,
        MRRN,
        NDCG5,
        NDCG10,
        NDCGN,
        AUC5,
        AUC10,
        AUCN,
        TrainTime,
        TestTime,
        Loss;

    }
}

