/*
 * Decompiled with CFR 0.152.
 */
package carskit.alg.cars.transformation.prefiltering.splitting;

import carskit.alg.cars.transformation.prefiltering.splitting.ContextualSplitting;
import carskit.data.structure.SparseMatrix;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.HashMultiset;
import com.google.common.collect.Multimap;
import com.google.common.collect.Table;
import com.google.common.primitives.Doubles;
import happy.coding.io.Logs;
import java.util.Collection;
import java.util.List;
import org.apache.commons.math3.stat.inference.TTest;

public class ItemSplitting
implements ContextualSplitting {
    protected static Multimap<Integer, Integer> itemRatingList;
    protected static Multimap<Integer, Integer> condContextsList;
    protected static int startId;

    @Override
    public Table<Integer, Integer, Integer> split(SparseMatrix sm, int min) {
        HashBasedTable<Integer, Integer, Integer> datatable = HashBasedTable.create();
        for (Integer j : itemRatingList.keySet()) {
            Collection<Integer> uis = itemRatingList.get(j);
            double maxt = Double.MIN_VALUE;
            int splitcond = -1;
            for (Integer cond : condContextsList.keySet()) {
                double t;
                TTest tt;
                double p;
                Collection<Integer> ctx = condContextsList.get(cond);
                HashMultiset rate1 = HashMultiset.create();
                HashMultiset rate2 = HashMultiset.create();
                for (Integer ui : uis) {
                    List<Integer> uctx = sm.getColumns(ui);
                    for (Integer c : uctx) {
                        double rate = sm.get(ui, c);
                        if (ctx.contains(c)) {
                            rate1.add((Object)rate);
                            continue;
                        }
                        rate2.add((Object)rate);
                    }
                }
                double[] drate1 = Doubles.toArray(rate1);
                double[] drate2 = Doubles.toArray(rate2);
                if (drate1.length < min || drate2.length < min || !((p = (tt = new TTest()).tTest(drate1, drate2)) < 0.05) || !((t = tt.t(drate1, drate2)) > maxt)) continue;
                splitcond = cond;
                maxt = t;
            }
            if (splitcond == -1) continue;
            ++startId;
            Collection<Integer> ctx = condContextsList.get(splitcond);
            for (Integer c : ctx) {
                int newid;
                datatable.put(j, c, newid);
            }
        }
        Logs.info(datatable.rowKeySet().size() + " items have been splitted.");
        return datatable;
    }

    public ItemSplitting(int startId, Multimap<Integer, Integer> condContextsList, Multimap<Integer, Integer> itemRatingList) {
        ItemSplitting.startId = startId;
        ItemSplitting.itemRatingList = itemRatingList;
        ItemSplitting.condContextsList = condContextsList;
    }
}

