/*
 * Decompiled with CFR 0.152.
 */
package carskit.alg.cars.adaptation.independent;

import carskit.data.structure.SparseMatrix;
import carskit.generic.TensorRecommender;
import librec.data.DenseMatrix;
import librec.data.TensorEntry;

public class CPTF
extends TensorRecommender {
    private DenseMatrix[] M;

    public CPTF(SparseMatrix trainMatrix, SparseMatrix testMatrix, int fold) throws Exception {
        super(trainMatrix, testMatrix, fold);
    }

    @Override
    protected void initModel() throws Exception {
        this.M = new DenseMatrix[numDimensions];
        for (int d = 0; d < numDimensions; ++d) {
            this.M[d] = new DenseMatrix(dimensions[d], numFactors);
            this.M[d].init(1.0, 0.1);
        }
    }

    protected void normalize(int d) {
        for (int f = 0; f < numFactors; ++f) {
            int r;
            double norm = 0.0;
            for (r = 0; r < this.M[d].numRows(); ++r) {
                norm += Math.pow(this.M[d].get(r, f), 2.0);
            }
            norm = Math.sqrt(norm);
            for (r = 0; r < this.M[d].numRows(); ++r) {
                this.M[d].set(r, f, this.M[d].get(r, f) / norm);
            }
        }
    }

    @Override
    protected void buildModel() throws Exception {
        for (int iter = 1; iter <= numIters; ++iter) {
            this.loss = 0.0;
            for (TensorEntry te : this.trainTensor) {
                int[] keys = te.keys();
                double rate = te.get();
                if (rate <= 0.0) continue;
                double pred = this.predict(keys);
                double e = rate - pred;
                this.loss += e * e;
                for (int f = 0; f < numFactors; ++f) {
                    double sgd = 1.0;
                    for (int dd = 0; dd < numDimensions; ++dd) {
                        sgd *= this.M[dd].get(keys[dd], f);
                    }
                    for (int d = 0; d < numDimensions; ++d) {
                        double df = this.M[d].get(keys[d], f);
                        double gdf = sgd / df * e;
                        this.M[d].add(keys[d], f, this.lRate * (gdf - (double)reg * df));
                        this.loss += (double)reg * df * df;
                    }
                }
            }
            this.loss *= 0.5;
            if (this.isConverged(iter)) break;
        }
    }

    @Override
    protected double predict(int u, int j, int c) throws Exception {
        double pred = 0.0;
        int[] keys = this.getKeys(u, j, c);
        for (int f = 0; f < numFactors; ++f) {
            double prod = 1.0;
            for (int d = 0; d < numDimensions; ++d) {
                prod *= this.M[d].get(keys[d], f);
            }
            pred += prod;
        }
        if (pred > maxRate) {
            pred = maxRate;
        }
        if (pred < minRate) {
            pred = minRate;
        }
        return pred;
    }

    @Override
    protected double predict(int[] keys) {
        double pred = 0.0;
        for (int f = 0; f < numFactors; ++f) {
            double prod = 1.0;
            for (int d = 0; d < numDimensions; ++d) {
                prod *= this.M[d].get(keys[d], f);
            }
            pred += prod;
        }
        return pred;
    }
}

