/*
 * Decompiled with CFR 0.152.
 */
package carskit.alg.cars.adaptation.dependent.dev;

import carskit.alg.cars.adaptation.dependent.CSLIM;
import carskit.data.setting.Configuration;
import carskit.data.structure.SparseMatrix;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import happy.coding.io.Lists;
import happy.coding.io.Logs;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import librec.data.DenseMatrix;
import librec.data.MatrixEntry;
import librec.data.SparseVector;
import librec.data.SymmMatrix;

@Configuration(value="binThold, knn, regLw2, regLw1, regLc2, regLc1, similarity, iters, rc")
public class CSLIM_CUCI
extends CSLIM {
    private DenseMatrix W;
    private Multimap<Integer, Integer> itemNNs;
    private List<Integer> allItems;

    public CSLIM_CUCI(SparseMatrix trainMatrix, SparseMatrix testMatrix, int fold) {
        super(trainMatrix, testMatrix, fold);
        isRankingPred = true;
        this.isCARSRecommender = false;
        this.algoName = "CSLIM_CUCI";
        this.regLw1 = algoOptions.getFloat("-lw1");
        this.regLw2 = algoOptions.getFloat("-lw2");
        this.regLc1 = algoOptions.getFloat("-lc1");
        this.regLc2 = algoOptions.getFloat("-lc2");
        knn = algoOptions.getInt("-k");
        this.als = algoOptions.getInt("-als");
    }

    @Override
    protected void initModel() throws Exception {
        super.initModel();
        this.cuDev = new DenseMatrix(this.numUsers, numConditions);
        this.cuDev.init();
        this.ciDev = new DenseMatrix(this.numItems, numConditions);
        this.ciDev.init();
        this.W = new DenseMatrix(this.numItems, this.numItems);
        this.W.init();
        this.userCache = this.train.rowCache(cacheSpec);
        if (knn > 0) {
            SymmMatrix itemCorrs = this.buildCorrs(false);
            this.itemNNs = HashMultimap.create();
            for (int j = 0; j < this.numItems; ++j) {
                this.W.set(j, j, 0.0);
                Map<Integer, Double> nns = itemCorrs.row(j).toMap();
                if (knn > 0 && knn < nns.size()) {
                    List<Map.Entry<Integer, Double>> sorted = Lists.sortMap(nns, true);
                    List<Map.Entry<Integer, Double>> subset = sorted.subList(0, knn);
                    nns.clear();
                    for (Map.Entry<Integer, Double> kv : subset) {
                        nns.put(kv.getKey(), kv.getValue());
                    }
                }
                for (Map.Entry<Integer, Double> en : nns.entrySet()) {
                    this.itemNNs.put(j, en.getKey());
                }
            }
        } else {
            this.allItems = this.train.columns();
            for (int j = 0; j < this.numItems; ++j) {
                this.W.set(j, j, 0.0);
            }
        }
    }

    @Override
    protected void buildModel() throws Exception {
        for (int iter = 1; iter <= numIters; ++iter) {
            this.loss = 0.0;
            for (MatrixEntry me : this.trainMatrix) {
                int ui = me.row();
                int u = rateDao.getUserIdFromUI(ui);
                int j = rateDao.getItemIdFromUI(ui);
                int c = me.column();
                double rujc = me.get();
                double pred = this.predict(u, j, c, true, j);
                double eujc = rujc - pred;
                this.loss += eujc * eujc;
                List<Integer> nns = knn > 0 ? this.itemNNs.get(j) : this.allItems;
                Collection conditions = rateDao.getContextConditionsList().get(c);
                double dev_cu = 0.0;
                double dev_ci = 0.0;
                for (Integer cond : conditions) {
                    dev_cu += this.cuDev.get(u, cond);
                    dev_ci += this.ciDev.get(j, cond);
                }
                SparseVector Ru = (SparseVector)this.userCache.get(u);
                double sum_w = 0.0;
                Iterator i$ = nns.iterator();
                while (i$.hasNext()) {
                    int k = (Integer)i$.next();
                    double update = this.W.get(k, j);
                    sum_w += update;
                    this.loss += (double)this.regLw2 * update * update + (double)this.regLw1 * update;
                    double delta_w = eujc * (Ru.get(k) + dev_cu + dev_ci) - (double)this.regLw2 * update - (double)this.regLw1;
                    this.W.set(k, j, update += this.lRate * delta_w);
                }
                for (Integer cond : conditions) {
                    double update_u = this.cuDev.get(u, cond);
                    double update_i = this.ciDev.get(j, cond);
                    this.loss += (double)this.regLc2 * update_u * update_u + (double)this.regLc1 * update_u;
                    this.loss += (double)this.regLc2 * update_i * update_i + (double)this.regLc1 * update_i;
                    double delta_cu = eujc * sum_w - (double)this.regLc2 * update_u - (double)this.regLc1;
                    double delta_ci = eujc * sum_w - (double)this.regLc2 * update_i - (double)this.regLc1;
                    this.cuDev.set(u, cond, update_u += this.lRate * delta_cu);
                    this.ciDev.set(j, cond, update_i += this.lRate * delta_ci);
                }
            }
        }
    }

    protected double predict(int u, int j, int c, boolean exclude, int excluded_item) throws Exception {
        List<Integer> nns = knn > 0 ? this.itemNNs.get(j) : this.allItems;
        SparseVector Ru = (SparseVector)this.userCache.get(u);
        Collection conditions = rateDao.getContextConditionsList().get(c);
        double dev_cu = 0.0;
        double dev_ci = 0.0;
        for (Integer cond : conditions) {
            dev_cu += this.cuDev.get(u, cond);
            dev_ci += this.ciDev.get(j, cond);
        }
        double pred = 0.0;
        Iterator i$ = nns.iterator();
        while (i$.hasNext()) {
            int k = (Integer)i$.next();
            if (!Ru.contains(k) || exclude && k == excluded_item) continue;
            double ruk = Ru.get(k);
            pred += (ruk + dev_cu + dev_ci) * this.W.get(k, j);
        }
        return pred;
    }

    @Override
    protected double predict(int u, int j, int c) throws Exception {
        return this.predict(u, j, c, true, j);
    }

    @Override
    protected boolean isConverged(int iter) {
        double delta_loss = this.last_loss - this.loss;
        this.last_loss = this.loss;
        if (verbose) {
            Logs.debug("{}{} iter {}: loss = {}, delta_loss = {}", this.algoName, this.foldInfo, iter, this.loss, delta_loss);
        }
        return iter > 1 ? delta_loss < 1.0E-5 : false;
    }
}

