/*
 * Decompiled with CFR 0.152.
 */
package carskit.alg.baseline.cf;

import carskit.data.structure.SparseMatrix;
import carskit.generic.Recommender;
import librec.data.DenseMatrix;
import librec.data.SparseVector;

public class SlopeOne
extends Recommender {
    private DenseMatrix devMatrix;
    private DenseMatrix cardMatrix;

    public SlopeOne(SparseMatrix trainMatrix, SparseMatrix testMatrix, int fold) {
        super(trainMatrix, testMatrix, fold);
        this.algoName = "SlopeOne";
    }

    @Override
    protected void initModel() throws Exception {
        super.initModel();
        this.devMatrix = new DenseMatrix(this.numItems, this.numItems);
        this.cardMatrix = new DenseMatrix(this.numItems, this.numItems);
    }

    @Override
    protected void buildModel() throws Exception {
        for (int u = 0; u < this.numUsers; ++u) {
            int[] items;
            SparseVector uv = this.train.row(u);
            for (int i : items = uv.getIndex()) {
                double rui = uv.get(i);
                for (int j : items) {
                    if (i == j) continue;
                    double ruj = uv.get(j);
                    this.devMatrix.add(i, j, rui - ruj);
                    this.cardMatrix.add(i, j, 1.0);
                }
            }
        }
        for (int i = 0; i < this.numItems; ++i) {
            for (int j = 0; j < this.numItems; ++j) {
                double card = this.cardMatrix.get(i, j);
                if (!(card > 0.0)) continue;
                double sum = this.devMatrix.get(i, j);
                this.devMatrix.set(i, j, sum / card);
            }
        }
    }

    @Override
    protected double predict(int u, int j, int c) throws Exception {
        if (this.isUserSplitting) {
            int n = u = this.userIdMapper.contains(u, c) ? (Integer)this.userIdMapper.get(u, c) : u;
        }
        if (this.isItemSplitting) {
            j = this.itemIdMapper.contains(j, c) ? (Integer)this.itemIdMapper.get(j, c) : j;
        }
        return this.predict(u, j);
    }

    @Override
    protected double predict(int u, int j) throws Exception {
        SparseVector uv = this.train.row(u, j);
        double preds = 0.0;
        double cards = 0.0;
        for (int i : uv.getIndex()) {
            double card = this.cardMatrix.get(j, i);
            if (!(card > 0.0)) continue;
            preds += (this.devMatrix.get(j, i) + uv.get(i)) * card;
            cards += card;
        }
        return cards > 0.0 ? preds / cards : this.globalMean;
    }
}

