from _typeshed import Incomplete

# Manually added resource imports to provide type hints
from cmq.aws.resource.address import address
from cmq.aws.resource.alarm import alarm
from cmq.aws.resource.cloudformation import cloudformation
from cmq.aws.resource.cloudtrail import cloudtrail
from cmq.aws.resource.dynamodb import dynamodb
from cmq.aws.resource.elasticache_parameter_group import elasticache_parameter_group
from cmq.aws.resource.elasticache_subnet_group import elasticache_subnet_group
from cmq.aws.resource.elasticache import elasticache
from cmq.aws.resource.function import function
from cmq.aws.resource.kinesis import kinesis
from cmq.aws.resource.kms import kms
from cmq.aws.resource.log_event import log_event
from cmq.aws.resource.log_stream import log_stream
from cmq.aws.resource.log import log
from cmq.aws.resource.metric import metric
from cmq.aws.resource.rds_parameter_group import rds_parameter_group
from cmq.aws.resource.rds import rds
from cmq.aws.resource.resource_explorer import resource_explorer
from cmq.aws.resource.resource_group import resource_group
from cmq.aws.resource.role import role
from cmq.aws.resource.s3_object import s3_object
from cmq.aws.resource.s3 import s3
from cmq.aws.resource.sns import sns
from cmq.aws.resource.sqs import sqs
from cmq.aws.resource.user import user
from cmq.aws.resource.user_key import user_key


class ResourceInterface:
    def __init__(self, parent) -> None: ...
    def __call__(self): ...
    def root(self) -> ResourceInterface: ...
    def traverse(self, context) -> None: ...
    def config_env(self) -> None: ...
    def context(self, status) -> None: ...
    def progress(self, resources) -> None: ...

    # Useful methods for managing resources
    def attr(self, *args) -> ResourceInterface: ...
    def filter(self, func) -> ResourceInterface: ...
    def transform(self, key, func) -> ResourceInterface: ...
    def eq(self, key, value) -> ResourceInterface: ...
    def ne(self, key, value) -> ResourceInterface: ...
    def in_(self, key, value) -> ResourceInterface: ...
    def contains(self, key, value) -> ResourceInterface: ...
    def not_contains(self, key, value) -> ResourceInterface: ...
    def starts_with(self, key, value) -> ResourceInterface: ...
    def ends_with(self, key, value) -> ResourceInterface: ...
    def gt(self, key, value) -> ResourceInterface: ...
    def lt(self, key, value) -> ResourceInterface: ...

    # Manually added resource to provide type hints
    def address(self) -> address: ...
    def alarm(self) -> alarm: ...
    def cloudformation(self) -> cloudformation: ...
    def cloudtrail(self) -> cloudtrail: ...
    def dynamodb(self) -> dynamodb: ...
    def elasticache_parameter_group(self) -> elasticache_parameter_group: ...
    def elasticache_subnet_group(self) -> elasticache_subnet_group: ...
    def elasticache(self) -> elasticache: ...
    def function(self) -> function: ...
    def kinesis(self) -> kinesis: ...
    def kms(self) -> kms: ...
    def log_event(self) -> log_event: ...
    def log_stream(self) -> log_stream: ...
    def log(self) -> log: ...
    def metric(self) -> metric: ...
    def rds_parameter_group(self) -> rds_parameter_group: ...
    def rds(self) -> rds: ...
    def resource_explorer(self) -> resource_explorer: ...
    def resource_group(self) -> resource_group: ...
    def role(self) -> role: ...
    def s3_object(self) -> s3_object: ...
    def s3(self) -> s3: ...
    def sns(self) -> sns: ...
    def sqs(self) -> sqs: ...
    def user(self) -> user: ...
    def user_key(self) -> user_key: ...
    def ec2(self) -> user_key: ...

class PagedResourceInterface(ResourceInterface):
    def get_paged_results(self, page) -> list: ...
    def paginate(self, context) -> list: ...

class Resource(PagedResourceInterface):
    def list(self) -> list: ...
    def dict(self) -> dict: ...
    def csv(self, flat=False) -> str: ...
    def do(self, action: callable) -> None: ...

class Session(Resource):
    console: Incomplete
    def context(self, status): ...
    def get_sessions() -> list: ...
    def get_session_context(self, resource: dict) -> dict: ...
    def traverse(self, context) -> None: ...
