/*
 * Decompiled with CFR 0.152.
 */
package technology.tabula;

import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;
import technology.tabula.CellPosition;
import technology.tabula.Rectangle;
import technology.tabula.RectangularTextContainer;
import technology.tabula.TextChunk;
import technology.tabula.extractors.ExtractionAlgorithm;

public class Table
extends Rectangle {
    private final String extractionMethod;
    private int rowCount = 0;
    private int colCount = 0;
    private int pageNumber = 0;
    final TreeMap<CellPosition, RectangularTextContainer> cells = new TreeMap();
    private List<List<RectangularTextContainer>> memoizedRows = null;

    public static final Table empty() {
        return new Table("");
    }

    private Table(String extractionMethod) {
        this.extractionMethod = extractionMethod;
    }

    public Table(ExtractionAlgorithm extractionAlgorithm) {
        this(extractionAlgorithm.toString());
    }

    public int getRowCount() {
        return this.rowCount;
    }

    public int getColCount() {
        return this.colCount;
    }

    public int getPageNumber() {
        return this.pageNumber;
    }

    public void setPageNumber(int pageNumber) {
        this.pageNumber = pageNumber;
    }

    public String getExtractionMethod() {
        return this.extractionMethod;
    }

    public void add(RectangularTextContainer chunk, int row, int col) {
        this.merge(chunk);
        this.rowCount = Math.max(this.rowCount, row + 1);
        this.colCount = Math.max(this.colCount, col + 1);
        CellPosition cp = new CellPosition(row, col);
        RectangularTextContainer old = this.cells.get(cp);
        if (old != null) {
            chunk.merge(old);
        }
        this.cells.put(cp, chunk);
        this.memoizedRows = null;
    }

    public List<List<RectangularTextContainer>> getRows() {
        if (this.memoizedRows == null) {
            this.memoizedRows = this.computeRows();
        }
        return this.memoizedRows;
    }

    private List<List<RectangularTextContainer>> computeRows() {
        ArrayList<List<RectangularTextContainer>> rows = new ArrayList<List<RectangularTextContainer>>();
        for (int i = 0; i < this.rowCount; ++i) {
            ArrayList<RectangularTextContainer> lastRow = new ArrayList<RectangularTextContainer>();
            rows.add(lastRow);
            for (int j = 0; j < this.colCount; ++j) {
                RectangularTextContainer cell = this.cells.get(new CellPosition(i, j));
                lastRow.add(cell != null ? cell : TextChunk.EMPTY);
            }
        }
        return rows;
    }

    public RectangularTextContainer getCell(int i, int j) {
        RectangularTextContainer cell = this.cells.get(new CellPosition(i, j));
        return cell != null ? cell : TextChunk.EMPTY;
    }
}

