# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['beetsplug', 'beetsplug.bandcamp']

package_data = \
{'': ['*']}

install_requires = \
['cached-property>=1.5.2,<2.0.0', 'pycountry>=20.7.3,<21.0.0', 'requests']

setup_kwargs = {
    'name': 'beetcamp',
    'version': '0.10.1',
    'description': 'Bandcamp autotagger source for beets (http://beets.io).',
    'long_description': "[![image](http://img.shields.io/pypi/v/beetcamp.svg)](https://pypi.python.org/pypi/beetcamp)\n[![Quality Gate Status](https://sonarcloud.io/api/project_badges/measure?project=snejus_beets-bandcamp&metric=alert_status)](https://sonarcloud.io/dashboard?id=snejus_beets-bandcamp)\n\nPlug-in for [beets](https://github.com/beetbox/beets) to use Bandcamp as\nan autotagger source.\n\nThis is an up-to-date fork of [unrblt/beets-bandcamp](https://github.com/unrblt/beets-bandcamp)\n\n# Installation\n\n## Recommended method\n\n1. Install `beets` with `pipx` so that it's isolated from your system and other projects\n```bash\npipx install beets\n```\n\n2. Inject `beetcamp` and other dependencies that you need\n```bash\npipx inject beets beetcamp [python-mpd2 ...]\n```\nand add `bandcamp` to the `plugins` list to your beets configuration file.\n\n## Otherwise\n\nNavigate to your `beets` virtual environment and install the plug-in with\n\n```bash\n   pip install beetcamp\n```\n\n\n# Configuration\n\n## Example\n\n```yaml\nbandcamp:\n    preferred_media: Vinyl,CD,Cassette\n    include_digital_only_tracks: true\n    search_max: 5\n    art: true\n    exclude_extra_fields:\n      - lyrics\n      - comments\n```\n\n---\n\n#### `preferred_media`\n\n- Type: **string**\n- Default: `Digital`\n\nA comma-separated list of media to prioritise when fetching albums. For example:\n`preferred_media: Vinyl,Cassette` will ignore `CD`, check for a `Vinyl`, and then for a\n`Cassette`, in the end defaulting to `Digital` (always available) if none of the two are\nfound. Any combination of the following is supported: `Vinyl`, `CD`, `Cassette`,\n`Digital`.\n\n---\n\n#### `include_digital_only_tracks`\n\n- Type: **bool**\n- Default: `true`\n\nFor media that isn't `Digital Media`, include all tracks, even if their titles contain\n**digital only** (or alike).\n\nIf you have `False` here, then, for example, a `Vinyl` media of an album will only include\nthe tracks that are supposed to be found in that media.\n\n---\n\n#### `search_max`\n\n- Type: **int**\n- Default: `10`.\n\nMaximum number of items to fetch through search queries. Depending on the specificity of\nqueries and whether a suitable match is found, it could fetch 50+ results which may take a\nminute, so it'd make sense to bound this to some sort of sensible number. Usually, a match\nis found among the first 5 items.\n\n---\n\n#### `art`\n\n- Type: **bool**\n- Default: `false`.\n\nAdd a source to the\n[FetchArt](http://beets.readthedocs.org/en/latest/plugins/fetchart.html) plug-in to\ndownload album art for Bandcamp albums (requires `FetchArt` plug-in enabled).\n\n---\n\n#### `exclude_extra_fields`\n\n- Type: **list**\n- Default: _`empty`_\n\nThe data that is added **after** the core auto tagging process is considered extra:\n(currently) `lyrics` and `comments` (release description) fields (see [the data\ntable](#currently-supported--returned-data) for the complete list). Since there yet isn't\nan easy way to preview them before they get applied, you can ignore them if you find them\nirrelevant or inaccurate.\n\nFor example, if you wanted to ignore all the goodies you can specify\n```yaml\nbandcamp:\n    search_max: 5\n    exclude_extra_fields:\n      - lyrics\n      - comments\n```\n\n# Usage\n\nThis plug-in uses the Bandcamp URL as id (for both albums and songs). If no matching\nrelease is found when importing you can select `enter Id` and paste the Bandcamp URL.\n\n## Currently supported / returned data\n\n| field            | is extra | singleton track | album track | album |\n|-----------------:|:--------:|:---------------:|:-----------:|:-----:|\n| `album`          |          | ✔~              |             | ✔     |\n| `album_id`       |          |                 |             | ✔     |\n| `albumartist`    |          | ✔               | ✔           | ✔     |\n| `albumstatus`    |          | ✔~              |             | ✔     |\n| `albumtype`      |          | ✔~              |             | ✔     |\n| `artist`         |          | ✔               | ✔           | ✔     |\n| `artist_id`      |          | ✔               | ✔           |       |\n| `catalognum`     |          | ✔~              |             | ✔     |\n| + `comments`     | ✔        | ✔               | ✔           |       |\n| `country`        |          | ✔~              |             | ✔     |\n| `day`            |          | ✔~              |             | ✔     |\n| `disctitle`      |          | ✔~              | ✔           |       |\n| `image`          |          | ✔               | ✔           | ✔     |\n| `index`          |          | ✔               | ✔           |       |\n| `label`          |          | ✔~              | ✔           | ✔     |\n| `length`         |          | ✔               | ✔           |       |\n| `lyrics`         | ✔        | ✔               | ✔           |       |\n| `media`          |          | ✔~              | ✔           | ✔     |\n| `medium`         |          | ✔~              | ✔           |       |\n| `mediums`        |          |                 |             | ✔     |\n| * `medium_index` |          | ✔~              | ✔           |       |\n| * `medium_total` |          | ✔~              | ✔           |       |\n| `month`          |          | ✔~              |             | ✔     |\n| `title`          |          | ✔               | ✔           |       |\n| `track_alt`      |          | ✔               | ✔           |       |\n| `va`             |          |                 |             | ✔     |\n| `year`           |          | ✔~              |             | ✔     |\n\n**\\+** `comments` field gets populated with the release description.\n\n**\\*** are likely to be inaccurate, since Bandcamp does not provide this data,\n  therefore they depend on artists providing some clues in the descriptions of\n  their releases. This is only relevant if you have `per_disc_numbering` set to\n  `True` in the global beets configuration.\n\n**\\~** These singleton fields are available if you use `beets` version `1.5` or higher.\n",
    'author': 'Šarūnas Nejus',
    'author_email': 'snejus@pm.me',
    'maintainer': 'None',
    'maintainer_email': 'None',
    'url': 'https://github.com/snejus/beetcamp',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.6,<3.10',
}


setup(**setup_kwargs)
