# -*- coding: UTF-8 -*-

"""
Emoticons and Emoji data dictonary
"""

EMOTICONS = {
    ":‑)": "happy_face_or_smiley_1",
    ":)": "happy_face_or_smiley_2",
    ":-]": "happy_face_or_smiley_3",
    ":]": "happy_face_or_smiley_4",
    ":-3": "happy_face_smiley_5",
    ":3": "happy_face_smiley_6",
    ":->": "happy_face_smiley_7",
    ":>": "happy_face_smiley_8",
    "8-)": "happy_face_smiley_9",
    ":o)": "happy_face_smiley_10",
    ":-}": "happy_face_smiley_11",
    ":}": "happy_face_smiley_12",
    ":-)": "happy_face_smiley_13",
    "C:": "happy_face_smiley_14",
    ":^)": "happy_face_smiley_15",
    "=]": "happy_face_smiley_16",
    "=)": "happy_face_smiley_17",
    "c:": "happy_face_smiley_14",
    ":‑D": "laughing_big_grin_or_laugh_with_glasses_1",
    ":D": "laughing_big_grin_or_laugh_with_glasses_2",
    "8‑D": "laughing_big_grin_or_laugh_with_glasses_3",
    "8D": "laughing_big_grin_or_laugh_with_glasses_4",
    "X‑D": "laughing_big_grin_or_laugh_with_glasses_5",
    "XD": "laughing_big_grin_or_laugh_with_glasses_6",
    "=D": "laughing_big_grin_or_laugh_with_glasses_7",
    "xD": "laughing_big_grin_or_laugh_with_glasses_8",
    "=3": "laughing_big_grin_or_laugh_with_glasses_9",
    "B^D": "laughing_big_grin_or_laugh_with_glasses_10",
    ":-))": "very_happy",
    ":‑(": "frown_sad_andry_or_pouting_1",
    ":-(": "frown_sad_andry_or_pouting_2",
    ":(": "frown_sad_andry_or_pouting_3",
    ":‑c": "frown_sad_andry_or_pouting_4",
    ":c": "frown_sad_andry_or_pouting_5",
    ":‑<": "frown_sad_andry_or_pouting_6",
    ":<": "frown_sad_andry_or_pouting_7",
    ":‑[": "frown_sad_andry_or_pouting_8",
    ":[": "frown_sad_andry_or_pouting_9",
    ":-||": "frown_sad_andry_or_pouting_10",
    ">:[": "frown_sad_andry_or_pouting_11",
    ":{": "frown_sad_andry_or_pouting_12",
    ":@": "frown_sad_andry_or_pouting_13",
    ">:(": "frown_sad_andry_or_pouting_14",
    ":'‑(": "crying_1",
    ":'(": "crying_3",
    ":'‑)": "tears_of_happiness_1",
    ":')": "tears_of_happiness_2",
    "D‑':": "horror",
    "D:<": "disgust",
    "D:": "sadness",
    "D8": "great_dismay_1",
    "D;": "great_dismay_2",
    "D=": "great_dismay_3",
    "DX": "great_dismay_4",
    ":‑O": "surprise_5",
    ":O": "surprise_6",
    ":‑o": "surprise_7",
    ":o": "surprise_8",
    ":-0": "shock",
    "8‑0": "yawn_1",
    ">:O": "yawn_2",
    ":-*": "kiss",
    ":*": "kiss_2",
    ":X": "kiss_3",
    ";‑)": "wink_or_smirk_1",
    ";)": "wink_or_smirk_2",
    "*-)": "wink_or_smirk_3",
    "*)": "wink_or_smirk_4",
    ";‑]": "wink_or_smirk_5",
    ";]": "wink_or_smirk_6",
    ";^)": "wink_or_smirk_7",
    ":‑,": "wink_or_smirk_8",
    ";D": "wink_or_smirk_9",
    ":‑P": "tongue_sticking_out_cheeky_playful_or_blowing_a_raspberry_1",
    ":P": "tongue_sticking_out_cheeky_playful_or_blowing_a_raspberry_2",
    "X‑P": "tongue_sticking_out_cheeky_playful_or_blowing_a_raspberry_3",
    "XP": "tongue_sticking_out_cheeky_playful_or_blowing_a_raspberry_4",
    ":‑Þ": "tongue_sticking_out_cheeky_playful_or_blowing_a_raspberry_5",
    ":Þ": "tongue_sticking_out_cheeky_playful_or_blowing_a_raspberry_6",
    ":b": "tongue_sticking_out_cheeky_playful_or_blowing_a_raspberry_7",
    "d:": "tongue_sticking_out_cheeky_playful_or_blowing_a_raspberry_8",
    "=p": "tongue_sticking_out_cheeky_playful_or_blowing_a_raspberry_9",
    ">:P": "tongue_sticking_out_cheeky_playful_or_blowing_a_raspberry_10",
    ":‑/": "skeptical_annoyed_undecided_uneasy_or_hesitant_1",
    ":/": "skeptical_annoyed_undecided_uneasy_or_hesitant_2",
    ":-[.]": "skeptical_annoyed_undecided_uneasy_or_hesitant_3",
    ">:[()]": "skeptical_annoyed_undecided_uneasy_or_hesitant_4",
    ">:/": "skeptical_annoyed_undecided_uneasy_or_hesitant_5",
    ":[()]": "skeptical_annoyed_undecided_uneasy_or_hesitant_6",
    "=/": "skeptical_annoyed_undecided_uneasy_or_hesitant_7",
    "=[()]": "skeptical_annoyed_undecided_uneasy_or_hesitant_8",
    ":L": "skeptical_annoyed_undecided_uneasy_or_hesitant_9",
    "=L": "skeptical_annoyed_undecided_uneasy_or_hesitant_10",
    ":S": "skeptical_annoyed_undecided_uneasy_or_hesitant_11",
    ":‑|": "straight_face_1",
    ":|": "straight_face_2",
    ":$": "embarrassed_or_blushing_1",
    ":-$": "embarrassed_or_blushing_2",
    ":‑x": "sealed_lips_or_wearing_braces_or_tongue-tied_1",
    ":x": "sealed_lips_or_wearing_braces_or_tongue-tied_2",
    ":‑#": "sealed_lips_or_wearing_braces_or_tongue-tied_3",
    ":#": "sealed_lips_or_wearing_braces_or_tongue-tied_4",
    ":‑&": "sealed_lips_or_wearing_braces_or_tongue-tied_5",
    ":&": "sealed_lips_or_wearing_braces_or_tongue-tied_6",
    "O:‑)": "angel_saint_or_innocent_1",
    "O:)": "angel_saint_or_innocent_2",
    "0:‑3": "angel_saint_or_innocent_3",
    "0:3": "angel_saint_or_innocent_4",
    "0:‑)": "angel_saint_or_innocent_5",
    "0:)": "angel_saint_or_innocent_6",
    ":‑b": "tongue_sticking_out_cheeky_playful_or_blowing_a_raspberry",
    "0;^)": "angel_saint_or_innocent",
    ">:‑)": "evil_or_devilish_1",
    ">:)": "evil_or_devilish_2",
    "}:‑)": "evil_or_devilish_3",
    "}:)": "evil_or_devilish_4",
    "3:‑)": "evil_or_devilish_5",
    "3:)": "evil_or_devilish_6",
    ">;)": "evil_or_devilish_7",
    "|;‑)": "cool",
    "|‑O": "bored",
    ":‑J": "tongue-in-cheek",
    "#‑)": "party_all_night",
    "%‑)": "drunk_or_confused_1",
    "%)": "drunk_or_confused_2",
    ":-###..": "being_sick_1",
    ":###..": "being_sick_2",
    "<:‑|": "dump",
    "(>_<)": "troubled_1",
    "(>_<)>": "troubled_2",
    "(';')": "baby",
    "(^^>``": "nervous_or_embarrassed_or_troubled_or_shy_or_sweat_drop_1",
    "(^_^;)": "nervous_or_embarrassed_or_troubled_or_shy_or_sweat_drop_2",
    "(-_-;)": "nervous_or_embarrassed_or_troubled_or_shy_or_sweat_drop_3",
    "(~_~;) (・.・;)": "nervous_or_embarrassed_or_troubled_or_shy_or_sweat_drop_4",
    "(-_-)zzz": "sleeping",
    "(^_-)": "wink",
    "(o|o)": "ultraman",
    "^_^": "joyful_1",
    "(^_^)/": "joyful_2",
    "(^O^)／": "joyful_3",
    "(^o^)／": "joyful_4",
    "(__)": "kowtow_as_a_sign_of_respect_or_dogeza_for_apology_1",
    "_(._.)_": "kowtow_as_a_sign_of_respect_or_dogeza_for_apology_2",
    "<(_ _)>": "kowtow_as_a_sign_of_respect_or_dogeza_for_apology_3",
    "<m(__)m>": "kowtow_as_a_sign_of_respect_or_dogeza_for_apology_4",
    "m(__)m": "kowtow_as_a_sign_of_respect_or_dogeza_for_apology_5",
    "m(_ _)m": "kowtow_as_a_sign_of_respect_or_dogeza_for_apology_5",
    "('_')": "sad_or_crying_1",
    "(/_;)": "sad_or_crying_2",
    "(T_T) (;_;)": "sad_or_crying_3",
    "(;_;": "sad_of_crying_4",
    "(;_:)": "sad_or_crying_5",
    "(;O;)": "sad_or_crying_6",
    "(:_;)": "sad_or_crying_7",
    "(ToT)": "sad_or_crying_8",
    ";_;": "sad_or_crying_1",
    ";-;": "sad_or_crying_2",
    ";n;": "sad_or_crying_3",
    "Q.Q": "sad_or_crying_4",
    "T.T": "sad_or_crying_5",
    "T_T": "sad_or_crying_6",
    "QQ": "sad_or_crying_7",
    "Q_Q": "sad_or_crying_8",
    "(-.-)": "shame_1",
    "(-_-)": "shame_2",
    "(一一)": "shame_3",
    "(；一_一)": "shame_4",
    "(=_=)": "tired_5",
    "(=^·^=)": "cat_1",
    "(=^··^=)": "cat_2",
    "=_^=\t": "cat_3",
    "(..)": "looking_down_1",
    "(._.)": "looking_down_2",
    "^m^": "giggling_with_hand_covering_mouth",
    ">^_^<": "normal_laugh_1",
    "<^!^>": "normal_laugh_2",
    "^/^": "normal_laugh_3",
    "（*^_^*）": "normal_laugh_4",
    "(^<^) (^.^)": "normal_laugh_5",
    "(^^)": "normal_laugh_10",
    "(^.^)": "normal_laugh_7",
    "(^_^.)": "normal_laugh_8",
    "(^_^)": "normal_laugh_9",
    "(^J^)": "normal_laugh_11",
    "(*^.^*)": "normal_laugh_12",
    "(^—^）": "normal_laugh_13",
    "(#^.^#)": "normal_laugh_14",
    "（^—^）": "waving_1",
    "(;_;)/~~~": "waving_2",
    "(^.^)/~~~": "waving_3",
    "(-_-)/~~~ ($··)/~~~": "waving_4",
    "(T_T)/~~~": "waving_5",
    "(ToT)/~~~": "waving_6",
    "(*^0^*)": "excited",
    "(*_*)": "amazed_1",
    "(*_*;": "amazed_2",
    "(+_+) (@_@)": "amazed_3",
    "(*^^)v": "laughing_cheerful_1",
    "(^_^)v": "laughing_cheerful_2",
    "((d[-_-]b))": "headphones_listening_to_music",
    '(-"-)': "worried_1",
    "(ーー;)": "worried_2",
    "(^0_0^)": "eyeglasses",
    "(＾ｖ＾)": "happy_1",
    "(＾ｕ＾)": "happy_2",
    "(^)o(^)": "happy_3",
    "(^O^)": "happy_4",
    "(^o^)": "happy_5",
    ")^o^(": "happy_6",
    "o_O": "surprised_1",
    "o_0": "surprised_2",
    "o.O": "surprised_6",
    "O_O": "surprised_4",
    "(o.o)": "surprised_5",
    "(*￣m￣)": "dissatisfied",
    "(‘A`)": "snubbed_or_deflated",
    "uwu": "otaku_tenderness_1",
    "UwU": "otaku_tenderness_2",
    "owo": "otaku_tenderness_3",
    "OwO": "otaku_tenderness_4",
    ">w<": "otaku_tenderness_5",
    ">W<": "otaku_tenderness_6",
    "^w^": "otaku_tenderness_7",
    "^W^": "otaku_tenderness_8",
}


def demoticonize(string, delimiters=(" _", "_ ")):
    """Replace emoticons with their corresponding text in the dictionary EMOTICONS"""
    for emoticon, text in EMOTICONS.items():
        string = string.replace(emoticon, f"{delimiters[0]}{text}{delimiters[1]}")
    return string


def emoticonize(string, delimiters=(" _", "_ ")):
    """Replace text in the dictionary EMOTICONS with their corresponding emoticons"""
    for emoticon, text in EMOTICONS.items():
        string = string.replace(f"{delimiters[0]}{text}{delimiters[1]}", emoticon)
    return string
