# coding: utf-8

"""
    NCBI Datasets API

    NCBI service to query and download biological sequence data across all domains of life from NCBI databases.  # noqa: E501

    The version of the OpenAPI document: v1alpha
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from ncbi.datasets.api_client import ApiClient
from ncbi.datasets.exceptions import (
    ApiTypeError,
    ApiValueError
)


class AssemblyDatasetDescriptorsApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def assembly_descriptors_by_accession(self, assembly_accession, **kwargs):  # noqa: E501
        """Assembly descriptions by assembly accession  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.assembly_descriptors_by_accession(assembly_accession, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str assembly_accession: NCBI Assembly accession (required)
        :param int cutoff: Limit the number of results for the above query term.
        :param str limit: Limit the number of returned results (\"all\", \"none\", otherwise an integer value).
        :param bool filters_refseq_only: If true, only return RefSeq (GCF_) assemblies.
        :param bool tax_exact_match: If true, only return assemblies with the given NCBI Taxonomy ID, or name. Otherwise, assemblies from taxonomy subtree are included, too. Ignored for assembly_accession request.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: V1alpha1AssemblyDatasetDescriptors
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.assembly_descriptors_by_accession_with_http_info(assembly_accession, **kwargs)  # noqa: E501

    def assembly_descriptors_by_accession_with_http_info(self, assembly_accession, **kwargs):  # noqa: E501
        """Assembly descriptions by assembly accession  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.assembly_descriptors_by_accession_with_http_info(assembly_accession, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str assembly_accession: NCBI Assembly accession (required)
        :param int cutoff: Limit the number of results for the above query term.
        :param str limit: Limit the number of returned results (\"all\", \"none\", otherwise an integer value).
        :param bool filters_refseq_only: If true, only return RefSeq (GCF_) assemblies.
        :param bool tax_exact_match: If true, only return assemblies with the given NCBI Taxonomy ID, or name. Otherwise, assemblies from taxonomy subtree are included, too. Ignored for assembly_accession request.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(V1alpha1AssemblyDatasetDescriptors, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['assembly_accession', 'cutoff', 'limit', 'filters_refseq_only', 'tax_exact_match']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method assembly_descriptors_by_accession" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'assembly_accession' is set
        if self.api_client.client_side_validation and ('assembly_accession' not in local_var_params or  # noqa: E501
                                                        local_var_params['assembly_accession'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `assembly_accession` when calling `assembly_descriptors_by_accession`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'assembly_accession' in local_var_params:
            path_params['assembly_accession'] = local_var_params['assembly_accession']  # noqa: E501

        query_params = []
        if 'cutoff' in local_var_params and local_var_params['cutoff'] is not None:  # noqa: E501
            query_params.append(('cutoff', local_var_params['cutoff']))  # noqa: E501
        if 'limit' in local_var_params and local_var_params['limit'] is not None:  # noqa: E501
            query_params.append(('limit', local_var_params['limit']))  # noqa: E501
        if 'filters_refseq_only' in local_var_params and local_var_params['filters_refseq_only'] is not None:  # noqa: E501
            query_params.append(('filters.refseq_only', local_var_params['filters_refseq_only']))  # noqa: E501
        if 'tax_exact_match' in local_var_params and local_var_params['tax_exact_match'] is not None:  # noqa: E501
            query_params.append(('tax_exact_match', local_var_params['tax_exact_match']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/assembly_descriptors/accession/{assembly_accession}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='V1alpha1AssemblyDatasetDescriptors',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def assembly_descriptors_by_organism(self, tax_name, **kwargs):  # noqa: E501
        """Assembly descriptions by taxonomic name (scientific or common name at any tax rank)  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.assembly_descriptors_by_organism(tax_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str tax_name: (required)
        :param int cutoff: Limit the number of results for the above query term.
        :param str limit: Limit the number of returned results (\"all\", \"none\", otherwise an integer value).
        :param bool filters_refseq_only: If true, only return RefSeq (GCF_) assemblies.
        :param bool tax_exact_match: If true, only return assemblies with the given NCBI Taxonomy ID, or name. Otherwise, assemblies from taxonomy subtree are included, too. Ignored for assembly_accession request.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: V1alpha1AssemblyDatasetDescriptors
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.assembly_descriptors_by_organism_with_http_info(tax_name, **kwargs)  # noqa: E501

    def assembly_descriptors_by_organism_with_http_info(self, tax_name, **kwargs):  # noqa: E501
        """Assembly descriptions by taxonomic name (scientific or common name at any tax rank)  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.assembly_descriptors_by_organism_with_http_info(tax_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str tax_name: (required)
        :param int cutoff: Limit the number of results for the above query term.
        :param str limit: Limit the number of returned results (\"all\", \"none\", otherwise an integer value).
        :param bool filters_refseq_only: If true, only return RefSeq (GCF_) assemblies.
        :param bool tax_exact_match: If true, only return assemblies with the given NCBI Taxonomy ID, or name. Otherwise, assemblies from taxonomy subtree are included, too. Ignored for assembly_accession request.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(V1alpha1AssemblyDatasetDescriptors, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['tax_name', 'cutoff', 'limit', 'filters_refseq_only', 'tax_exact_match']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method assembly_descriptors_by_organism" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'tax_name' is set
        if self.api_client.client_side_validation and ('tax_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['tax_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `tax_name` when calling `assembly_descriptors_by_organism`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'tax_name' in local_var_params:
            path_params['tax_name'] = local_var_params['tax_name']  # noqa: E501

        query_params = []
        if 'cutoff' in local_var_params and local_var_params['cutoff'] is not None:  # noqa: E501
            query_params.append(('cutoff', local_var_params['cutoff']))  # noqa: E501
        if 'limit' in local_var_params and local_var_params['limit'] is not None:  # noqa: E501
            query_params.append(('limit', local_var_params['limit']))  # noqa: E501
        if 'filters_refseq_only' in local_var_params and local_var_params['filters_refseq_only'] is not None:  # noqa: E501
            query_params.append(('filters.refseq_only', local_var_params['filters_refseq_only']))  # noqa: E501
        if 'tax_exact_match' in local_var_params and local_var_params['tax_exact_match'] is not None:  # noqa: E501
            query_params.append(('tax_exact_match', local_var_params['tax_exact_match']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/assembly_descriptors/organism/{tax_name}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='V1alpha1AssemblyDatasetDescriptors',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def assembly_descriptors_by_taxid(self, tax_id, **kwargs):  # noqa: E501
        """Assembly descriptions by taxonomy ID  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.assembly_descriptors_by_taxid(tax_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int tax_id: NCBI Taxonomy ID (required)
        :param int cutoff: Limit the number of results for the above query term.
        :param str limit: Limit the number of returned results (\"all\", \"none\", otherwise an integer value).
        :param bool filters_refseq_only: If true, only return RefSeq (GCF_) assemblies.
        :param bool tax_exact_match: If true, only return assemblies with the given NCBI Taxonomy ID, or name. Otherwise, assemblies from taxonomy subtree are included, too. Ignored for assembly_accession request.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: V1alpha1AssemblyDatasetDescriptors
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.assembly_descriptors_by_taxid_with_http_info(tax_id, **kwargs)  # noqa: E501

    def assembly_descriptors_by_taxid_with_http_info(self, tax_id, **kwargs):  # noqa: E501
        """Assembly descriptions by taxonomy ID  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.assembly_descriptors_by_taxid_with_http_info(tax_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int tax_id: NCBI Taxonomy ID (required)
        :param int cutoff: Limit the number of results for the above query term.
        :param str limit: Limit the number of returned results (\"all\", \"none\", otherwise an integer value).
        :param bool filters_refseq_only: If true, only return RefSeq (GCF_) assemblies.
        :param bool tax_exact_match: If true, only return assemblies with the given NCBI Taxonomy ID, or name. Otherwise, assemblies from taxonomy subtree are included, too. Ignored for assembly_accession request.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(V1alpha1AssemblyDatasetDescriptors, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['tax_id', 'cutoff', 'limit', 'filters_refseq_only', 'tax_exact_match']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method assembly_descriptors_by_taxid" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'tax_id' is set
        if self.api_client.client_side_validation and ('tax_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['tax_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `tax_id` when calling `assembly_descriptors_by_taxid`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'tax_id' in local_var_params:
            path_params['tax_id'] = local_var_params['tax_id']  # noqa: E501

        query_params = []
        if 'cutoff' in local_var_params and local_var_params['cutoff'] is not None:  # noqa: E501
            query_params.append(('cutoff', local_var_params['cutoff']))  # noqa: E501
        if 'limit' in local_var_params and local_var_params['limit'] is not None:  # noqa: E501
            query_params.append(('limit', local_var_params['limit']))  # noqa: E501
        if 'filters_refseq_only' in local_var_params and local_var_params['filters_refseq_only'] is not None:  # noqa: E501
            query_params.append(('filters.refseq_only', local_var_params['filters_refseq_only']))  # noqa: E501
        if 'tax_exact_match' in local_var_params and local_var_params['tax_exact_match'] is not None:  # noqa: E501
            query_params.append(('tax_exact_match', local_var_params['tax_exact_match']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/assembly_descriptors/taxid/{tax_id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='V1alpha1AssemblyDatasetDescriptors',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)
