// Cytosim was created by Francois Nedelec. Copyright 2007-2017 EMBL.
// Created by Francois Nedelec on 08/08/2010.

#include "gle_color_list.h"
#include "exceptions.h"
#include <iomanip>

/// list of unnamed colors
static gle_color nice_colors[] = {
    0xFFFFFFFF,
    0xFFA500FF,
    0x00BB00FF,
    0x3366FFFF,
    0x7D7D7DFF,
    0x3366FFFF,
    0xFF4500FF,
    0xFFFF00FF,
    0xAFD7FFFF,
    0xAF7559FF,
    0x00FF00FF,
    0x2E8B57FF,
    0x98FFB3FF,
    0xFF0065FF,
    0xFF00FFFF,
    0xFFA500FF,
    0xFF6575FF,
    0xFFABBBFF,
    0xA020F0FF,
    0xFF0000FF,
    0x00FA6DFF,
    0xEE82EEFF,
    0xAAAAAAFF,
    0x3A90FFFF,
    0x00FFFFFF,
    0xF6F675FF,
    0xFC9CAAFF};

/// List of Francois's named colors
gle::named_color std_colors[] = {
    {"dark_gray",     0x404040FF},
    {"aquamarine",    0x66DDAAFF},
    {"azur",          0xF0FFFFFF},
    {"beige",         0x908470FF},
    {"black",         0x000000FF},
    {"blue",          0x0000FFFF},
    {"blue_tint",     0xAFD7FFFF},
    {"brick_red",     0x990000FF},
    {"brown",         0xAF7559FF},
    {"burgundy",      0x800000FF},
    {"coral",         0xF76541FF},
    {"crimson",       0xCC0033FF},
    {"cyan",          0x00FFFFFF},
    {"dark_blue",     0x000080FF},
    {"dark_green",    0x008000FF},
    {"dark_orange",   0xAA6E00FF},
    {"dark_purple",   0x800080FF},
    {"dark_red",      0x800000FF},
    {"dark_yellow",   0x808000FF},
    {"darker_blue",   0x000040FF},
    {"darker_gray",   0x202020FF},
    {"darker_green",  0x004000FF},
    {"darker_purple", 0x400040FF},
    {"darker_red",    0x400000FF},
    {"darker_yellow", 0x404000FF},
    {"darker_orange", 0x714900FF},
    {"darkest_gray",  0x101010FF},
    {"darkest_green", 0x002000FF},
    {"darkest_purple",0x200020FF},
    {"darkest_red",   0x200000FF},
    {"darkest_yellow",0x202000FF},
    {"darker_orange", 0x714900FF},
    {"dull_blue",     0x006699FF},
    {"fire_brick",    0x800517FF},
    {"forest_green",  0x808000FF},
    {"fuscia",        0xFF00FFFF},
    {"flesh",         0xF4D3B4FF},
    {"gold",          0xD4A017FF},
    {"grass_green",   0x408080FF},
    {"gray",          0x707070FF},
    {"grey",          0x707070FF},
    {"green",         0x00EE00FF},
    {"green_blue",    0x2E8B57FF},
    {"green_tint",    0x98FFB3FF},
    {"hot_pink",      0xFF66CCFF},
    {"indigo",        0x4B0082FF},
    {"invisible",     0x00000000},
    {"khaki",         0xADA96EFF},
    {"lavender",      0x9966CCFF},
    {"light_blue",    0x8888FFFF},
    {"light_gray",    0xA0A0A0FF},
    {"light_green",   0x88FF88FF},
    {"light_purple",  0xFF0080FF},
    {"light_red",     0xFF4444FF},
    {"lime",          0x00FF00FF},
    {"magenta",       0xFF00FFFF},
    {"maroon",        0x810541FF},
    {"mauve",         0xCC3366FF},
    {"midnight",      0x003366FF},
    {"navy",          0x000080FF},
    {"none",          0x00000000},
    {"olive",         0x808000FF},
    {"orange",        0xFFA500FF},
    {"pastel_green",  0x00FF00FF},
    {"pink",          0xE7A1B0FF},
    {"pink_tint",     0xFFABBBFF},
    {"plum",          0xB93B8FFF},
    {"pumpkin",       0xFF9933FF},
    {"purple",        0x8E35EFFF},
    {"red",           0xFF0000FF},
    {"red_orange",    0xFF4500FF},
    {"royal_blue",    0x2B60DEFF},
    {"salmon",        0xFA8072FF},
    {"sea_green",     0x00FA6DFF},
    {"sienna",        0x8A4117FF},
    {"sky_blue",      0x3A90FFFF},
    {"steel_blue",    0x4863A0FF},
    {"turquoise",     0x00FFFFFF},
    {"violet",        0x8D38C9FF},
    {"white",         0xFFFFFFFF},
    {"yellow",        0xFFFF00FF},
    {"yellow_tint",   0xF6F675FF}
};


/// standard named HTML colors
gle::named_color html_colors[] = {
    {"AliceBlue",            0xF0F8FFFF},
    {"AntiqueWhite",         0xFAEBD7FF},
    {"Aqua",                 0x00FFFFFF},
    {"Aquamarine",           0x7FFFD4FF},
    {"Azure",                0xF0FFFFFF},
    {"Beige",                0xF5F5DCFF},
    {"Bisque",               0xFFE4C4FF},
    {"Black",                0x000000FF},
    {"BlanchedAlmond",       0xFFEBCDFF},
    {"Blue",                 0x0000FFFF},
    {"BlueViolet",           0x8A2BE2FF},
    {"Brown",                0xA52A2AFF},
    {"BurlyWood",            0xDEB887FF},
    {"CadetBlue",            0x5F9EA0FF},
    {"Chartreuse",           0x7FFF00FF},
    {"Chocolate",            0xD2691EFF},
    {"Coral",                0xFF7F50FF},
    {"CornflowerBlue",       0x6495EDFF},
    {"Cornsilk",             0xFFF8DCFF},
    {"Crimson",              0xDC143CFF},
    {"Cyan",                 0x00FFFFFF},
    {"DarkBlue",             0x00008BFF},
    {"DarkCyan",             0x008B8BFF},
    {"DarkGoldenRod",        0xB8860BFF},
    {"DarkGray",             0xA9A9A9FF},
    {"DarkGrey",             0x808080FF},
    {"DarkGreen",            0x006400FF},
    {"DarkKhaki",            0xBDB76BFF},
    {"DarkMagenta",          0x8B008BFF},
    {"DarkOliveGreen",       0x556B2FFF},
    {"Darkorange",           0xFF8C00FF},
    {"DarkOrchid",           0x9932CCFF},
    {"DarkRed",              0x8B0000FF},
    {"DarkSalmon",           0xE9967AFF},
    {"DarkSeaGreen",         0x8FBC8FFF},
    {"DarkSlateBlue",        0x483D8BFF},
    {"DarkSlateGray",        0x2F4F4FFF},
    {"DarkSlateGrey",        0x2F4F4FFF},
    {"DarkTurquoise",        0x00CED1FF},
    {"DarkViolet",           0x9400D3FF},
    {"DeepPink",             0xFF1493FF},
    {"DeepSkyBlue",          0x00BFFFFF},
    {"DimGray",              0x696969FF},
    {"DimGrey",              0x696969FF},
    {"DodgerBlue",           0x1E90FFFF},
    {"FireBrick",            0xB22222FF},
    {"FloralWhite",          0xFFFAF0FF},
    {"ForestGreen",          0x228B22FF},
    {"Fuchsia",              0xFF00FFFF},
    {"Gainsboro",            0xDCDCDCFF},
    {"GhostWhite",           0xF8F8FFFF},
    {"Gold",                 0xFFD700FF},
    {"GoldenRod",            0xDAA520FF},
    {"Gray",                 0x808080FF},
    {"Grey",                 0x808080FF},
    {"Green",                0x008000FF},
    {"GreenYellow",          0xADFF2FFF},
    {"HoneyDew",             0xF0FFF0FF},
    {"HotPink",              0xFF69B4FF},
    {"IndianRed",            0xCD5C5CFF},
    {"Indigo",               0x4B0082FF},
    {"Ivory",                0xFFFFF0FF},
    {"Khaki",                0xF0E68CFF},
    {"Lavender",             0xE6E6FAFF},
    {"LavenderBlush",        0xFFF0F5FF},
    {"LawnGreen",            0x7CFC00FF},
    {"LemonChiffon",         0xFFFACDFF},
    {"LightBlue",            0xADD8E6FF},
    {"LightCoral",           0xF08080FF},
    {"LightCyan",            0xE0FFFFFF},
    {"LightGoldenRodYellow", 0xFAFAD2FF},
    {"LightGray",            0xD3D3D3FF},
    {"LightGrey",            0xD3D3D3FF},
    {"LightGreen",           0x90EE90FF},
    {"LightPink",            0xFFB6C1FF},
    {"LightSalmon",          0xFFA07AFF},
    {"LightSeaGreen",        0x20B2AAFF},
    {"LightSkyBlue",         0x87CEFAFF},
    {"LightSlateGray",       0x778899FF},
    {"LightSlateGrey",       0x778899FF},
    {"LightSteelBlue",       0xB0C4DEFF},
    {"LightYellow",          0xFFFFE0FF},
    {"Lime",                 0x00FF00FF},
    {"LimeGreen",            0x32CD32FF},
    {"Linen",                0xFAF0E6FF},
    {"Magenta",              0xFF00FFFF},
    {"Maroon",               0x800000FF},
    {"MediumAquaMarine",     0x66CDAAFF},
    {"MediumBlue",           0x0000CDFF},
    {"MediumOrchid",         0xBA55D3FF},
    {"MediumPurple",         0x9370D8FF},
    {"MediumSeaGreen",       0x3CB371FF},
    {"MediumSlateBlue",      0x7B68EEFF},
    {"MediumSpringGreen",    0x00FA9AFF},
    {"MediumTurquoise",      0x48D1CCFF},
    {"MediumVioletRed",      0xC71585FF},
    {"MidnightBlue",         0x191970FF},
    {"MintCream",            0xF5FFFAFF},
    {"MistyRose",            0xFFE4E1FF},
    {"Moccasin",             0xFFE4B5FF},
    {"NavajoWhite",          0xFFDEADFF},
    {"Navy",                 0x000080FF},
    {"OldLace",              0xFDF5E6FF},
    {"Olive",                0x808000FF},
    {"OliveDrab",            0x6B8E23FF},
    {"Orange",               0xFFA500FF},
    {"OrangeRed",            0xFF4500FF},
    {"Orchid",               0xDA70D6FF},
    {"PaleGoldenRod",        0xEEE8AAFF},
    {"PaleGreen",            0x98FB98FF},
    {"PaleTurquoise",        0xAFEEEEFF},
    {"PaleVioletRed",        0xD87093FF},
    {"PapayaWhip",           0xFFEFD5FF},
    {"PeachPuff",            0xFFDAB9FF},
    {"Peru",                 0xCD853FFF},
    {"Pink",                 0xFFC0CBFF},
    {"Plum",                 0xDDA0DDFF},
    {"PowderBlue",           0xB0E0E6FF},
    {"Purple",               0x800080FF},
    {"Red",                  0xFF0000FF},
    {"RosyBrown",            0xBC8F8FFF},
    {"RoyalBlue",            0x4169E1FF},
    {"SaddleBrown",          0x8B4513FF},
    {"Salmon",               0xFA8072FF},
    {"SandyBrown",           0xF4A460FF},
    {"SeaGreen",             0x2E8B57FF},
    {"SeaShell",             0xFFF5EEFF},
    {"Sienna",               0xA0522DFF},
    {"Silver",               0xC0C0C0FF},
    {"SkyBlue",              0x87CEEBFF},
    {"SlateBlue",            0x6A5ACDFF},
    {"SlateGray",            0x708090FF},
    {"SlateGrey",            0x708090FF},
    {"Snow",                 0xFFFAFAFF},
    {"SpringGreen",          0x00FF7FFF},
    {"SteelBlue",            0x4682B4FF},
    {"Tan",                  0xD2B48CFF},
    {"Teal",                 0x008080FF},
    {"Thistle",              0xD8BFD8FF},
    {"Tomato",               0xFF6347FF},
    {"Turquoise",            0x40E0D0FF},
    {"Violet",               0xEE82EEFF},
    {"Wheat",                0xF5DEB3FF},
    {"White",                0xFFFFFFFF},
    {"WhiteSmoke",           0xF5F5F5FF},
    {"Yellow",               0xFFFF00FF},
    {"YellowGreen",          0x9ACD32FF}
};


/// a list of ~256 colors from Crayola crayons
gle::named_color crayola_colors[] = {
    {"Absolute Zero",         0x0048BAFF},
    {"Almond",                0xEFDECDFF},
    {"Alien Armpit",          0x84DE02FF},
    {"Amethyst",              0x64609AFF},
    {"Amazon Forest",         0x92F646FF},
    {"Antique Brass",         0xCD9575FF},
    {"Apricot",               0xFDD9B5FF},
    {"Aqua",                  0x5FBED7FF},
    {"Aquamarine",            0x78DBE2FF},
    {"Asparagus",             0x87A96BFF},
    {"Atomic Tangerine",      0xFFA474FF},
    {"Aztec Gold",            0xC39953FF},
    {"Baby Powder",           0xfefefaFF},
    {"Banana",                0xffd12aFF},
    {"Banana Mania",          0xFAE7B5FF},
    {"Beaver",                0x9F8170FF},
    {"Bittersweet",           0xFD7C6EFF},
    {"Big Foot Feet",         0xE88E5AFF},
    {"Black",                 0x000000FF},
    {"Black Coral",           0x54626FFF},
    {"Black Shadows",         0xBFAFB2FF},
    {"Blueberry",             0x4f86f7FF},
    {"Blizzard Blue",         0xACE5EEFF},
    {"Blue",                  0x1F75FEFF},
    {"Blue Bell",             0xA2A2D0FF},
    {"Blue Gray",             0x6699CCFF},
    {"Blue Green",            0x0D98BAFF},
    {"Blue Jeans",            0x5DADECFF},
    {"Blue Violet",           0x7366BDFF},
    {"Blush",                 0xDE5D83FF},
    {"Booger Buster",         0xDDE26AFF},
    {"Brick Red",             0xCB4154FF},
    {"Bright Yellow",         0xFFAA1DFF},
    {"Brown",                 0xB4674DFF},
    {"Brown Sugar",           0xAF6E4DFF},
    {"Bubble Gum",            0xffd3f8FF},
    {"Burnished Brown",       0xA17A74FF},
    {"Burnt Orange",          0xFF7F49FF},
    {"Burnt Sienna",          0xEA7E5DFF},
    {"Cadet Blue",            0xB0B7C6FF},
    {"Canary",                0xFFFF99FF},
    {"Caribbean Green",       0x1CD3A2FF},
    {"Caribbean Current",     0x5D8DDFFF},
    {"Carnation Pink",        0xFFAACCFF},
    {"Cedar Chest",           0xc95a49FF},
    {"Cerise",                0xDD4492FF},
    {"Cerulean",              0x1DACD6FF},
    {"Cerulean Frost",        0x6D9BC3FF},
    {"Cherry",                0xda2647FF},
    {"Chestnut",              0xBC5D58FF},
    {"Chocolate",             0xbd8260FF},
    {"Cinnamon Satin",        0xCD607EFF},
    {"Citrine",               0x933709FF},
    {"Coconut",               0xfefefeFF},
    {"Copper",                0xDD9475FF},
    {"Copper Penny",          0xAD6F69FF},
    {"Cornflower",            0x9ACEEBFF},
    {"Cosmic Cobalt",         0x2E2D88FF},
    {"Cotton Candy",          0xFFBCD9FF},
    {"Cultured",              0xF5F5F5FF},
    {"Daffodil",              0xffff31FF},
    {"Dandelion",             0xFDDB6DFF},
    {"Denim",                 0x2B6CC4FF},
    {"Denim Blue",            0x2243B6FF},
    {"Desert Sand",           0xEFCDB8FF},
    {"Digy Dungeon",          0xC53151FF},
    {"Dirt",                  0x9b7653FF},
    {"Eerie Black",           0x1B1B1BFF},
    {"Eggplant",              0x6E5160FF},
    {"Electric Lime",         0xCEFF1DFF},
    {"Emerald",               0x14A989FF},
    {"Eucalyptus",            0x44d7a8FF},
    {"Fern",                  0x71BC78FF},
    {"Fiery Rose",            0xFF5470FF},
    {"Florida Sunrise",       0xFFB329FF},
    {"Forest Green",          0x6DAE81FF},
    {"Fresh Air",             0xa6e7ffFF},
    {"Frostbite",             0xE936A7FF},
    {"Fuchsia",               0xC364C5FF},
    {"Fuzzy Wuzzy",           0xCC6666FF},
    {"Gargoyle Gas",          0xFFDF46FF},
    {"Giant's Club",          0xB05C52FF},
    {"Glossy Grape",          0xAB92B3FF},
    {"Gold",                  0xE7C697FF},
    {"Goldenrod",             0xFCD975FF},
    {"Grand Canyon",          0x6D3834FF},
    {"Granite Gray",          0x676767FF},
    {"Granny Smith Apple",    0xA8E4A0FF},
    {"Grape",                 0x6f2da8FF},
    {"Gray",                  0x95918CFF},
    {"Green",                 0x1CAC78FF},
    {"Green Blue",            0x1164B4FF},
    {"Green Lizard",          0xA7F432FF},
    {"Green Sheen",           0x6EAEA1FF},
    {"Green Yellow",          0xF0E891FF},
    {"Heat Wave",             0xFF7A00FF},
    {"Hot Magenta",           0xFF1DCEFF},
    {"Inchworm",              0xB2EC5DFF},
    {"Indigo",                0x5D76CBFF},
    {"Jade",                  0x469A84FF},
    {"Jasper",                0xD05340FF},
    {"Jazzberry Jam",         0xCA3767FF},
    {"Jelly Bean",            0xda614eFF},
    {"Jungle Green",          0x3BB08FFF},
    {"Key Lime",              0xE8F48CFF},
    {"Lapis Lazuli",          0x436CB9FF},
    {"Laser Lemon",           0xFEFE22FF},
    {"Lavender",              0xFCB4D5FF},
    {"Leather Jacket",        0x253529FF},
    {"Lemon",                 0xffff38FF},
    {"Lemon Glacier",         0xFDFF00FF},
    {"Lemon Yellow",          0xFFF44FFF},
    {"Licorice",              0x1a1110FF},
    {"Lilac",                 0xdb91efFF},
    {"Lime",                  0xb2f302FF},
    {"Lumber",                0xffe4cdFF},
    {"Macaroni and Cheese",   0xFFBD88FF},
    {"Maul Sunset",           0x8E599FFF},
    {"Magenta",               0xF664AFFF},
    {"Magic Mint",            0xAAF0D1FF},
    {"Magic Potion",          0xFF4466FF},
    {"Mahogany",              0xCD4A4CFF},
    {"Maize",                 0xEDD19CFF},
    {"Malachite",             0x469496FF},
    {"Manatee",               0x979AAAFF},
    {"Mandarin",              0xF37A48FF},
    {"Mango Tango",           0xFF8243FF},
    {"Maroon",                0xC8385AFF},
    {"Mauvelous",             0xEF98AAFF},
    {"Melon",                 0xFDBCB4FF},
    {"Midnight",              0x702670FF},
    {"Midnight Blue",         0x1A4876FF},
    {"Mystic Maroon",         0xAD4379FF},
    {"Misty Moss",            0xBBB477FF},
    {"Moonstone",             0x3AA8C1FF},
    {"Mountain Meadow",       0x30BA8FFF},
    {"Mulberry",              0xC54B8CFF},
    {"Mummy's Tomb",          0x828E84FF},
    {"Mystic",                0xD65282FF},
    {"Navy Blue",             0x1974D2FF},
    {"Neon Carrot",           0xFFA343FF},
    {"New Car",               0x214fc6FF},
    {"Ocean Blue",            0x4F42B5FF},
    {"Ocean Green",           0x48BF91FF},
    {"Olive Green",           0xBAB86CFF},
    {"Onyx",                  0x353839FF},
    {"Orange",                0xFF7538FF},
    {"Orange Red",            0xFF2B2BFF},
    {"Orange Scent",          0xff8866FF},
    {"Orange Soda",           0xFA5B3DFF},
    {"Orange Yellow",         0xF8D568FF},
    {"Orchid",                0xE6A8D7FF},
    {"Outer Space",           0x414A4CFF},
    {"Outrageous Orange",     0xFF6E4AFF},
    {"Pacific Blue",          0x1CA9C9FF},
    {"Peach",                 0xFFCFABFF},
    {"Peach Scent",           0xffd0b9FF},
    {"Pearly Purple",         0xB768A2FF},
    {"Peridot",               0xABAD48FF},
    {"Periwinkle",            0xC5D0E6FF},
    {"Pewter Blue",           0x8BA8B7FF},
    {"Piggy Pink",            0xFDDDE6FF},
    {"Pine",                  0x45a27dFF},
    {"Pine Green",            0x158078FF},
    {"Pink Flamingo",         0xFC74FDFF},
    {"Pink Pearl",            0xB07080FF},
    {"Pink Sherbert",         0xF78FA7FF},
    {"Pixie Powder",          0x391285FF},
    {"Plum",                  0x8E4585FF},
    {"Plump Purple",          0x5946B2FF},
    {"Polished Pine",         0x5DA493FF},
    {"Princess Perfume",      0xFF85CFFF},
    {"Purple Heart",          0x7442C8FF},
    {"Purple Plum",           0x9C51B6FF},
    {"Purple Majesty",        0x9D81BAFF},
    {"Purple Pizzazz",        0xFE4EDAFF},
    {"Quick Silver",          0xA6A6A6FF},
    {"Radical Red",           0xFF496CFF},
    {"Raw Sienna",            0xD68A59FF},
    {"Raw Umber",             0x714B23FF},
    {"Razzle Dazzle Rose",    0xFF48D0FF},
    {"Razzmatazz",            0xE3256BFF},
    {"Red",                   0xEE204DFF},
    {"Red Orange",            0xFF5349FF},
    {"Red Violet",            0xC0448FFF},
    {"Red Salsa",             0xFD3A4AFF},
    {"Robin's Egg Blue",      0x1FCECBFF},
    {"Rose",                  0xff5050FF},
    {"Rose Dust",             0x9E5E6FFF},
    {"Rose Quartz",           0xBD559CFF},
    {"Royal Purple",          0x7851A9FF},
    {"Ruby",                  0xAA4069FF},
    {"Rusty Red",             0xDA2C43FF},
    {"Salmon",                0xFF9BAAFF},
    {"Salmon Pink",           0xF1444AFF},
    {"Sapphire",              0x2D5DA1FF},
    {"Sasquatch Socks",       0xFF4681FF},
    {"Scarlet",               0xFC2847FF},
    {"Screamin' Green",       0x76FF7AFF},
    {"Sea Green",             0x9FE2BFFF},
    {"Sepia",                 0xA5694FFF},
    {"Shadow",                0x8A795DFF},
    {"Shadow Blue",           0x778BA5FF},
    {"Shampoo",               0xffcff1FF},
    {"Shamrock",              0x45CEA2FF},
    {"Shiny Shamrock",        0x5FA778FF},
    {"Shocking Pink",         0xFB7EFDFF},
    {"Silver",                0xCDC5C2FF},
    {"Sizzling Red",          0xFF3855FF},
    {"Sizzling Sunrise",      0xFFDB00FF},
    {"Sahara Desert",         0xF5CBBDFF},
    {"Sky Blue",              0x80DAEBFF},
    {"Slimy Green",           0x299617FF},
    {"Smoke",                 0x738276FF},
    {"Smashed Pumpkin",       0xFF6D3AFF},
    {"Smokey Topaz",          0x832A0DFF},
    {"Soap",                  0xcec8efFF},
    {"Spring Frost",          0x87FF2AFF},
    {"Spring Green",          0xECEABEFF},
    {"Steel Teal",            0x5F8A8BFF},
    {"Strawberry",            0xfc5a8dFF},
    {"Sugar Plum",            0x914E75FF},
    {"Sunburnt Cyclops",      0xFF404CFF},
    {"Sunglow",               0xFFCF48FF},
    {"Sunset",                0xF1CC79FF},
    {"Sunset Orange",         0xFD5E53FF},
    {"Sunny",                 0xF2F27AFF},
    {"Sweet Brown",           0xA83731FF},
    {"Tan",                   0xFAA76CFF},
    {"Tart Orange",           0xFB4D46FF},
    {"Teal Blue",             0x18A7B5FF},
    {"Thistle",               0xEBC7DFFF},
    {"Tickle Me Pink",        0xFC89ACFF},
    {"Tiger's Eye",           0xB56917FF},
    {"Timberwolf",            0xDBD7D2FF},
    {"Tropical Rain Forest",  0x17806DFF},
    {"Tulip",                 0xff878dFF},
    {"Tumbleweed",            0xDEAA88FF},
    {"Turquoise",             0x3BBCD0FF},
    {"Turquoise Blue",        0x77DDE7FF},
    {"Twilight Lavender",     0x8A496BFF},
    {"Unmellow Yellow",       0xFFFF66FF},
    {"Violet (Purple)",       0x926EAEFF},
    {"Violet Blue",           0x324AB2FF},
    {"Violet Red",            0xF75394FF},
    {"Vivid Tangerine",       0xFFA089FF},
    {"Vivid Violet",          0x8F509DFF},
    {"White",                 0xFFFFFFFF},
    {"Wild Blue Yonder",      0xA2ADD0FF},
    {"Wild Strawberry",       0xFF43A4FF},
    {"Wild Watermelon",       0xFC6C85FF},
    {"Winter Sky",            0xFF007CFF},
    {"Winter Wizard",         0xA0E6FFFF},
    {"Wintergreen Dream",     0x56887DFF},
    {"Wisteria",              0xCDA4DEFF},
    {"Yellow",                0xFCE883FF},
    {"Yellow Green",          0xC5E384FF},
    {"Yellow Orange",         0xFFAE42FF},
    {"Yellow Sunshine",       0xFFF700FF},
    {"Yosemite Campfire",     0xED4C44FF}
};


/// People's 949 popular colors, from the XKCD project
// License: http://creativecommons.org/publicdomain/zero/1.0/
gle::named_color xkcd_colors[] = {
    {"cloudy_blue",           0xacc2d9ff},
    {"dark_pastel_green",     0x56ae57ff},
    {"dust",                  0xb2996eff},
    {"electric_lime",         0xa8ff04ff},
    {"fresh_green",           0x69d84fff},
    {"light_eggplant",        0x894585ff},
    {"nasty_green",           0x70b23fff},
    {"really_light_blue",     0xd4ffffff},
    {"tea",                   0x65ab7cff},
    {"warm_purple",           0x952e8fff},
    {"yellowish_tan",         0xfcfc81ff},
    {"cement",                0xa5a391ff},
    {"dark_grass_green",      0x388004ff},
    {"dusty_teal",            0x4c9085ff},
    {"grey_teal",             0x5e9b8aff},
    {"macaroni_and_cheese",   0xefb435ff},
    {"pinkish_tan",           0xd99b82ff},
    {"spruce",                0x0a5f38ff},
    {"strong_blue",           0x0c06f7ff},
    {"toxic_green",           0x61de2aff},
    {"windows_blue",          0x3778bfff},
    {"blue_blue",             0x2242c7ff},
    {"blue_with_purple",      0x533cc6ff},
    {"booger",                0x9bb53cff},
    {"bright_sea_green",      0x05ffa6ff},
    {"dark_green_blue",       0x1f6357ff},
    {"deep_turquoise",        0x017374ff},
    {"green_teal",            0x0cb577ff},
    {"strong_pink",           0xff0789ff},
    {"bland",                 0xafa88bff},
    {"deep_aqua",             0x08787fff},
    {"lavender_pink",         0xdd85d7ff},
    {"light_moss_green",      0xa6c875ff},
    {"light_seafoam_green",   0xa7ffb5ff},
    {"olive_yellow",          0xc2b709ff},
    {"pig_pink",              0xe78ea5ff},
    {"deep_lilac",            0x966ebdff},
    {"desert",                0xccad60ff},
    {"dusty_lavender",        0xac86a8ff},
    {"purpley_grey",          0x947e94ff},
    {"purply",                0x983fb2ff},
    {"candy_pink",            0xff63e9ff},
    {"light_pastel_green",    0xb2fba5ff},
    {"boring_green",          0x63b365ff},
    {"kiwi_green",            0x8ee53fff},
    {"light_grey_green",      0xb7e1a1ff},
    {"orange_pink",           0xff6f52ff},
    {"tea_green",             0xbdf8a3ff},
    {"very_light_brown",      0xd3b683ff},
    {"egg_shell",             0xfffcc4ff},
    {"eggplant_purple",       0x430541ff},
    {"powder_pink",           0xffb2d0ff},
    {"reddish_grey",          0x997570ff},
    {"baby_shit_brown",       0xad900dff},
    {"liliac",                0xc48efdff},
    {"stormy_blue",           0x507b9cff},
    {"ugly_brown",            0x7d7103ff},
    {"custard",               0xfffd78ff},
    {"darkish_pink",          0xda467dff},
    {"deep_brown",            0x410200ff},
    {"greenish_beige",        0xc9d179ff},
    {"manilla",               0xfffa86ff},
    {"off_blue",              0x5684aeff},
    {"battleship_grey",       0x6b7c85ff},
    {"browny_green",          0x6f6c0aff},
    {"bruise",                0x7e4071ff},
    {"kelley_green",          0x009337ff},
    {"sickly_yellow",         0xd0e429ff},
    {"sunny_yellow",          0xfff917ff},
    {"azul",                  0x1d5decff},
    {"darkgreen",             0x054907ff},
    {"green_yellow",          0xb5ce08ff},
    {"lichen",                0x8fb67bff},
    {"light_light_green",     0xc8ffb0ff},
    {"pale_gold",             0xfdde6cff},
    {"sun_yellow",            0xffdf22ff},
    {"tan_green",             0xa9be70ff},
    {"burple",                0x6832e3ff},
    {"butterscotch",          0xfdb147ff},
    {"toupe",                 0xc7ac7dff},
    {"dark_cream",            0xfff39aff},
    {"indian_red",            0x850e04ff},
    {"light_lavendar",        0xefc0feff},
    {"poison_green",          0x40fd14ff},
    {"baby_puke_green",       0xb6c406ff},
    {"bright_yellow_green",   0x9dff00ff},
    {"charcoal_grey",         0x3c4142ff},
    {"squash",                0xf2ab15ff},
    {"cinnamon",              0xac4f06ff},
    {"light_pea_green",       0xc4fe82ff},
    {"radioactive_green",     0x2cfa1fff},
    {"raw_sienna",            0x9a6200ff},
    {"baby_purple",           0xca9bf7ff},
    {"cocoa",                 0x875f42ff},
    {"light_royal_blue",      0x3a2efeff},
    {"orangeish",             0xfd8d49ff},
    {"rust_brown",            0x8b3103ff},
    {"sand_brown",            0xcba560ff},
    {"swamp",                 0x698339ff},
    {"tealish_green",         0x0cdc73ff},
    {"burnt_siena",           0xb75203ff},
    {"camo",                  0x7f8f4eff},
    {"dusk_blue",             0x26538dff},
    {"fern",                  0x63a950ff},
    {"old_rose",              0xc87f89ff},
    {"pale_light_green",      0xb1fc99ff},
    {"peachy_pink",           0xff9a8aff},
    {"rosy_pink",             0xf6688eff},
    {"light_bluish_green",    0x76fda8ff},
    {"light_bright_green",    0x53fe5cff},
    {"light_neon_green",      0x4efd54ff},
    {"light_seafoam",         0xa0febfff},
    {"tiffany_blue",          0x7bf2daff},
    {"washed_out_green",      0xbcf5a6ff},
    {"browny_orange",         0xca6b02ff},
    {"nice_blue",             0x107ab0ff},
    {"sapphire",              0x2138abff},
    {"greyish_teal",          0x719f91ff},
    {"orangey_yellow",        0xfdb915ff},
    {"parchment",             0xfefcafff},
    {"straw",                 0xfcf679ff},
    {"very_dark_brown",       0x1d0200ff},
    {"terracota",             0xcb6843ff},
    {"ugly_blue",             0x31668aff},
    {"clear_blue",            0x247afdff},
    {"creme",                 0xffffb6ff},
    {"foam_green",            0x90fda9ff},
    {"grey_green",            0x86a17dff},
    {"light_gold",            0xfddc5cff},
    {"seafoam_blue",          0x78d1b6ff},
    {"topaz",                 0x13bbafff},
    {"violet_pink",           0xfb5ffcff},
    {"wintergreen",           0x20f986ff},
    {"yellow_tan",            0xffe36eff},
    {"dark_fuchsia",          0x9d0759ff},
    {"indigo_blue",           0x3a18b1ff},
    {"light_yellowish_green",  0xc2ff89ff},
    {"pale_magenta",          0xd767adff},
    {"rich_purple",           0x720058ff},
    {"sunflower_yellow",      0xffda03ff},
    {"green_blue",            0x01c08dff},
    {"leather",               0xac7434ff},
    {"racing_green",          0x014600ff},
    {"vivid_purple",          0x9900faff},
    {"dark_royal_blue",       0x02066fff},
    {"hazel",                 0x8e7618ff},
    {"muted_pink",            0xd1768fff},
    {"booger_green",          0x96b403ff},
    {"canary",                0xfdff63ff},
    {"cool_grey",             0x95a3a6ff},
    {"dark_taupe",            0x7f684eff},
    {"darkish_purple",        0x751973ff},
    {"true_green",            0x089404ff},
    {"coral_pink",            0xff6163ff},
    {"dark_sage",             0x598556ff},
    {"dark_slate_blue",       0x214761ff},
    {"flat_blue",             0x3c73a8ff},
    {"mushroom",              0xba9e88ff},
    {"rich_blue",             0x021bf9ff},
    {"dirty_purple",          0x734a65ff},
    {"greenblue",             0x23c48bff},
    {"icky_green",            0x8fae22ff},
    {"light_khaki",           0xe6f2a2ff},
    {"warm_blue",             0x4b57dbff},
    {"dark_hot_pink",         0xd90166ff},
    {"deep_sea_blue",         0x015482ff},
    {"carmine",               0x9d0216ff},
    {"dark_yellow_green",     0x728f02ff},
    {"pale_peach",            0xffe5adff},
    {"plum_purple",           0x4e0550ff},
    {"golden_rod",            0xf9bc08ff},
    {"neon_red",              0xff073aff},
    {"old_pink",              0xc77986ff},
    {"very_pale_blue",        0xd6fffeff},
    {"blood_orange",          0xfe4b03ff},
    {"grapefruit",            0xfd5956ff},
    {"sand_yellow",           0xfce166ff},
    {"clay_brown",            0xb2713dff},
    {"dark_blue_grey",        0x1f3b4dff},
    {"flat_green",            0x699d4cff},
    {"light_green_blue",      0x56fca2ff},
    {"warm_pink",             0xfb5581ff},
    {"dodger_blue",           0x3e82fcff},
    {"gross_green",           0xa0bf16ff},
    {"ice",                   0xd6fffaff},
    {"metallic_blue",         0x4f738eff},
    {"pale_salmon",           0xffb19aff},
    {"sap_green",             0x5c8b15ff},
    {"algae",                 0x54ac68ff},
    {"bluey_grey",            0x89a0b0ff},
    {"greeny_grey",           0x7ea07aff},
    {"highlighter_green",     0x1bfc06ff},
    {"light_light_blue",      0xcafffbff},
    {"light_mint",            0xb6ffbbff},
    {"raw_umber",             0xa75e09ff},
    {"vivid_blue",            0x152effff},
    {"deep_lavender",         0x8d5eb7ff},
    {"dull_teal",             0x5f9e8fff},
    {"light_greenish_blue",   0x63f7b4ff},
    {"mud_green",             0x606602ff},
    {"pinky",                 0xfc86aaff},
    {"red_wine",              0x8c0034ff},
    {"shit_green",            0x758000ff},
    {"tan_brown",             0xab7e4cff},
    {"darkblue",              0x030764ff},
    {"rosa",                  0xfe86a4ff},
    {"lipstick",              0xd5174eff},
    {"pale_mauve",            0xfed0fcff},
    {"claret",                0x680018ff},
    {"dandelion",             0xfedf08ff},
    {"orangered",             0xfe420fff},
    {"poop_green",            0x6f7c00ff},
    {"ruby",                  0xca0147ff},
    {"dark",                  0x1b2431ff},
    {"greenish_turquoise",    0x00fbb0ff},
    {"pastel_red",            0xdb5856ff},
    {"piss_yellow",           0xddd618ff},
    {"bright_cyan",           0x41fdfeff},
    {"dark_coral",            0xcf524eff},
    {"algae_green",           0x21c36fff},
    {"darkish_red",           0xa90308ff},
    {"reddy_brown",           0x6e1005ff},
    {"blush_pink",            0xfe828cff},
    {"camouflage_green",      0x4b6113ff},
    {"lawn_green",            0x4da409ff},
    {"putty",                 0xbeae8aff},
    {"vibrant_blue",          0x0339f8ff},
    {"dark_sand",             0xa88f59ff},
    {"purple_blue",           0x5d21d0ff},
    {"saffron",               0xfeb209ff},
    {"twilight",              0x4e518bff},
    {"warm_brown",            0x964e02ff},
    {"bluegrey",              0x85a3b2ff},
    {"bubble_gum_pink",       0xff69afff},
    {"duck_egg_blue",         0xc3fbf4ff},
    {"greenish_cyan",         0x2afeb7ff},
    {"petrol",                0x005f6aff},
    {"royal",                 0x0c1793ff},
    {"butter",                0xffff81ff},
    {"dusty_orange",          0xf0833aff},
    {"off_yellow",            0xf1f33fff},
    {"pale_olive_green",      0xb1d27bff},
    {"orangish",              0xfc824aff},
    {"leaf",                  0x71aa34ff},
    {"light_blue_grey",       0xb7c9e2ff},
    {"dried_blood",           0x4b0101ff},
    {"lightish_purple",       0xa552e6ff},
    {"rusty_red",             0xaf2f0dff},
    {"lavender_blue",         0x8b88f8ff},
    {"light_grass_green",     0x9af764ff},
    {"light_mint_green",      0xa6fbb2ff},
    {"sunflower",             0xffc512ff},
    {"velvet",                0x750851ff},
    {"brick_orange",          0xc14a09ff},
    {"lightish_red",          0xfe2f4aff},
    {"pure_blue",             0x0203e2ff},
    {"twilight_blue",         0x0a437aff},
    {"violet_red",            0xa50055ff},
    {"yellowy_brown",         0xae8b0cff},
    {"carnation",             0xfd798fff},
    {"muddy_yellow",          0xbfac05ff},
    {"dark_seafoam_green",    0x3eaf76ff},
    {"deep_rose",             0xc74767ff},
    {"dusty_red",             0xb9484eff},
    {"grey_blue",             0x647d8eff},
    {"lemon_lime",            0xbffe28ff},
    {"purple_pink",           0xd725deff},
    {"brown_yellow",          0xb29705ff},
    {"purple_brown",          0x673a3fff},
    {"wisteria",              0xa87dc2ff},
    {"banana_yellow",         0xfafe4bff},
    {"lipstick_red",          0xc0022fff},
    {"water_blue",            0x0e87ccff},
    {"brown_grey",            0x8d8468ff},
    {"vibrant_purple",        0xad03deff},
    {"baby_green",            0x8cff9eff},
    {"barf_green",            0x94ac02ff},
    {"eggshell_blue",         0xc4fff7ff},
    {"sandy_yellow",          0xfdee73ff},
    {"cool_green",            0x33b864ff},
    {"pale",                  0xfff9d0ff},
    {"blue_grey",             0x758da3ff},
    {"hot_magenta",           0xf504c9ff},
    {"greyblue",              0x77a1b5ff},
    {"purpley",               0x8756e4ff},
    {"baby_shit_green",       0x889717ff},
    {"brownish_pink",         0xc27e79ff},
    {"dark_aquamarine",       0x017371ff},
    {"diarrhea",              0x9f8303ff},
    {"light_mustard",         0xf7d560ff},
    {"pale_sky_blue",         0xbdf6feff},
    {"turtle_green",          0x75b84fff},
    {"bright_olive",          0x9cbb04ff},
    {"dark_grey_blue",        0x29465bff},
    {"greeny_brown",          0x696006ff},
    {"lemon_green",           0xadf802ff},
    {"light_periwinkle",      0xc1c6fcff},
    {"seaweed_green",         0x35ad6bff},
    {"sunshine_yellow",       0xfffd37ff},
    {"ugly_purple",           0xa442a0ff},
    {"medium_pink",           0xf36196ff},
    {"puke_brown",            0x947706ff},
    {"very_light_pink",       0xfff4f2ff},
    {"viridian",              0x1e9167ff},
    {"bile",                  0xb5c306ff},
    {"faded_yellow",          0xfeff7fff},
    {"very_pale_green",       0xcffdbcff},
    {"vibrant_green",         0x0add08ff},
    {"bright_lime",           0x87fd05ff},
    {"spearmint",             0x1ef876ff},
    {"light_aquamarine",      0x7bfdc7ff},
    {"light_sage",            0xbcecacff},
    {"yellowgreen",           0xbbf90fff},
    {"baby_poo",              0xab9004ff},
    {"dark_seafoam",          0x1fb57aff},
    {"deep_teal",             0x00555aff},
    {"heather",               0xa484acff},
    {"rust_orange",           0xc45508ff},
    {"dirty_blue",            0x3f829dff},
    {"fern_green",            0x548d44ff},
    {"bright_lilac",          0xc95efbff},
    {"weird_green",           0x3ae57fff},
    {"peacock_blue",          0x016795ff},
    {"avocado_green",         0x87a922ff},
    {"faded_orange",          0xf0944dff},
    {"grape_purple",          0x5d1451ff},
    {"hot_green",             0x25ff29ff},
    {"lime_yellow",           0xd0fe1dff},
    {"mango",                 0xffa62bff},
    {"shamrock",              0x01b44cff},
    {"bubblegum",             0xff6cb5ff},
    {"purplish_brown",        0x6b4247ff},
    {"vomit_yellow",          0xc7c10cff},
    {"pale_cyan",             0xb7fffaff},
    {"key_lime",              0xaeff6eff},
    {"tomato_red",            0xec2d01ff},
    {"lightgreen",            0x76ff7bff},
    {"merlot",                0x730039ff},
    {"night_blue",            0x040348ff},
    {"purpleish_pink",        0xdf4ec8ff},
    {"apple",                 0x6ecb3cff},
    {"baby_poop_green",       0x8f9805ff},
    {"green_apple",           0x5edc1fff},
    {"heliotrope",            0xd94ff5ff},
    {"yellow_green",          0xc8fd3dff},
    {"almost_black",          0x070d0dff},
    {"cool_blue",             0x4984b8ff},
    {"leafy_green",           0x51b73bff},
    {"mustard_brown",         0xac7e04ff},
    {"dusk",                  0x4e5481ff},
    {"dull_brown",            0x876e4bff},
    {"frog_green",            0x58bc08ff},
    {"vivid_green",           0x2fef10ff},
    {"bright_light_green",    0x2dfe54ff},
    {"fluro_green",           0x0aff02ff},
    {"kiwi",                  0x9cef43ff},
    {"seaweed",               0x18d17bff},
    {"navy_green",            0x35530aff},
    {"ultramarine_blue",      0x1805dbff},
    {"iris",                  0x6258c4ff},
    {"pastel_orange",         0xff964fff},
    {"yellowish_orange",      0xffab0fff},
    {"perrywinkle",           0x8f8ce7ff},
    {"tealish",               0x24bca8ff},
    {"dark_plum",             0x3f012cff},
    {"pear",                  0xcbf85fff},
    {"pinkish_orange",        0xff724cff},
    {"midnight_purple",       0x280137ff},
    {"light_urple",           0xb36ff6ff},
    {"dark_mint",             0x48c072ff},
    {"greenish_tan",          0xbccb7aff},
    {"light_burgundy",        0xa8415bff},
    {"turquoise_blue",        0x06b1c4ff},
    {"ugly_pink",             0xcd7584ff},
    {"sandy",                 0xf1da7aff},
    {"electric_pink",         0xff0490ff},
    {"muted_purple",          0x805b87ff},
    {"mid_green",             0x50a747ff},
    {"greyish",               0xa8a495ff},
    {"neon_yellow",           0xcfff04ff},
    {"banana",                0xffff7eff},
    {"carnation_pink",        0xff7fa7ff},
    {"tomato",                0xef4026ff},
    {"sea",                   0x3c9992ff},
    {"muddy_brown",           0x886806ff},
    {"turquoise_green",       0x04f489ff},
    {"buff",                  0xfef69eff},
    {"fawn",                  0xcfaf7bff},
    {"muted_blue",            0x3b719fff},
    {"pale_rose",             0xfdc1c5ff},
    {"dark_mint_green",       0x20c073ff},
    {"amethyst",              0x9b5fc0ff},
    {"blue_green",            0x0f9b8eff},
    {"chestnut",              0x742802ff},
    {"sick_green",            0x9db92cff},
    {"pea",                   0xa4bf20ff},
    {"rusty_orange",          0xcd5909ff},
    {"stone",                 0xada587ff},
    {"rose_red",              0xbe013cff},
    {"pale_aqua",             0xb8ffebff},
    {"deep_orange",           0xdc4d01ff},
    {"earth",                 0xa2653eff},
    {"mossy_green",           0x638b27ff},
    {"grassy_green",          0x419c03ff},
    {"pale_lime_green",       0xb1ff65ff},
    {"light_grey_blue",       0x9dbcd4ff},
    {"pale_grey",             0xfdfdfeff},
    {"asparagus",             0x77ab56ff},
    {"blueberry",             0x464196ff},
    {"purple_red",            0x990147ff},
    {"pale_lime",             0xbefd73ff},
    {"greenish_teal",         0x32bf84ff},
    {"caramel",               0xaf6f09ff},
    {"deep_magenta",          0xa0025cff},
    {"light_peach",           0xffd8b1ff},
    {"milk_chocolate",        0x7f4e1eff},
    {"ocher",                 0xbf9b0cff},
    {"off_green",             0x6ba353ff},
    {"purply_pink",           0xf075e6ff},
    {"lightblue",             0x7bc8f6ff},
    {"dusky_blue",            0x475f94ff},
    {"golden",                0xf5bf03ff},
    {"light_beige",           0xfffeb6ff},
    {"butter_yellow",         0xfffd74ff},
    {"dusky_purple",          0x895b7bff},
    {"french_blue",           0x436badff},
    {"ugly_yellow",           0xd0c101ff},
    {"greeny_yellow",         0xc6f808ff},
    {"orangish_red",          0xf43605ff},
    {"shamrock_green",        0x02c14dff},
    {"orangish_brown",        0xb25f03ff},
    {"tree_green",            0x2a7e19ff},
    {"deep_violet",           0x490648ff},
    {"gunmetal",              0x536267ff},
    {"blue_purple",           0x5a06efff},
    {"cherry",                0xcf0234ff},
    {"sandy_brown",           0xc4a661ff},
    {"warm_grey",             0x978a84ff},
    {"dark_indigo",           0x1f0954ff},
    {"midnight",              0x03012dff},
    {"bluey_green",           0x2bb179ff},
    {"grey_pink",             0xc3909bff},
    {"soft_purple",           0xa66fb5ff},
    {"blood",                 0x770001ff},
    {"brown_red",             0x922b05ff},
    {"medium_grey",           0x7d7f7cff},
    {"berry",                 0x990f4bff},
    {"poo",                   0x8f7303ff},
    {"purpley_pink",          0xc83cb9ff},
    {"light_salmon",          0xfea993ff},
    {"snot",                  0xacbb0dff},
    {"easter_purple",         0xc071feff},
    {"light_yellow_green",    0xccfd7fff},
    {"dark_navy_blue",        0x00022eff},
    {"drab",                  0x828344ff},
    {"light_rose",            0xffc5cbff},
    {"rouge",                 0xab1239ff},
    {"purplish_red",          0xb0054bff},
    {"slime_green",           0x99cc04ff},
    {"baby_poop",             0x937c00ff},
    {"irish_green",           0x019529ff},
    {"pink_purple",           0xef1de7ff},
    {"dark_navy",             0x000435ff},
    {"greeny_blue",           0x42b395ff},
    {"light_plum",            0x9d5783ff},
    {"pinkish_grey",          0xc8aca9ff},
    {"dirty_orange",          0xc87606ff},
    {"rust_red",              0xaa2704ff},
    {"pale_lilac",            0xe4cbffff},
    {"orangey_red",           0xfa4224ff},
    {"primary_blue",          0x0804f9ff},
    {"kermit_green",          0x5cb200ff},
    {"brownish_purple",       0x76424eff},
    {"murky_green",           0x6c7a0eff},
    {"wheat",                 0xfbdd7eff},
    {"very_dark_purple",      0x2a0134ff},
    {"bottle_green",          0x044a05ff},
    {"watermelon",            0xfd4659ff},
    {"deep_sky_blue",         0x0d75f8ff},
    {"fire_engine_red",       0xfe0002ff},
    {"yellow_ochre",          0xcb9d06ff},
    {"pumpkin_orange",        0xfb7d07ff},
    {"pale_olive",            0xb9cc81ff},
    {"light_lilac",           0xedc8ffff},
    {"lightish_green",        0x61e160ff},
    {"carolina_blue",         0x8ab8feff},
    {"mulberry",              0x920a4eff},
    {"shocking_pink",         0xfe02a2ff},
    {"auburn",                0x9a3001ff},
    {"bright_lime_green",     0x65fe08ff},
    {"celadon",               0xbefdb7ff},
    {"pinkish_brown",         0xb17261ff},
    {"poo_brown",             0x885f01ff},
    {"bright_sky_blue",       0x02ccfeff},
    {"celery",                0xc1fd95ff},
    {"dirt_brown",            0x836539ff},
    {"strawberry",            0xfb2943ff},
    {"dark_lime",             0x84b701ff},
    {"copper",                0xb66325ff},
    {"medium_brown",          0x7f5112ff},
    {"muted_green",           0x5fa052ff},
    {"robins_egg",            0x6dedfdff},
    {"bright_aqua",           0x0bf9eaff},
    {"bright_lavender",       0xc760ffff},
    {"ivory",                 0xffffcbff},
    {"very_light_purple",     0xf6cefcff},
    {"light_navy",            0x155084ff},
    {"pink_red",              0xf5054fff},
    {"olive_brown",           0x645403ff},
    {"poop_brown",            0x7a5901ff},
    {"mustard_green",         0xa8b504ff},
    {"ocean_green",           0x3d9973ff},
    {"very_dark_blue",        0x000133ff},
    {"dusty_green",           0x76a973ff},
    {"light_navy_blue",       0x2e5a88ff},
    {"minty_green",           0x0bf77dff},
    {"adobe",                 0xbd6c48ff},
    {"barney",                0xac1db8ff},
    {"jade_green",            0x2baf6aff},
    {"bright_light_blue",     0x26f7fdff},
    {"light_lime",            0xaefd6cff},
    {"dark_khaki",            0x9b8f55ff},
    {"orange_yellow",         0xffad01ff},
    {"ocre",                  0xc69c04ff},
    {"maize",                 0xf4d054ff},
    {"faded_pink",            0xde9dacff},
    {"british_racing_green",  0x05480dff},
    {"sandstone",             0xc9ae74ff},
    {"mud_brown",             0x60460fff},
    {"light_sea_green",       0x98f6b0ff},
    {"robin_egg_blue",        0x8af1feff},
    {"aqua_marine",           0x2ee8bbff},
    {"dark_sea_green",        0x11875dff},
    {"soft_pink",             0xfdb0c0ff},
    {"orangey_brown",         0xb16002ff},
    {"cherry_red",            0xf7022aff},
    {"burnt_yellow",          0xd5ab09ff},
    {"brownish_grey",         0x86775fff},
    {"camel",                 0xc69f59ff},
    {"purplish_grey",         0x7a687fff},
    {"marine",                0x042e60ff},
    {"greyish_pink",          0xc88d94ff},
    {"pale_turquoise",        0xa5fbd5ff},
    {"pastel_yellow",         0xfffe71ff},
    {"bluey_purple",          0x6241c7ff},
    {"canary_yellow",         0xfffe40ff},
    {"faded_red",             0xd3494eff},
    {"sepia",                 0x985e2bff},
    {"coffee",                0xa6814cff},
    {"bright_magenta",        0xff08e8ff},
    {"mocha",                 0x9d7651ff},
    {"ecru",                  0xfeffcaff},
    {"purpleish",             0x98568dff},
    {"cranberry",             0x9e003aff},
    {"darkish_green",         0x287c37ff},
    {"brown_orange",          0xb96902ff},
    {"dusky_rose",            0xba6873ff},
    {"melon",                 0xff7855ff},
    {"sickly_green",          0x94b21cff},
    {"silver",                0xc5c9c7ff},
    {"purply_blue",           0x661aeeff},
    {"purpleish_blue",        0x6140efff},
    {"hospital_green",        0x9be5aaff},
    {"shit_brown",            0x7b5804ff},
    {"mid_blue",              0x276ab3ff},
    {"amber",                 0xfeb308ff},
    {"easter_green",          0x8cfd7eff},
    {"soft_blue",             0x6488eaff},
    {"cerulean_blue",         0x056eeeff},
    {"golden_brown",          0xb27a01ff},
    {"bright_turquoise",      0x0ffef9ff},
    {"red_pink",              0xfa2a55ff},
    {"red_purple",            0x820747ff},
    {"greyish_brown",         0x7a6a4fff},
    {"vermillion",            0xf4320cff},
    {"russet",                0xa13905ff},
    {"steel_grey",            0x6f828aff},
    {"lighter_purple",        0xa55af4ff},
    {"bright_violet",         0xad0afdff},
    {"prussian_blue",         0x004577ff},
    {"slate_green",           0x658d6dff},
    {"dirty_pink",            0xca7b80ff},
    {"dark_blue_green",       0x005249ff},
    {"pine",                  0x2b5d34ff},
    {"yellowy_green",         0xbff128ff},
    {"dark_gold",             0xb59410ff},
    {"bluish",                0x2976bbff},
    {"darkish_blue",          0x014182ff},
    {"dull_red",              0xbb3f3fff},
    {"pinky_red",             0xfc2647ff},
    {"bronze",                0xa87900ff},
    {"pale_teal",             0x82cbb2ff},
    {"military_green",        0x667c3eff},
    {"barbie_pink",           0xfe46a5ff},
    {"bubblegum_pink",        0xfe83ccff},
    {"pea_soup_green",        0x94a617ff},
    {"dark_mustard",          0xa88905ff},
    {"shit",                  0x7f5f00ff},
    {"medium_purple",         0x9e43a2ff},
    {"very_dark_green",       0x062e03ff},
    {"dirt",                  0x8a6e45ff},
    {"dusky_pink",            0xcc7a8bff},
    {"red_violet",            0x9e0168ff},
    {"lemon_yellow",          0xfdff38ff},
    {"pistachio",             0xc0fa8bff},
    {"dull_yellow",           0xeedc5bff},
    {"dark_lime_green",       0x7ebd01ff},
    {"denim_blue",            0x3b5b92ff},
    {"teal_blue",             0x01889fff},
    {"lightish_blue",         0x3d7afdff},
    {"purpley_blue",          0x5f34e7ff},
    {"light_indigo",          0x6d5acfff},
    {"swamp_green",           0x748500ff},
    {"brown_green",           0x706c11ff},
    {"dark_maroon",           0x3c0008ff},
    {"hot_purple",            0xcb00f5ff},
    {"dark_forest_green",     0x002d04ff},
    {"faded_blue",            0x658cbbff},
    {"drab_green",            0x749551ff},
    {"light_lime_green",      0xb9ff66ff},
    {"snot_green",            0x9dc100ff},
    {"yellowish",             0xfaee66ff},
    {"light_blue_green",      0x7efbb3ff},
    {"bordeaux",              0x7b002cff},
    {"light_mauve",           0xc292a1ff},
    {"ocean",                 0x017b92ff},
    {"marigold",              0xfcc006ff},
    {"muddy_green",           0x657432ff},
    {"dull_orange",           0xd8863bff},
    {"steel",                 0x738595ff},
    {"electric_purple",       0xaa23ffff},
    {"fluorescent_green",     0x08ff08ff},
    {"yellowish_brown",       0x9b7a01ff},
    {"blush",                 0xf29e8eff},
    {"soft_green",            0x6fc276ff},
    {"bright_orange",         0xff5b00ff},
    {"lemon",                 0xfdff52ff},
    {"purple_grey",           0x866f85ff},
    {"acid_green",            0x8ffe09ff},
    {"pale_lavender",         0xeecffeff},
    {"violet_blue",           0x510ac9ff},
    {"light_forest_green",    0x4f9153ff},
    {"burnt_red",             0x9f2305ff},
    {"khaki_green",           0x728639ff},
    {"cerise",                0xde0c62ff},
    {"faded_purple",          0x916e99ff},
    {"apricot",               0xffb16dff},
    {"dark_olive_green",      0x3c4d03ff},
    {"grey_brown",            0x7f7053ff},
    {"green_grey",            0x77926fff},
    {"true_blue",             0x010fccff},
    {"pale_violet",           0xceaefaff},
    {"periwinkle_blue",       0x8f99fbff},
    {"light_sky_blue",        0xc6fcffff},
    {"blurple",               0x5539ccff},
    {"green_brown",           0x544e03ff},
    {"bluegreen",             0x017a79ff},
    {"bright_teal",           0x01f9c6ff},
    {"brownish_yellow",       0xc9b003ff},
    {"pea_soup",              0x929901ff},
    {"forest",                0x0b5509ff},
    {"barney_purple",         0xa00498ff},
    {"ultramarine",           0x2000b1ff},
    {"purplish",              0x94568cff},
    {"puke_yellow",           0xc2be0eff},
    {"bluish_grey",           0x748b97ff},
    {"dark_periwinkle",       0x665fd1ff},
    {"dark_lilac",            0x9c6da5ff},
    {"reddish",               0xc44240ff},
    {"light_maroon",          0xa24857ff},
    {"dusty_purple",          0x825f87ff},
    {"terra_cotta",           0xc9643bff},
    {"avocado",               0x90b134ff},
    {"marine_blue",           0x01386aff},
    {"teal_green",            0x25a36fff},
    {"slate_grey",            0x59656dff},
    {"lighter_green",         0x75fd63ff},
    {"electric_green",        0x21fc0dff},
    {"dusty_blue",            0x5a86adff},
    {"golden_yellow",         0xfec615ff},
    {"bright_yellow",         0xfffd01ff},
    {"light_lavender",        0xdfc5feff},
    {"umber",                 0xb26400ff},
    {"poop",                  0x7f5e00ff},
    {"dark_peach",            0xde7e5dff},
    {"jungle_green",          0x048243ff},
    {"eggshell",              0xffffd4ff},
    {"denim",                 0x3b638cff},
    {"yellow_brown",          0xb79400ff},
    {"dull_purple",           0x84597eff},
    {"chocolate_brown",       0x411900ff},
    {"wine_red",              0x7b0323ff},
    {"neon_blue",             0x04d9ffff},
    {"dirty_green",           0x667e2cff},
    {"light_tan",             0xfbeeacff},
    {"ice_blue",              0xd7fffeff},
    {"cadet_blue",            0x4e7496ff},
    {"dark_mauve",            0x874c62ff},
    {"very_light_blue",       0xd5ffffff},
    {"grey_purple",           0x826d8cff},
    {"pastel_pink",           0xffbacdff},
    {"very_light_green",      0xd1ffbdff},
    {"dark_sky_blue",         0x448ee4ff},
    {"evergreen",             0x05472aff},
    {"dull_pink",             0xd5869dff},
    {"aubergine",             0x3d0734ff},
    {"mahogany",              0x4a0100ff},
    {"reddish_orange",        0xf8481cff},
    {"deep_green",            0x02590fff},
    {"vomit_green",           0x89a203ff},
    {"purple_pink",           0xe03fd8ff},
    {"dusty_pink",            0xd58a94ff},
    {"faded_green",           0x7bb274ff},
    {"camo_green",            0x526525ff},
    {"pinky_purple",          0xc94cbeff},
    {"pink_purple",           0xdb4bdaff},
    {"brownish_red",          0x9e3623ff},
    {"dark_rose",             0xb5485dff},
    {"mud",                   0x735c12ff},
    {"brownish",              0x9c6d57ff},
    {"emerald_green",         0x028f1eff},
    {"pale_brown",            0xb1916eff},
    {"dull_blue",             0x49759cff},
    {"burnt_umber",           0xa0450eff},
    {"medium_green",          0x39ad48ff},
    {"clay",                  0xb66a50ff},
    {"light_aqua",            0x8cffdbff},
    {"light_olive_green",     0xa4be5cff},
    {"brownish_orange",       0xcb7723ff},
    {"dark_aqua",             0x05696bff},
    {"purplish_pink",         0xce5daeff},
    {"dark_salmon",           0xc85a53ff},
    {"greenish_grey",         0x96ae8dff},
    {"jade",                  0x1fa774ff},
    {"ugly_green",            0x7a9703ff},
    {"dark_beige",            0xac9362ff},
    {"emerald",               0x01a049ff},
    {"pale_red",              0xd9544dff},
    {"light_magenta",         0xfa5ff7ff},
    {"sky",                   0x82cafcff},
    {"light_cyan",            0xacfffcff},
    {"yellow_orange",         0xfcb001ff},
    {"reddish_purple",        0x910951ff},
    {"reddish_pink",          0xfe2c54ff},
    {"orchid",                0xc875c4ff},
    {"dirty_yellow",          0xcdc50aff},
    {"orange_red",            0xfd411eff},
    {"deep_red",              0x9a0200ff},
    {"orange_brown",          0xbe6400ff},
    {"cobalt_blue",           0x030aa7ff},
    {"neon_pink",             0xfe019aff},
    {"rose_pink",             0xf7879aff},
    {"greyish_purple",        0x887191ff},
    {"raspberry",             0xb00149ff},
    {"aqua_green",            0x12e193ff},
    {"salmon_pink",           0xfe7b7cff},
    {"tangerine",             0xff9408ff},
    {"brownish_green",        0x6a6e09ff},
    {"red_brown",             0x8b2e16ff},
    {"greenish_brown",        0x696112ff},
    {"pumpkin",               0xe17701ff},
    {"pine_green",            0x0a481eff},
    {"charcoal",              0x343837ff},
    {"baby_pink",             0xffb7ceff},
    {"cornflower",            0x6a79f7ff},
    {"blue_violet",           0x5d06e9ff},
    {"chocolate",             0x3d1c02ff},
    {"greyish_green",         0x82a67dff},
    {"scarlet",               0xbe0119ff},
    {"green_yellow",          0xc9ff27ff},
    {"dark_olive",            0x373e02ff},
    {"sienna",                0xa9561eff},
    {"pastel_purple",         0xcaa0ffff},
    {"terracotta",            0xca6641ff},
    {"aqua_blue",             0x02d8e9ff},
    {"sage_green",            0x88b378ff},
    {"blood_red",             0x980002ff},
    {"deep_pink",             0xcb0162ff},
    {"grass",                 0x5cac2dff},
    {"moss",                  0x769958ff},
    {"pastel_blue",           0xa2bffeff},
    {"bluish_green",          0x10a674ff},
    {"green_blue",            0x06b48bff},
    {"dark_tan",              0xaf884aff},
    {"greenish_blue",         0x0b8b87ff},
    {"pale_orange",           0xffa756ff},
    {"vomit",                 0xa2a415ff},
    {"forrest_green",         0x154406ff},
    {"dark_lavender",         0x856798ff},
    {"dark_violet",           0x34013fff},
    {"purple_blue",           0x632de9ff},
    {"dark_cyan",             0x0a888aff},
    {"olive_drab",            0x6f7632ff},
    {"pinkish",               0xd46a7eff},
    {"cobalt",                0x1e488fff},
    {"neon_purple",           0xbc13feff},
    {"light_turquoise",       0x7ef4ccff},
    {"apple_green",           0x76cd26ff},
    {"dull_green",            0x74a662ff},
    {"wine",                  0x80013fff},
    {"powder_blue",           0xb1d1fcff},
    {"off_white",             0xffffe4ff},
    {"electric_blue",         0x0652ffff},
    {"dark_turquoise",        0x045c5aff},
    {"blue_purple",           0x5729ceff},
    {"azure",                 0x069af3ff},
    {"bright_red",            0xff000dff},
    {"pinkish_red",           0xf10c45ff},
    {"cornflower_blue",       0x5170d7ff},
    {"light_olive",           0xacbf69ff},
    {"grape",                 0x6c3461ff},
    {"greyish_blue",          0x5e819dff},
    {"purplish_blue",         0x601ef9ff},
    {"yellowish_green",       0xb0dd16ff},
    {"greenish_yellow",       0xcdfd02ff},
    {"medium_blue",           0x2c6fbbff},
    {"dusty_rose",            0xc0737aff},
    {"light_violet",          0xd6b4fcff},
    {"midnight_blue",         0x020035ff},
    {"bluish_purple",         0x703be7ff},
    {"red_orange",            0xfd3c06ff},
    {"dark_magenta",          0x960056ff},
    {"greenish",              0x40a368ff},
    {"ocean_blue",            0x03719cff},
    {"coral",                 0xfc5a50ff},
    {"cream",                 0xffffc2ff},
    {"reddish_brown",         0x7f2b0aff},
    {"burnt_sienna",          0xb04e0fff},
    {"brick",                 0xa03623ff},
    {"sage",                  0x87ae73ff},
    {"grey_green",            0x789b73ff},
    {"white",                 0xffffffff},
    {"robins_egg_blue",       0x98eff9ff},
    {"moss_green",            0x658b38ff},
    {"steel_blue",            0x5a7d9aff},
    {"eggplant",              0x380835ff},
    {"light_yellow",          0xfffe7aff},
    {"leaf_green",            0x5ca904ff},
    {"light_grey",            0xd8dcd6ff},
    {"puke",                  0xa5a502ff},
    {"pinkish_purple",        0xd648d7ff},
    {"sea_blue",              0x047495ff},
    {"pale_purple",           0xb790d4ff},
    {"slate_blue",            0x5b7c99ff},
    {"blue_grey",             0x607c8eff},
    {"hunter_green",          0x0b4008ff},
    {"fuchsia",               0xed0dd9ff},
    {"crimson",               0x8c000fff},
    {"pale_yellow",           0xffff84ff},
    {"ochre",                 0xbf9005ff},
    {"mustard_yellow",        0xd2bd0aff},
    {"light_red",             0xff474cff},
    {"cerulean",              0x0485d1ff},
    {"pale_pink",             0xffcfdcff},
    {"deep_blue",             0x040273ff},
    {"rust",                  0xa83c09ff},
    {"light_teal",            0x90e4c1ff},
    {"slate",                 0x516572ff},
    {"goldenrod",             0xfac205ff},
    {"dark_yellow",           0xd5b60aff},
    {"dark_grey",             0x363737ff},
    {"army_green",            0x4b5d16ff},
    {"grey_blue",             0x6b8ba4ff},
    {"seafoam",               0x80f9adff},
    {"puce",                  0xa57e52ff},
    {"spring_green",          0xa9f971ff},
    {"dark_orange",           0xc65102ff},
    {"sand",                  0xe2ca76ff},
    {"pastel_green",          0xb0ff9dff},
    {"mint",                  0x9ffeb0ff},
    {"light_orange",          0xfdaa48ff},
    {"bright_pink",           0xfe01b1ff},
    {"chartreuse",            0xc1f80aff},
    {"deep_purple",           0x36013fff},
    {"dark_brown",            0x341c02ff},
    {"taupe",                 0xb9a281ff},
    {"pea_green",             0x8eab12ff},
    {"puke_green",            0x9aae07ff},
    {"kelly_green",           0x02ab2eff},
    {"seafoam_green",         0x7af9abff},
    {"blue_green",            0x137e6dff},
    {"khaki",                 0xaaa662ff},
    {"burgundy",              0x610023ff},
    {"dark_teal",             0x014d4eff},
    {"brick_red",             0x8f1402ff},
    {"royal_purple",          0x4b006eff},
    {"plum",                  0x580f41ff},
    {"mint_green",            0x8fff9fff},
    {"gold",                  0xdbb40cff},
    {"baby_blue",             0xa2cffeff},
    {"yellow_green",          0xc0fb2dff},
    {"bright_purple",         0xbe03fdff},
    {"dark_red",              0x840000ff},
    {"pale_blue",             0xd0fefeff},
    {"grass_green",           0x3f9b0bff},
    {"navy",                  0x01153eff},
    {"aquamarine",            0x04d8b2ff},
    {"burnt_orange",          0xc04e01ff},
    {"neon_green",            0x0cff0cff},
    {"bright_blue",           0x0165fcff},
    {"rose",                  0xcf6275ff},
    {"light_pink",            0xffd1dfff},
    {"mustard",               0xceb301ff},
    {"indigo",                0x380282ff},
    {"lime",                  0xaaff32ff},
    {"sea_green",             0x53fca1ff},
    {"periwinkle",            0x8e82feff},
    {"dark_pink",             0xcb416bff},
    {"olive_green",           0x677a04ff},
    {"peach",                 0xffb07cff},
    {"pale_green",            0xc7fdb5ff},
    {"light_brown",           0xad8150ff},
    {"hot_pink",              0xff028dff},
    {"black",                 0x000000ff},
    {"lilac",                 0xcea2fdff},
    {"navy_blue",             0x001146ff},
    {"royal_blue",            0x0504aaff},
    {"beige",                 0xe6daa6ff},
    {"salmon",                0xff796cff},
    {"olive",                 0x6e750eff},
    {"maroon",                0x650021ff},
    {"bright_green",          0x01ff07ff},
    {"dark_purple",           0x35063eff},
    {"mauve",                 0xae7181ff},
    {"forest_green",          0x06470cff},
    {"aqua",                  0x13eac9ff},
    {"cyan",                  0x00ffffff},
    {"tan",                   0xd1b26fff},
    {"dark_blue",             0x00035bff},
    {"lavender",              0xc79fefff},
    {"turquoise",             0x06c2acff},
    {"dark_green",            0x033500ff},
    {"violet",                0x9a0eeaff},
    {"light_purple",          0xbf77f6ff},
    {"lime_green",            0x89fe05ff},
    {"grey",                  0x929591ff},
    {"sky_blue",              0x75bbfdff},
    {"yellow",                0xffff14ff},
    {"magenta",               0xc20078ff},
    {"light_green",           0x96f97bff},
    {"orange",                0xf97306ff},
    {"teal",                  0x029386ff},
    {"light_blue",            0x95d0fcff},
    {"red",                   0xe50000ff},
    {"brown",                 0x653700ff},
    {"pink",                  0xff81c0ff},
    {"blue",                  0x0343dfff},
    {"green",                 0x15b01aff},
    {"purple",                0x7e1e9cff}
};


gle_color gle::std_color(unsigned indx)
{
    const size_t max = sizeof(std_colors) / sizeof(named_color);
    return std_colors[ indx % max ].hex;
}


gle_color gle::std_color(const std::string& name)
{
    const size_t max = sizeof(std_colors) / sizeof(named_color);
    
    for ( unsigned c = 0; c < max; ++c )
        if ( std_colors[c].name == name )
            return std_colors[c].hex;
    
    throw InvalidSyntax("Unknown color `"+name+"'");
    return 0xFFFFFFFF;
}


void gle::print_std_colors(std::ostream& os)
{
    os << "Known colors:" << std::endl;
    print_colors(os, std_colors, sizeof(std_colors)/sizeof(named_color));
}


gle_color gle::alt_color(unsigned indx)
{
    const size_t max = sizeof(crayola_colors) / sizeof(named_color);
    return crayola_colors[ indx % max ].hex;
}


/**
 extract all colors from the crayola list, that have a brightness between `minb` and `maxb`
 */

int gle::select_colors(gle_color* array, unsigned asize,
                       const GLfloat minb, const GLfloat maxb)
{
    const size_t max = sizeof(crayola_colors) / sizeof(named_color);

    unsigned nbc = 0;
    for ( unsigned c = 0; c < max; ++c )
    {
        gle_color col = crayola_colors[c].hex;
        if ( minb <= col.brightness()  &&  col.brightness() <= maxb )
            array[nbc++] = col;
        if ( nbc == asize )
            return nbc;
    }
    
    // always returns at least one color:
    if ( nbc == 0 && asize > 0 )
    {
        array[0] = 0xFFFFFFFF;
        nbc = 1;
    }
    
    return nbc;
}


/**
 return `indx`-th color from the crayola list, that has a brightness between `minb` and `maxb`
 */
gle_color gle::bright_color(unsigned indx, const GLfloat minb, const GLfloat maxb)
{
    const size_t max = sizeof(crayola_colors) / sizeof(named_color);

    static gle_color scolor[max];
    static GLfloat sminb = 0.6f, smaxb = 3;
    static unsigned scmax = select_colors(scolor, max, sminb, smaxb);

    if ( sminb != minb || smaxb != maxb )
    {
        sminb = minb;
        smaxb = maxb;
        scmax = select_colors(scolor, max, minb, maxb);
    }
    
    return scolor[indx%scmax];
}


gle_color gle::nice_color(unsigned indx)
{
    static constexpr unsigned max = sizeof(nice_colors) / sizeof(gle_color);
    
    return nice_colors[ indx % max ];
}


void gle::print_colors(std::ostream& os, named_color list[], unsigned max)
{    
    for ( unsigned c = 0; c < max; ++c )
    {
        os << std::setw(16) << list[c].name << "  ";
        os << gle_color( list[c].hex ) << std::endl;
    }
}


