# Tutorial: Basic Python Scripting

The objective of this tutorial is to write a Python program to analyse a number of simulations.

Author: Manuel Lera Ramirez, 13.09.2017

# Data

You are given a folder called "scan", it contains subfolders with name run????

Each of this subfolders corresponds to a simulation run. Each of them contains:

- The config file used to run the simulation.
- The .cmo files generated by the simulation.
- The "aster.txt" file: generated using the function "report aster"

The format is similar to the one shown below:

        % start   50
        % time    50
        %    class  identity  positionX positionY positionZ
                 1         1    0.3026    -0.389   -0.3367
        % end

a) This file contains comment lines preceded by the symbol "%", they give us information about what data is being
        displayed.

b) In the line without the comment symbol "%", we have the values corresponding to:

1. Class: In cytosim, everytime we use the command "set aster aster_class_name", we create a class of aster. In this case
            we only created one class, but we could have created more, and this number will indicate the index of the
            class of aster. The index corresponds to the order in which the asters where declared in the config file.

2. Identity: Every aster that we created using "new aster aster_class_name" gets an index, by order or creation,
            we could follow the same object in different frames using its identity.

3. positionX,positionY,positionZ: The values of x,y,z coordinates of the center of the aster at the last
            frame of the simulation.

# Objective

You have to create a python script that:

1. Collects the information from all the simulations of the distance of the aster to the center of the circle, and
    the length of the fibers of the aster.

2. Save that information into a file of the format:
    name_subfolder_1 length_1 distance_1
    name_subfolder_2 length_2 distance_2
    ...
    name_subfolder_n length_n distance_n

3. Do a scatter plot of length against distance

4. Save the plot to a png image

# More

Try to understand how the data was generated, go to the `code` folder.
"master.sh" is a bash script file that was used to generate the data, run the commands one by one in your shell and try to understand what they do. You can run a set of 30 new simualtions and report something else and then analyse that.

In order to use "master.sh" you will have to copy the executable "sim" file into the folder "code"

